package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDnsGtmAddressPool invokes the alidns.UpdateDnsGtmAddressPool API synchronously
func (client *Client) UpdateDnsGtmAddressPool(request *UpdateDnsGtmAddressPoolRequest) (response *UpdateDnsGtmAddressPoolResponse, err error) {
	response = CreateUpdateDnsGtmAddressPoolResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDnsGtmAddressPoolWithChan invokes the alidns.UpdateDnsGtmAddressPool API asynchronously
func (client *Client) UpdateDnsGtmAddressPoolWithChan(request *UpdateDnsGtmAddressPoolRequest) (<-chan *UpdateDnsGtmAddressPoolResponse, <-chan error) {
	responseChan := make(chan *UpdateDnsGtmAddressPoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDnsGtmAddressPool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDnsGtmAddressPoolWithCallback invokes the alidns.UpdateDnsGtmAddressPool API asynchronously
func (client *Client) UpdateDnsGtmAddressPoolWithCallback(request *UpdateDnsGtmAddressPoolRequest, callback func(response *UpdateDnsGtmAddressPoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDnsGtmAddressPoolResponse
		var err error
		defer close(result)
		response, err = client.UpdateDnsGtmAddressPool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDnsGtmAddressPoolRequest is the request struct for api UpdateDnsGtmAddressPool
type UpdateDnsGtmAddressPoolRequest struct {
	*requests.RpcRequest
	LbaStrategy  string                         `position:"Query" name:"LbaStrategy"`
	AddrPoolId   string                         `position:"Query" name:"AddrPoolId"`
	UserClientIp string                         `position:"Query" name:"UserClientIp"`
	Name         string                         `position:"Query" name:"Name"`
	Lang         string                         `position:"Query" name:"Lang"`
	Addr         *[]UpdateDnsGtmAddressPoolAddr `position:"Query" name:"Addr"  type:"Repeated"`
}

// UpdateDnsGtmAddressPoolAddr is a repeated param struct in UpdateDnsGtmAddressPoolRequest
type UpdateDnsGtmAddressPoolAddr struct {
	Mode          string `name:"Mode"`
	AttributeInfo string `name:"AttributeInfo"`
	Remark        string `name:"Remark"`
	Addr          string `name:"Addr"`
	LbaWeight     string `name:"LbaWeight"`
}

// UpdateDnsGtmAddressPoolResponse is the response struct for api UpdateDnsGtmAddressPool
type UpdateDnsGtmAddressPoolResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDnsGtmAddressPoolRequest creates a request to invoke UpdateDnsGtmAddressPool API
func CreateUpdateDnsGtmAddressPoolRequest() (request *UpdateDnsGtmAddressPoolRequest) {
	request = &UpdateDnsGtmAddressPoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "UpdateDnsGtmAddressPool", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateDnsGtmAddressPoolResponse creates a response to parse from UpdateDnsGtmAddressPool response
func CreateUpdateDnsGtmAddressPoolResponse() (response *UpdateDnsGtmAddressPoolResponse) {
	response = &UpdateDnsGtmAddressPoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
