package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRepoTrigger invokes the cr.DeleteRepoTrigger API synchronously
// api document: https://help.aliyun.com/api/cr/deleterepotrigger.html
func (client *Client) DeleteRepoTrigger(request *DeleteRepoTriggerRequest) (response *DeleteRepoTriggerResponse, err error) {
	response = CreateDeleteRepoTriggerResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRepoTriggerWithChan invokes the cr.DeleteRepoTrigger API asynchronously
// api document: https://help.aliyun.com/api/cr/deleterepotrigger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteRepoTriggerWithChan(request *DeleteRepoTriggerRequest) (<-chan *DeleteRepoTriggerResponse, <-chan error) {
	responseChan := make(chan *DeleteRepoTriggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRepoTrigger(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRepoTriggerWithCallback invokes the cr.DeleteRepoTrigger API asynchronously
// api document: https://help.aliyun.com/api/cr/deleterepotrigger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteRepoTriggerWithCallback(request *DeleteRepoTriggerRequest, callback func(response *DeleteRepoTriggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRepoTriggerResponse
		var err error
		defer close(result)
		response, err = client.DeleteRepoTrigger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRepoTriggerRequest is the request struct for api DeleteRepoTrigger
type DeleteRepoTriggerRequest struct {
	*requests.RpcRequest
	RepoId     string `position:"Query" name:"RepoId"`
	TriggerId  string `position:"Query" name:"TriggerId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DeleteRepoTriggerResponse is the response struct for api DeleteRepoTrigger
type DeleteRepoTriggerResponse struct {
	*responses.BaseResponse
	DeleteRepoTriggerIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                       string `json:"Code" xml:"Code"`
	RequestId                  string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteRepoTriggerRequest creates a request to invoke DeleteRepoTrigger API
func CreateDeleteRepoTriggerRequest() (request *DeleteRepoTriggerRequest) {
	request = &DeleteRepoTriggerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "DeleteRepoTrigger", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteRepoTriggerResponse creates a response to parse from DeleteRepoTrigger response
func CreateDeleteRepoTriggerResponse() (response *DeleteRepoTriggerResponse) {
	response = &DeleteRepoTriggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
