package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTask invokes the dbfs.ListTask API synchronously
func (client *Client) ListTask(request *ListTaskRequest) (response *ListTaskResponse, err error) {
	response = CreateListTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ListTaskWithChan invokes the dbfs.ListTask API asynchronously
func (client *Client) ListTaskWithChan(request *ListTaskRequest) (<-chan *ListTaskResponse, <-chan error) {
	responseChan := make(chan *ListTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTaskWithCallback invokes the dbfs.ListTask API asynchronously
func (client *Client) ListTaskWithCallback(request *ListTaskRequest, callback func(response *ListTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTaskResponse
		var err error
		defer close(result)
		response, err = client.ListTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTaskRequest is the request struct for api ListTask
type ListTaskRequest struct {
	*requests.RpcRequest
	SortType    string           `position:"Query" name:"SortType"`
	FilterValue string           `position:"Query" name:"FilterValue"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	FilterKey   string           `position:"Query" name:"FilterKey"`
	SortKey     string           `position:"Query" name:"SortKey"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListTaskResponse is the response struct for api ListTask
type ListTaskResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	TotalCount int         `json:"TotalCount" xml:"TotalCount"`
	PageNumber int         `json:"PageNumber" xml:"PageNumber"`
	PageSize   int         `json:"PageSize" xml:"PageSize"`
	Tasks      []TasksItem `json:"Tasks" xml:"Tasks"`
}

// CreateListTaskRequest creates a request to invoke ListTask API
func CreateListTaskRequest() (request *ListTaskRequest) {
	request = &ListTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "ListTask", "", "")
	request.Method = requests.POST
	return
}

// CreateListTaskResponse creates a response to parse from ListTask response
func CreateListTaskResponse() (response *ListTaskResponse) {
	response = &ListTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
