package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyContainerAppAttributes invokes the ehpc.ModifyContainerAppAttributes API synchronously
func (client *Client) ModifyContainerAppAttributes(request *ModifyContainerAppAttributesRequest) (response *ModifyContainerAppAttributesResponse, err error) {
	response = CreateModifyContainerAppAttributesResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyContainerAppAttributesWithChan invokes the ehpc.ModifyContainerAppAttributes API asynchronously
func (client *Client) ModifyContainerAppAttributesWithChan(request *ModifyContainerAppAttributesRequest) (<-chan *ModifyContainerAppAttributesResponse, <-chan error) {
	responseChan := make(chan *ModifyContainerAppAttributesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyContainerAppAttributes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyContainerAppAttributesWithCallback invokes the ehpc.ModifyContainerAppAttributes API asynchronously
func (client *Client) ModifyContainerAppAttributesWithCallback(request *ModifyContainerAppAttributesRequest, callback func(response *ModifyContainerAppAttributesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyContainerAppAttributesResponse
		var err error
		defer close(result)
		response, err = client.ModifyContainerAppAttributes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyContainerAppAttributesRequest is the request struct for api ModifyContainerAppAttributes
type ModifyContainerAppAttributesRequest struct {
	*requests.RpcRequest
	Description string `position:"Query" name:"Description"`
	ContainerId string `position:"Query" name:"ContainerId"`
}

// ModifyContainerAppAttributesResponse is the response struct for api ModifyContainerAppAttributes
type ModifyContainerAppAttributesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyContainerAppAttributesRequest creates a request to invoke ModifyContainerAppAttributes API
func CreateModifyContainerAppAttributesRequest() (request *ModifyContainerAppAttributesRequest) {
	request = &ModifyContainerAppAttributesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "ModifyContainerAppAttributes", "", "")
	request.Method = requests.GET
	return
}

// CreateModifyContainerAppAttributesResponse creates a response to parse from ModifyContainerAppAttributes response
func CreateModifyContainerAppAttributesResponse() (response *ModifyContainerAppAttributesResponse) {
	response = &ModifyContainerAppAttributesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
