package emas_appmonitor

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySingleDomainApiStatusCodeGroupTrend invokes the emas_appmonitor.QuerySingleDomainApiStatusCodeGroupTrend API synchronously
func (client *Client) QuerySingleDomainApiStatusCodeGroupTrend(request *QuerySingleDomainApiStatusCodeGroupTrendRequest) (response *QuerySingleDomainApiStatusCodeGroupTrendResponse, err error) {
	response = CreateQuerySingleDomainApiStatusCodeGroupTrendResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySingleDomainApiStatusCodeGroupTrendWithChan invokes the emas_appmonitor.QuerySingleDomainApiStatusCodeGroupTrend API asynchronously
func (client *Client) QuerySingleDomainApiStatusCodeGroupTrendWithChan(request *QuerySingleDomainApiStatusCodeGroupTrendRequest) (<-chan *QuerySingleDomainApiStatusCodeGroupTrendResponse, <-chan error) {
	responseChan := make(chan *QuerySingleDomainApiStatusCodeGroupTrendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySingleDomainApiStatusCodeGroupTrend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySingleDomainApiStatusCodeGroupTrendWithCallback invokes the emas_appmonitor.QuerySingleDomainApiStatusCodeGroupTrend API asynchronously
func (client *Client) QuerySingleDomainApiStatusCodeGroupTrendWithCallback(request *QuerySingleDomainApiStatusCodeGroupTrendRequest, callback func(response *QuerySingleDomainApiStatusCodeGroupTrendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySingleDomainApiStatusCodeGroupTrendResponse
		var err error
		defer close(result)
		response, err = client.QuerySingleDomainApiStatusCodeGroupTrend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySingleDomainApiStatusCodeGroupTrendRequest is the request struct for api QuerySingleDomainApiStatusCodeGroupTrend
type QuerySingleDomainApiStatusCodeGroupTrendRequest struct {
	*requests.RpcRequest
	AppVersionStrategy string           `position:"Body" name:"AppVersionStrategy"`
	StartTime          requests.Integer `position:"Body" name:"StartTime"`
	Group              string           `position:"Body" name:"Group"`
	IntervalMinutes    requests.Integer `position:"Body" name:"IntervalMinutes"`
	UniqueAppId        string           `position:"Body" name:"UniqueAppId"`
	EndTime            requests.Integer `position:"Body" name:"EndTime"`
	AppVersion         *[]string        `position:"Body" name:"AppVersion"  type:"Repeated"`
	Domain             string           `position:"Body" name:"Domain"`
}

// QuerySingleDomainApiStatusCodeGroupTrendResponse is the response struct for api QuerySingleDomainApiStatusCodeGroupTrend
type QuerySingleDomainApiStatusCodeGroupTrendResponse struct {
	*responses.BaseResponse
	RequestId        string             `json:"RequestId" xml:"RequestId"`
	MetricResultList []MetricResultItem `json:"MetricResultList" xml:"MetricResultList"`
}

// CreateQuerySingleDomainApiStatusCodeGroupTrendRequest creates a request to invoke QuerySingleDomainApiStatusCodeGroupTrend API
func CreateQuerySingleDomainApiStatusCodeGroupTrendRequest() (request *QuerySingleDomainApiStatusCodeGroupTrendRequest) {
	request = &QuerySingleDomainApiStatusCodeGroupTrendRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("emas-appmonitor", "2019-06-11", "QuerySingleDomainApiStatusCodeGroupTrend", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySingleDomainApiStatusCodeGroupTrendResponse creates a response to parse from QuerySingleDomainApiStatusCodeGroupTrend response
func CreateQuerySingleDomainApiStatusCodeGroupTrendResponse() (response *QuerySingleDomainApiStatusCodeGroupTrendResponse) {
	response = &QuerySingleDomainApiStatusCodeGroupTrendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
