package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccountKmsStatus invokes the kms.DescribeAccountKmsStatus API synchronously
func (client *Client) DescribeAccountKmsStatus(request *DescribeAccountKmsStatusRequest) (response *DescribeAccountKmsStatusResponse, err error) {
	response = CreateDescribeAccountKmsStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccountKmsStatusWithChan invokes the kms.DescribeAccountKmsStatus API asynchronously
func (client *Client) DescribeAccountKmsStatusWithChan(request *DescribeAccountKmsStatusRequest) (<-chan *DescribeAccountKmsStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeAccountKmsStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccountKmsStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccountKmsStatusWithCallback invokes the kms.DescribeAccountKmsStatus API asynchronously
func (client *Client) DescribeAccountKmsStatusWithCallback(request *DescribeAccountKmsStatusRequest, callback func(response *DescribeAccountKmsStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccountKmsStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccountKmsStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccountKmsStatusRequest is the request struct for api DescribeAccountKmsStatus
type DescribeAccountKmsStatusRequest struct {
	*requests.RpcRequest
}

// DescribeAccountKmsStatusResponse is the response struct for api DescribeAccountKmsStatus
type DescribeAccountKmsStatusResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	AccountStatus string `json:"AccountStatus" xml:"AccountStatus"`
}

// CreateDescribeAccountKmsStatusRequest creates a request to invoke DescribeAccountKmsStatus API
func CreateDescribeAccountKmsStatusRequest() (request *DescribeAccountKmsStatusRequest) {
	request = &DescribeAccountKmsStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "DescribeAccountKmsStatus", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAccountKmsStatusResponse creates a response to parse from DescribeAccountKmsStatus response
func CreateDescribeAccountKmsStatusResponse() (response *DescribeAccountKmsStatusResponse) {
	response = &DescribeAccountKmsStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
