package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeDriverLicense invokes the ocr.RecognizeDriverLicense API synchronously
func (client *Client) RecognizeDriverLicense(request *RecognizeDriverLicenseRequest) (response *RecognizeDriverLicenseResponse, err error) {
	response = CreateRecognizeDriverLicenseResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeDriverLicenseWithChan invokes the ocr.RecognizeDriverLicense API asynchronously
func (client *Client) RecognizeDriverLicenseWithChan(request *RecognizeDriverLicenseRequest) (<-chan *RecognizeDriverLicenseResponse, <-chan error) {
	responseChan := make(chan *RecognizeDriverLicenseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeDriverLicense(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeDriverLicenseWithCallback invokes the ocr.RecognizeDriverLicense API asynchronously
func (client *Client) RecognizeDriverLicenseWithCallback(request *RecognizeDriverLicenseRequest, callback func(response *RecognizeDriverLicenseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeDriverLicenseResponse
		var err error
		defer close(result)
		response, err = client.RecognizeDriverLicense(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeDriverLicenseRequest is the request struct for api RecognizeDriverLicense
type RecognizeDriverLicenseRequest struct {
	*requests.RpcRequest
	ImageType requests.Integer `position:"Body" name:"ImageType"`
	Side      string           `position:"Body" name:"Side"`
	ImageURL  string           `position:"Body" name:"ImageURL"`
}

// RecognizeDriverLicenseResponse is the response struct for api RecognizeDriverLicense
type RecognizeDriverLicenseResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeDriverLicenseRequest creates a request to invoke RecognizeDriverLicense API
func CreateRecognizeDriverLicenseRequest() (request *RecognizeDriverLicenseRequest) {
	request = &RecognizeDriverLicenseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizeDriverLicense", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeDriverLicenseResponse creates a response to parse from RecognizeDriverLicense response
func CreateRecognizeDriverLicenseResponse() (response *RecognizeDriverLicenseResponse) {
	response = &RecognizeDriverLicenseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
