package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCallsPerDay invokes the scsp.GetCallsPerDay API synchronously
func (client *Client) GetCallsPerDay(request *GetCallsPerDayRequest) (response *GetCallsPerDayResponse, err error) {
	response = CreateGetCallsPerDayResponse()
	err = client.DoAction(request, response)
	return
}

// GetCallsPerDayWithChan invokes the scsp.GetCallsPerDay API asynchronously
func (client *Client) GetCallsPerDayWithChan(request *GetCallsPerDayRequest) (<-chan *GetCallsPerDayResponse, <-chan error) {
	responseChan := make(chan *GetCallsPerDayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCallsPerDay(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCallsPerDayWithCallback invokes the scsp.GetCallsPerDay API asynchronously
func (client *Client) GetCallsPerDayWithCallback(request *GetCallsPerDayRequest, callback func(response *GetCallsPerDayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCallsPerDayResponse
		var err error
		defer close(result)
		response, err = client.GetCallsPerDay(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCallsPerDayRequest is the request struct for api GetCallsPerDay
type GetCallsPerDayRequest struct {
	*requests.RpcRequest
	InstanceId       string           `position:"Query"`
	DataIdStart      string           `position:"Query"`
	DataIdEnd        string           `position:"Query"`
	DataId           string           `position:"Query"`
	HourId           string           `position:"Query"`
	MinuteId         string           `position:"Query"`
	PhoneNumbers     string           `position:"Query"`
	HavePhoneNumbers string           `position:"Query"`
	PageNo           requests.Integer `position:"Query"`
	PageSize         requests.Integer `position:"Query"`
}

// GetCallsPerDayResponse is the response struct for api GetCallsPerDay
type GetCallsPerDayResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetCallsPerDayRequest creates a request to invoke GetCallsPerDay API
func CreateGetCallsPerDayRequest() (request *GetCallsPerDayRequest) {
	request = &GetCallsPerDayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GetCallsPerDay", "", "")
	request.Method = requests.GET
	return
}

// CreateGetCallsPerDayResponse creates a response to parse from GetCallsPerDay response
func CreateGetCallsPerDayResponse() (response *GetCallsPerDayResponse) {
	response = &GetCallsPerDayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
