package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVideoSummaryTask invokes the vcs.CreateVideoSummaryTask API synchronously
func (client *Client) CreateVideoSummaryTask(request *CreateVideoSummaryTaskRequest) (response *CreateVideoSummaryTaskResponse, err error) {
	response = CreateCreateVideoSummaryTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVideoSummaryTaskWithChan invokes the vcs.CreateVideoSummaryTask API asynchronously
func (client *Client) CreateVideoSummaryTaskWithChan(request *CreateVideoSummaryTaskRequest) (<-chan *CreateVideoSummaryTaskResponse, <-chan error) {
	responseChan := make(chan *CreateVideoSummaryTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVideoSummaryTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVideoSummaryTaskWithCallback invokes the vcs.CreateVideoSummaryTask API asynchronously
func (client *Client) CreateVideoSummaryTaskWithCallback(request *CreateVideoSummaryTaskRequest, callback func(response *CreateVideoSummaryTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVideoSummaryTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateVideoSummaryTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVideoSummaryTaskRequest is the request struct for api CreateVideoSummaryTask
type CreateVideoSummaryTaskRequest struct {
	*requests.RpcRequest
	CorpId           string           `position:"Body" name:"CorpId"`
	LiveVideoSummary string           `position:"Body" name:"LiveVideoSummary"`
	StartTimeStamp   requests.Integer `position:"Body" name:"StartTimeStamp"`
	DeviceId         string           `position:"Body" name:"DeviceId"`
	EndTimeStamp     requests.Integer `position:"Body" name:"EndTimeStamp"`
	OptionList       string           `position:"Body" name:"OptionList"`
}

// CreateVideoSummaryTaskResponse is the response struct for api CreateVideoSummaryTask
type CreateVideoSummaryTaskResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateCreateVideoSummaryTaskRequest creates a request to invoke CreateVideoSummaryTask API
func CreateCreateVideoSummaryTaskRequest() (request *CreateVideoSummaryTaskRequest) {
	request = &CreateVideoSummaryTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "CreateVideoSummaryTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateVideoSummaryTaskResponse creates a response to parse from CreateVideoSummaryTask response
func CreateCreateVideoSummaryTaskResponse() (response *CreateVideoSummaryTaskResponse) {
	response = &CreateVideoSummaryTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
