package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeFaceQuality invokes the vcs.RecognizeFaceQuality API synchronously
func (client *Client) RecognizeFaceQuality(request *RecognizeFaceQualityRequest) (response *RecognizeFaceQualityResponse, err error) {
	response = CreateRecognizeFaceQualityResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeFaceQualityWithChan invokes the vcs.RecognizeFaceQuality API asynchronously
func (client *Client) RecognizeFaceQualityWithChan(request *RecognizeFaceQualityRequest) (<-chan *RecognizeFaceQualityResponse, <-chan error) {
	responseChan := make(chan *RecognizeFaceQualityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeFaceQuality(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeFaceQualityWithCallback invokes the vcs.RecognizeFaceQuality API asynchronously
func (client *Client) RecognizeFaceQualityWithCallback(request *RecognizeFaceQualityRequest, callback func(response *RecognizeFaceQualityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeFaceQualityResponse
		var err error
		defer close(result)
		response, err = client.RecognizeFaceQuality(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeFaceQualityRequest is the request struct for api RecognizeFaceQuality
type RecognizeFaceQualityRequest struct {
	*requests.RpcRequest
	CorpId     string `position:"Body" name:"CorpId"`
	PicUrl     string `position:"Body" name:"PicUrl"`
	PicContent string `position:"Body" name:"PicContent"`
	PicFormat  string `position:"Body" name:"PicFormat"`
}

// RecognizeFaceQualityResponse is the response struct for api RecognizeFaceQuality
type RecognizeFaceQualityResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeFaceQualityRequest creates a request to invoke RecognizeFaceQuality API
func CreateRecognizeFaceQualityRequest() (request *RecognizeFaceQualityRequest) {
	request = &RecognizeFaceQualityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "RecognizeFaceQuality", "", "")
	request.Method = requests.POST
	return
}

// CreateRecognizeFaceQualityResponse creates a response to parse from RecognizeFaceQuality response
func CreateRecognizeFaceQualityResponse() (response *RecognizeFaceQualityResponse) {
	response = &RecognizeFaceQualityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
