package yundun_ds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTotalCount invokes the yundun_ds.DescribeTotalCount API synchronously
// api document: https://help.aliyun.com/api/yundun-ds/describetotalcount.html
func (client *Client) DescribeTotalCount(request *DescribeTotalCountRequest) (response *DescribeTotalCountResponse, err error) {
	response = CreateDescribeTotalCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTotalCountWithChan invokes the yundun_ds.DescribeTotalCount API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describetotalcount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTotalCountWithChan(request *DescribeTotalCountRequest) (<-chan *DescribeTotalCountResponse, <-chan error) {
	responseChan := make(chan *DescribeTotalCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTotalCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTotalCountWithCallback invokes the yundun_ds.DescribeTotalCount API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describetotalcount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTotalCountWithCallback(request *DescribeTotalCountRequest, callback func(response *DescribeTotalCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTotalCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeTotalCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTotalCountRequest is the request struct for api DescribeTotalCount
type DescribeTotalCountRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	Lang        string           `position:"Query" name:"Lang"`
}

// DescribeTotalCountResponse is the response struct for api DescribeTotalCount
type DescribeTotalCountResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	DataCount   DataCount   `json:"DataCount" xml:"DataCount"`
	EventCount  EventCount  `json:"EventCount" xml:"EventCount"`
	DepartCount DepartCount `json:"DepartCount" xml:"DepartCount"`
}

// CreateDescribeTotalCountRequest creates a request to invoke DescribeTotalCount API
func CreateDescribeTotalCountRequest() (request *DescribeTotalCountRequest) {
	request = &DescribeTotalCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-ds", "2019-01-03", "DescribeTotalCount", "sddp", "openAPI")
	return
}

// CreateDescribeTotalCountResponse creates a response to parse from DescribeTotalCount response
func CreateDescribeTotalCountResponse() (response *DescribeTotalCountResponse) {
	response = &DescribeTotalCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
