// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rolesanywhere

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateProfile = "CreateProfile"

// CreateProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProfile for more information on using the CreateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProfileRequest method.
//	req, resp := client.CreateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/CreateProfile
func (c *RolesAnywhere) CreateProfileRequest(input *CreateProfileInput) (req *request.Request, output *CreateProfileOutput) {
	op := &request.Operation{
		Name:       opCreateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/profiles",
	}

	if input == nil {
		input = &CreateProfileInput{}
	}

	output = &CreateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProfile API operation for IAM Roles Anywhere.
//
// Creates a profile, a list of the roles that Roles Anywhere service is trusted
// to assume. You use profiles to intersect permissions with IAM managed policies.
//
// Required permissions: rolesanywhere:CreateProfile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation CreateProfile for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/CreateProfile
func (c *RolesAnywhere) CreateProfile(input *CreateProfileInput) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	return out, req.Send()
}

// CreateProfileWithContext is the same as CreateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) CreateProfileWithContext(ctx aws.Context, input *CreateProfileInput, opts ...request.Option) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrustAnchor = "CreateTrustAnchor"

// CreateTrustAnchorRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrustAnchor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrustAnchor for more information on using the CreateTrustAnchor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTrustAnchorRequest method.
//	req, resp := client.CreateTrustAnchorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/CreateTrustAnchor
func (c *RolesAnywhere) CreateTrustAnchorRequest(input *CreateTrustAnchorInput) (req *request.Request, output *CreateTrustAnchorOutput) {
	op := &request.Operation{
		Name:       opCreateTrustAnchor,
		HTTPMethod: "POST",
		HTTPPath:   "/trustanchors",
	}

	if input == nil {
		input = &CreateTrustAnchorInput{}
	}

	output = &CreateTrustAnchorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrustAnchor API operation for IAM Roles Anywhere.
//
// Creates a trust anchor to establish trust between IAM Roles Anywhere and
// your certificate authority (CA). You can define a trust anchor as a reference
// to an Private Certificate Authority (Private CA) or by uploading a CA certificate.
// Your Amazon Web Services workloads can authenticate with the trust anchor
// using certificates issued by the CA in exchange for temporary Amazon Web
// Services credentials.
//
// Required permissions: rolesanywhere:CreateTrustAnchor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation CreateTrustAnchor for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/CreateTrustAnchor
func (c *RolesAnywhere) CreateTrustAnchor(input *CreateTrustAnchorInput) (*CreateTrustAnchorOutput, error) {
	req, out := c.CreateTrustAnchorRequest(input)
	return out, req.Send()
}

// CreateTrustAnchorWithContext is the same as CreateTrustAnchor with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrustAnchor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) CreateTrustAnchorWithContext(ctx aws.Context, input *CreateTrustAnchorInput, opts ...request.Option) (*CreateTrustAnchorOutput, error) {
	req, out := c.CreateTrustAnchorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAttributeMapping = "DeleteAttributeMapping"

// DeleteAttributeMappingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAttributeMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAttributeMapping for more information on using the DeleteAttributeMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAttributeMappingRequest method.
//	req, resp := client.DeleteAttributeMappingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteAttributeMapping
func (c *RolesAnywhere) DeleteAttributeMappingRequest(input *DeleteAttributeMappingInput) (req *request.Request, output *DeleteAttributeMappingOutput) {
	op := &request.Operation{
		Name:       opDeleteAttributeMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/profiles/{profileId}/mappings",
	}

	if input == nil {
		input = &DeleteAttributeMappingInput{}
	}

	output = &DeleteAttributeMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAttributeMapping API operation for IAM Roles Anywhere.
//
// Delete an entry from the attribute mapping rules enforced by a given profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation DeleteAttributeMapping for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteAttributeMapping
func (c *RolesAnywhere) DeleteAttributeMapping(input *DeleteAttributeMappingInput) (*DeleteAttributeMappingOutput, error) {
	req, out := c.DeleteAttributeMappingRequest(input)
	return out, req.Send()
}

// DeleteAttributeMappingWithContext is the same as DeleteAttributeMapping with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAttributeMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) DeleteAttributeMappingWithContext(ctx aws.Context, input *DeleteAttributeMappingInput, opts ...request.Option) (*DeleteAttributeMappingOutput, error) {
	req, out := c.DeleteAttributeMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCrl = "DeleteCrl"

// DeleteCrlRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCrl for more information on using the DeleteCrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCrlRequest method.
//	req, resp := client.DeleteCrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteCrl
func (c *RolesAnywhere) DeleteCrlRequest(input *DeleteCrlInput) (req *request.Request, output *DeleteCrlOutput) {
	op := &request.Operation{
		Name:       opDeleteCrl,
		HTTPMethod: "DELETE",
		HTTPPath:   "/crl/{crlId}",
	}

	if input == nil {
		input = &DeleteCrlInput{}
	}

	output = &DeleteCrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCrl API operation for IAM Roles Anywhere.
//
// Deletes a certificate revocation list (CRL).
//
// Required permissions: rolesanywhere:DeleteCrl.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation DeleteCrl for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteCrl
func (c *RolesAnywhere) DeleteCrl(input *DeleteCrlInput) (*DeleteCrlOutput, error) {
	req, out := c.DeleteCrlRequest(input)
	return out, req.Send()
}

// DeleteCrlWithContext is the same as DeleteCrl with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) DeleteCrlWithContext(ctx aws.Context, input *DeleteCrlInput, opts ...request.Option) (*DeleteCrlOutput, error) {
	req, out := c.DeleteCrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfile = "DeleteProfile"

// DeleteProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfile for more information on using the DeleteProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProfileRequest method.
//	req, resp := client.DeleteProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteProfile
func (c *RolesAnywhere) DeleteProfileRequest(input *DeleteProfileInput) (req *request.Request, output *DeleteProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/profile/{profileId}",
	}

	if input == nil {
		input = &DeleteProfileInput{}
	}

	output = &DeleteProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProfile API operation for IAM Roles Anywhere.
//
// Deletes a profile.
//
// Required permissions: rolesanywhere:DeleteProfile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation DeleteProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteProfile
func (c *RolesAnywhere) DeleteProfile(input *DeleteProfileInput) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	return out, req.Send()
}

// DeleteProfileWithContext is the same as DeleteProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) DeleteProfileWithContext(ctx aws.Context, input *DeleteProfileInput, opts ...request.Option) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrustAnchor = "DeleteTrustAnchor"

// DeleteTrustAnchorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrustAnchor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrustAnchor for more information on using the DeleteTrustAnchor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTrustAnchorRequest method.
//	req, resp := client.DeleteTrustAnchorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteTrustAnchor
func (c *RolesAnywhere) DeleteTrustAnchorRequest(input *DeleteTrustAnchorInput) (req *request.Request, output *DeleteTrustAnchorOutput) {
	op := &request.Operation{
		Name:       opDeleteTrustAnchor,
		HTTPMethod: "DELETE",
		HTTPPath:   "/trustanchor/{trustAnchorId}",
	}

	if input == nil {
		input = &DeleteTrustAnchorInput{}
	}

	output = &DeleteTrustAnchorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrustAnchor API operation for IAM Roles Anywhere.
//
// Deletes a trust anchor.
//
// Required permissions: rolesanywhere:DeleteTrustAnchor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation DeleteTrustAnchor for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DeleteTrustAnchor
func (c *RolesAnywhere) DeleteTrustAnchor(input *DeleteTrustAnchorInput) (*DeleteTrustAnchorOutput, error) {
	req, out := c.DeleteTrustAnchorRequest(input)
	return out, req.Send()
}

// DeleteTrustAnchorWithContext is the same as DeleteTrustAnchor with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrustAnchor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) DeleteTrustAnchorWithContext(ctx aws.Context, input *DeleteTrustAnchorInput, opts ...request.Option) (*DeleteTrustAnchorOutput, error) {
	req, out := c.DeleteTrustAnchorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableCrl = "DisableCrl"

// DisableCrlRequest generates a "aws/request.Request" representing the
// client's request for the DisableCrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableCrl for more information on using the DisableCrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableCrlRequest method.
//	req, resp := client.DisableCrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DisableCrl
func (c *RolesAnywhere) DisableCrlRequest(input *DisableCrlInput) (req *request.Request, output *DisableCrlOutput) {
	op := &request.Operation{
		Name:       opDisableCrl,
		HTTPMethod: "POST",
		HTTPPath:   "/crl/{crlId}/disable",
	}

	if input == nil {
		input = &DisableCrlInput{}
	}

	output = &DisableCrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableCrl API operation for IAM Roles Anywhere.
//
// Disables a certificate revocation list (CRL).
//
// Required permissions: rolesanywhere:DisableCrl.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation DisableCrl for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DisableCrl
func (c *RolesAnywhere) DisableCrl(input *DisableCrlInput) (*DisableCrlOutput, error) {
	req, out := c.DisableCrlRequest(input)
	return out, req.Send()
}

// DisableCrlWithContext is the same as DisableCrl with the addition of
// the ability to pass a context and additional request options.
//
// See DisableCrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) DisableCrlWithContext(ctx aws.Context, input *DisableCrlInput, opts ...request.Option) (*DisableCrlOutput, error) {
	req, out := c.DisableCrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableProfile = "DisableProfile"

// DisableProfileRequest generates a "aws/request.Request" representing the
// client's request for the DisableProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableProfile for more information on using the DisableProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableProfileRequest method.
//	req, resp := client.DisableProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DisableProfile
func (c *RolesAnywhere) DisableProfileRequest(input *DisableProfileInput) (req *request.Request, output *DisableProfileOutput) {
	op := &request.Operation{
		Name:       opDisableProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/profile/{profileId}/disable",
	}

	if input == nil {
		input = &DisableProfileInput{}
	}

	output = &DisableProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableProfile API operation for IAM Roles Anywhere.
//
// Disables a profile. When disabled, temporary credential requests with this
// profile fail.
//
// Required permissions: rolesanywhere:DisableProfile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation DisableProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DisableProfile
func (c *RolesAnywhere) DisableProfile(input *DisableProfileInput) (*DisableProfileOutput, error) {
	req, out := c.DisableProfileRequest(input)
	return out, req.Send()
}

// DisableProfileWithContext is the same as DisableProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DisableProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) DisableProfileWithContext(ctx aws.Context, input *DisableProfileInput, opts ...request.Option) (*DisableProfileOutput, error) {
	req, out := c.DisableProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableTrustAnchor = "DisableTrustAnchor"

// DisableTrustAnchorRequest generates a "aws/request.Request" representing the
// client's request for the DisableTrustAnchor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableTrustAnchor for more information on using the DisableTrustAnchor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableTrustAnchorRequest method.
//	req, resp := client.DisableTrustAnchorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DisableTrustAnchor
func (c *RolesAnywhere) DisableTrustAnchorRequest(input *DisableTrustAnchorInput) (req *request.Request, output *DisableTrustAnchorOutput) {
	op := &request.Operation{
		Name:       opDisableTrustAnchor,
		HTTPMethod: "POST",
		HTTPPath:   "/trustanchor/{trustAnchorId}/disable",
	}

	if input == nil {
		input = &DisableTrustAnchorInput{}
	}

	output = &DisableTrustAnchorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableTrustAnchor API operation for IAM Roles Anywhere.
//
// Disables a trust anchor. When disabled, temporary credential requests specifying
// this trust anchor are unauthorized.
//
// Required permissions: rolesanywhere:DisableTrustAnchor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation DisableTrustAnchor for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/DisableTrustAnchor
func (c *RolesAnywhere) DisableTrustAnchor(input *DisableTrustAnchorInput) (*DisableTrustAnchorOutput, error) {
	req, out := c.DisableTrustAnchorRequest(input)
	return out, req.Send()
}

// DisableTrustAnchorWithContext is the same as DisableTrustAnchor with the addition of
// the ability to pass a context and additional request options.
//
// See DisableTrustAnchor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) DisableTrustAnchorWithContext(ctx aws.Context, input *DisableTrustAnchorInput, opts ...request.Option) (*DisableTrustAnchorOutput, error) {
	req, out := c.DisableTrustAnchorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableCrl = "EnableCrl"

// EnableCrlRequest generates a "aws/request.Request" representing the
// client's request for the EnableCrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableCrl for more information on using the EnableCrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableCrlRequest method.
//	req, resp := client.EnableCrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/EnableCrl
func (c *RolesAnywhere) EnableCrlRequest(input *EnableCrlInput) (req *request.Request, output *EnableCrlOutput) {
	op := &request.Operation{
		Name:       opEnableCrl,
		HTTPMethod: "POST",
		HTTPPath:   "/crl/{crlId}/enable",
	}

	if input == nil {
		input = &EnableCrlInput{}
	}

	output = &EnableCrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableCrl API operation for IAM Roles Anywhere.
//
// Enables a certificate revocation list (CRL). When enabled, certificates stored
// in the CRL are unauthorized to receive session credentials.
//
// Required permissions: rolesanywhere:EnableCrl.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation EnableCrl for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/EnableCrl
func (c *RolesAnywhere) EnableCrl(input *EnableCrlInput) (*EnableCrlOutput, error) {
	req, out := c.EnableCrlRequest(input)
	return out, req.Send()
}

// EnableCrlWithContext is the same as EnableCrl with the addition of
// the ability to pass a context and additional request options.
//
// See EnableCrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) EnableCrlWithContext(ctx aws.Context, input *EnableCrlInput, opts ...request.Option) (*EnableCrlOutput, error) {
	req, out := c.EnableCrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableProfile = "EnableProfile"

// EnableProfileRequest generates a "aws/request.Request" representing the
// client's request for the EnableProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableProfile for more information on using the EnableProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableProfileRequest method.
//	req, resp := client.EnableProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/EnableProfile
func (c *RolesAnywhere) EnableProfileRequest(input *EnableProfileInput) (req *request.Request, output *EnableProfileOutput) {
	op := &request.Operation{
		Name:       opEnableProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/profile/{profileId}/enable",
	}

	if input == nil {
		input = &EnableProfileInput{}
	}

	output = &EnableProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableProfile API operation for IAM Roles Anywhere.
//
// Enables temporary credential requests for a profile.
//
// Required permissions: rolesanywhere:EnableProfile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation EnableProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/EnableProfile
func (c *RolesAnywhere) EnableProfile(input *EnableProfileInput) (*EnableProfileOutput, error) {
	req, out := c.EnableProfileRequest(input)
	return out, req.Send()
}

// EnableProfileWithContext is the same as EnableProfile with the addition of
// the ability to pass a context and additional request options.
//
// See EnableProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) EnableProfileWithContext(ctx aws.Context, input *EnableProfileInput, opts ...request.Option) (*EnableProfileOutput, error) {
	req, out := c.EnableProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableTrustAnchor = "EnableTrustAnchor"

// EnableTrustAnchorRequest generates a "aws/request.Request" representing the
// client's request for the EnableTrustAnchor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableTrustAnchor for more information on using the EnableTrustAnchor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableTrustAnchorRequest method.
//	req, resp := client.EnableTrustAnchorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/EnableTrustAnchor
func (c *RolesAnywhere) EnableTrustAnchorRequest(input *EnableTrustAnchorInput) (req *request.Request, output *EnableTrustAnchorOutput) {
	op := &request.Operation{
		Name:       opEnableTrustAnchor,
		HTTPMethod: "POST",
		HTTPPath:   "/trustanchor/{trustAnchorId}/enable",
	}

	if input == nil {
		input = &EnableTrustAnchorInput{}
	}

	output = &EnableTrustAnchorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableTrustAnchor API operation for IAM Roles Anywhere.
//
// Enables a trust anchor. When enabled, certificates in the trust anchor chain
// are authorized for trust validation.
//
// Required permissions: rolesanywhere:EnableTrustAnchor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation EnableTrustAnchor for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/EnableTrustAnchor
func (c *RolesAnywhere) EnableTrustAnchor(input *EnableTrustAnchorInput) (*EnableTrustAnchorOutput, error) {
	req, out := c.EnableTrustAnchorRequest(input)
	return out, req.Send()
}

// EnableTrustAnchorWithContext is the same as EnableTrustAnchor with the addition of
// the ability to pass a context and additional request options.
//
// See EnableTrustAnchor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) EnableTrustAnchorWithContext(ctx aws.Context, input *EnableTrustAnchorInput, opts ...request.Option) (*EnableTrustAnchorOutput, error) {
	req, out := c.EnableTrustAnchorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCrl = "GetCrl"

// GetCrlRequest generates a "aws/request.Request" representing the
// client's request for the GetCrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCrl for more information on using the GetCrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCrlRequest method.
//	req, resp := client.GetCrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetCrl
func (c *RolesAnywhere) GetCrlRequest(input *GetCrlInput) (req *request.Request, output *GetCrlOutput) {
	op := &request.Operation{
		Name:       opGetCrl,
		HTTPMethod: "GET",
		HTTPPath:   "/crl/{crlId}",
	}

	if input == nil {
		input = &GetCrlInput{}
	}

	output = &GetCrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCrl API operation for IAM Roles Anywhere.
//
// Gets a certificate revocation list (CRL).
//
// Required permissions: rolesanywhere:GetCrl.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation GetCrl for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetCrl
func (c *RolesAnywhere) GetCrl(input *GetCrlInput) (*GetCrlOutput, error) {
	req, out := c.GetCrlRequest(input)
	return out, req.Send()
}

// GetCrlWithContext is the same as GetCrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetCrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) GetCrlWithContext(ctx aws.Context, input *GetCrlInput, opts ...request.Option) (*GetCrlOutput, error) {
	req, out := c.GetCrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfile = "GetProfile"

// GetProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfile for more information on using the GetProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProfileRequest method.
//	req, resp := client.GetProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetProfile
func (c *RolesAnywhere) GetProfileRequest(input *GetProfileInput) (req *request.Request, output *GetProfileOutput) {
	op := &request.Operation{
		Name:       opGetProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/profile/{profileId}",
	}

	if input == nil {
		input = &GetProfileInput{}
	}

	output = &GetProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfile API operation for IAM Roles Anywhere.
//
// Gets a profile.
//
// Required permissions: rolesanywhere:GetProfile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation GetProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetProfile
func (c *RolesAnywhere) GetProfile(input *GetProfileInput) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	return out, req.Send()
}

// GetProfileWithContext is the same as GetProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) GetProfileWithContext(ctx aws.Context, input *GetProfileInput, opts ...request.Option) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSubject = "GetSubject"

// GetSubjectRequest generates a "aws/request.Request" representing the
// client's request for the GetSubject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSubject for more information on using the GetSubject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSubjectRequest method.
//	req, resp := client.GetSubjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetSubject
func (c *RolesAnywhere) GetSubjectRequest(input *GetSubjectInput) (req *request.Request, output *GetSubjectOutput) {
	op := &request.Operation{
		Name:       opGetSubject,
		HTTPMethod: "GET",
		HTTPPath:   "/subject/{subjectId}",
	}

	if input == nil {
		input = &GetSubjectInput{}
	}

	output = &GetSubjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSubject API operation for IAM Roles Anywhere.
//
// Gets a subject, which associates a certificate identity with authentication
// attempts. The subject stores auditing information such as the status of the
// last authentication attempt, the certificate data used in the attempt, and
// the last time the associated identity attempted authentication.
//
// Required permissions: rolesanywhere:GetSubject.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation GetSubject for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetSubject
func (c *RolesAnywhere) GetSubject(input *GetSubjectInput) (*GetSubjectOutput, error) {
	req, out := c.GetSubjectRequest(input)
	return out, req.Send()
}

// GetSubjectWithContext is the same as GetSubject with the addition of
// the ability to pass a context and additional request options.
//
// See GetSubject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) GetSubjectWithContext(ctx aws.Context, input *GetSubjectInput, opts ...request.Option) (*GetSubjectOutput, error) {
	req, out := c.GetSubjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrustAnchor = "GetTrustAnchor"

// GetTrustAnchorRequest generates a "aws/request.Request" representing the
// client's request for the GetTrustAnchor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrustAnchor for more information on using the GetTrustAnchor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTrustAnchorRequest method.
//	req, resp := client.GetTrustAnchorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetTrustAnchor
func (c *RolesAnywhere) GetTrustAnchorRequest(input *GetTrustAnchorInput) (req *request.Request, output *GetTrustAnchorOutput) {
	op := &request.Operation{
		Name:       opGetTrustAnchor,
		HTTPMethod: "GET",
		HTTPPath:   "/trustanchor/{trustAnchorId}",
	}

	if input == nil {
		input = &GetTrustAnchorInput{}
	}

	output = &GetTrustAnchorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrustAnchor API operation for IAM Roles Anywhere.
//
// Gets a trust anchor.
//
// Required permissions: rolesanywhere:GetTrustAnchor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation GetTrustAnchor for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/GetTrustAnchor
func (c *RolesAnywhere) GetTrustAnchor(input *GetTrustAnchorInput) (*GetTrustAnchorOutput, error) {
	req, out := c.GetTrustAnchorRequest(input)
	return out, req.Send()
}

// GetTrustAnchorWithContext is the same as GetTrustAnchor with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrustAnchor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) GetTrustAnchorWithContext(ctx aws.Context, input *GetTrustAnchorInput, opts ...request.Option) (*GetTrustAnchorOutput, error) {
	req, out := c.GetTrustAnchorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportCrl = "ImportCrl"

// ImportCrlRequest generates a "aws/request.Request" representing the
// client's request for the ImportCrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportCrl for more information on using the ImportCrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportCrlRequest method.
//	req, resp := client.ImportCrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ImportCrl
func (c *RolesAnywhere) ImportCrlRequest(input *ImportCrlInput) (req *request.Request, output *ImportCrlOutput) {
	op := &request.Operation{
		Name:       opImportCrl,
		HTTPMethod: "POST",
		HTTPPath:   "/crls",
	}

	if input == nil {
		input = &ImportCrlInput{}
	}

	output = &ImportCrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportCrl API operation for IAM Roles Anywhere.
//
// Imports the certificate revocation list (CRL). A CRL is a list of certificates
// that have been revoked by the issuing certificate Authority (CA).In order
// to be properly imported, a CRL must be in PEM format. IAM Roles Anywhere
// validates against the CRL before issuing credentials.
//
// Required permissions: rolesanywhere:ImportCrl.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation ImportCrl for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ImportCrl
func (c *RolesAnywhere) ImportCrl(input *ImportCrlInput) (*ImportCrlOutput, error) {
	req, out := c.ImportCrlRequest(input)
	return out, req.Send()
}

// ImportCrlWithContext is the same as ImportCrl with the addition of
// the ability to pass a context and additional request options.
//
// See ImportCrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) ImportCrlWithContext(ctx aws.Context, input *ImportCrlInput, opts ...request.Option) (*ImportCrlOutput, error) {
	req, out := c.ImportCrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCrls = "ListCrls"

// ListCrlsRequest generates a "aws/request.Request" representing the
// client's request for the ListCrls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCrls for more information on using the ListCrls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCrlsRequest method.
//	req, resp := client.ListCrlsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListCrls
func (c *RolesAnywhere) ListCrlsRequest(input *ListCrlsInput) (req *request.Request, output *ListCrlsOutput) {
	op := &request.Operation{
		Name:       opListCrls,
		HTTPMethod: "GET",
		HTTPPath:   "/crls",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCrlsInput{}
	}

	output = &ListCrlsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCrls API operation for IAM Roles Anywhere.
//
// Lists all certificate revocation lists (CRL) in the authenticated account
// and Amazon Web Services Region.
//
// Required permissions: rolesanywhere:ListCrls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation ListCrls for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListCrls
func (c *RolesAnywhere) ListCrls(input *ListCrlsInput) (*ListCrlsOutput, error) {
	req, out := c.ListCrlsRequest(input)
	return out, req.Send()
}

// ListCrlsWithContext is the same as ListCrls with the addition of
// the ability to pass a context and additional request options.
//
// See ListCrls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) ListCrlsWithContext(ctx aws.Context, input *ListCrlsInput, opts ...request.Option) (*ListCrlsOutput, error) {
	req, out := c.ListCrlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCrlsPages iterates over the pages of a ListCrls operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCrls method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCrls operation.
//	pageNum := 0
//	err := client.ListCrlsPages(params,
//	    func(page *rolesanywhere.ListCrlsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RolesAnywhere) ListCrlsPages(input *ListCrlsInput, fn func(*ListCrlsOutput, bool) bool) error {
	return c.ListCrlsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCrlsPagesWithContext same as ListCrlsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) ListCrlsPagesWithContext(ctx aws.Context, input *ListCrlsInput, fn func(*ListCrlsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCrlsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCrlsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCrlsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProfiles = "ListProfiles"

// ListProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfiles for more information on using the ListProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProfilesRequest method.
//	req, resp := client.ListProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListProfiles
func (c *RolesAnywhere) ListProfilesRequest(input *ListProfilesInput) (req *request.Request, output *ListProfilesOutput) {
	op := &request.Operation{
		Name:       opListProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProfilesInput{}
	}

	output = &ListProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfiles API operation for IAM Roles Anywhere.
//
// Lists all profiles in the authenticated account and Amazon Web Services Region.
//
// Required permissions: rolesanywhere:ListProfiles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation ListProfiles for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListProfiles
func (c *RolesAnywhere) ListProfiles(input *ListProfilesInput) (*ListProfilesOutput, error) {
	req, out := c.ListProfilesRequest(input)
	return out, req.Send()
}

// ListProfilesWithContext is the same as ListProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) ListProfilesWithContext(ctx aws.Context, input *ListProfilesInput, opts ...request.Option) (*ListProfilesOutput, error) {
	req, out := c.ListProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProfilesPages iterates over the pages of a ListProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProfiles operation.
//	pageNum := 0
//	err := client.ListProfilesPages(params,
//	    func(page *rolesanywhere.ListProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RolesAnywhere) ListProfilesPages(input *ListProfilesInput, fn func(*ListProfilesOutput, bool) bool) error {
	return c.ListProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProfilesPagesWithContext same as ListProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) ListProfilesPagesWithContext(ctx aws.Context, input *ListProfilesInput, fn func(*ListProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSubjects = "ListSubjects"

// ListSubjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubjects for more information on using the ListSubjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSubjectsRequest method.
//	req, resp := client.ListSubjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListSubjects
func (c *RolesAnywhere) ListSubjectsRequest(input *ListSubjectsInput) (req *request.Request, output *ListSubjectsOutput) {
	op := &request.Operation{
		Name:       opListSubjects,
		HTTPMethod: "GET",
		HTTPPath:   "/subjects",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubjectsInput{}
	}

	output = &ListSubjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubjects API operation for IAM Roles Anywhere.
//
// Lists the subjects in the authenticated account and Amazon Web Services Region.
//
// Required permissions: rolesanywhere:ListSubjects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation ListSubjects for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListSubjects
func (c *RolesAnywhere) ListSubjects(input *ListSubjectsInput) (*ListSubjectsOutput, error) {
	req, out := c.ListSubjectsRequest(input)
	return out, req.Send()
}

// ListSubjectsWithContext is the same as ListSubjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) ListSubjectsWithContext(ctx aws.Context, input *ListSubjectsInput, opts ...request.Option) (*ListSubjectsOutput, error) {
	req, out := c.ListSubjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSubjectsPages iterates over the pages of a ListSubjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSubjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSubjects operation.
//	pageNum := 0
//	err := client.ListSubjectsPages(params,
//	    func(page *rolesanywhere.ListSubjectsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RolesAnywhere) ListSubjectsPages(input *ListSubjectsInput, fn func(*ListSubjectsOutput, bool) bool) error {
	return c.ListSubjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSubjectsPagesWithContext same as ListSubjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) ListSubjectsPagesWithContext(ctx aws.Context, input *ListSubjectsInput, fn func(*ListSubjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSubjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSubjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSubjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListTagsForResource
func (c *RolesAnywhere) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/ListTagsForResource",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for IAM Roles Anywhere.
//
// Lists the tags attached to the resource.
//
// Required permissions: rolesanywhere:ListTagsForResource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListTagsForResource
func (c *RolesAnywhere) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTrustAnchors = "ListTrustAnchors"

// ListTrustAnchorsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrustAnchors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrustAnchors for more information on using the ListTrustAnchors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTrustAnchorsRequest method.
//	req, resp := client.ListTrustAnchorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListTrustAnchors
func (c *RolesAnywhere) ListTrustAnchorsRequest(input *ListTrustAnchorsInput) (req *request.Request, output *ListTrustAnchorsOutput) {
	op := &request.Operation{
		Name:       opListTrustAnchors,
		HTTPMethod: "GET",
		HTTPPath:   "/trustanchors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrustAnchorsInput{}
	}

	output = &ListTrustAnchorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrustAnchors API operation for IAM Roles Anywhere.
//
// Lists the trust anchors in the authenticated account and Amazon Web Services
// Region.
//
// Required permissions: rolesanywhere:ListTrustAnchors.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation ListTrustAnchors for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ListTrustAnchors
func (c *RolesAnywhere) ListTrustAnchors(input *ListTrustAnchorsInput) (*ListTrustAnchorsOutput, error) {
	req, out := c.ListTrustAnchorsRequest(input)
	return out, req.Send()
}

// ListTrustAnchorsWithContext is the same as ListTrustAnchors with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrustAnchors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) ListTrustAnchorsWithContext(ctx aws.Context, input *ListTrustAnchorsInput, opts ...request.Option) (*ListTrustAnchorsOutput, error) {
	req, out := c.ListTrustAnchorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrustAnchorsPages iterates over the pages of a ListTrustAnchors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrustAnchors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTrustAnchors operation.
//	pageNum := 0
//	err := client.ListTrustAnchorsPages(params,
//	    func(page *rolesanywhere.ListTrustAnchorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RolesAnywhere) ListTrustAnchorsPages(input *ListTrustAnchorsInput, fn func(*ListTrustAnchorsOutput, bool) bool) error {
	return c.ListTrustAnchorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrustAnchorsPagesWithContext same as ListTrustAnchorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) ListTrustAnchorsPagesWithContext(ctx aws.Context, input *ListTrustAnchorsInput, fn func(*ListTrustAnchorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrustAnchorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrustAnchorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrustAnchorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutAttributeMapping = "PutAttributeMapping"

// PutAttributeMappingRequest generates a "aws/request.Request" representing the
// client's request for the PutAttributeMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAttributeMapping for more information on using the PutAttributeMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAttributeMappingRequest method.
//	req, resp := client.PutAttributeMappingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/PutAttributeMapping
func (c *RolesAnywhere) PutAttributeMappingRequest(input *PutAttributeMappingInput) (req *request.Request, output *PutAttributeMappingOutput) {
	op := &request.Operation{
		Name:       opPutAttributeMapping,
		HTTPMethod: "PUT",
		HTTPPath:   "/profiles/{profileId}/mappings",
	}

	if input == nil {
		input = &PutAttributeMappingInput{}
	}

	output = &PutAttributeMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAttributeMapping API operation for IAM Roles Anywhere.
//
// Put an entry in the attribute mapping rules that will be enforced by a given
// profile. A mapping specifies a certificate field and one or more specifiers
// that have contextual meanings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation PutAttributeMapping for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/PutAttributeMapping
func (c *RolesAnywhere) PutAttributeMapping(input *PutAttributeMappingInput) (*PutAttributeMappingOutput, error) {
	req, out := c.PutAttributeMappingRequest(input)
	return out, req.Send()
}

// PutAttributeMappingWithContext is the same as PutAttributeMapping with the addition of
// the ability to pass a context and additional request options.
//
// See PutAttributeMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) PutAttributeMappingWithContext(ctx aws.Context, input *PutAttributeMappingInput, opts ...request.Option) (*PutAttributeMappingOutput, error) {
	req, out := c.PutAttributeMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutNotificationSettings = "PutNotificationSettings"

// PutNotificationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the PutNotificationSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutNotificationSettings for more information on using the PutNotificationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutNotificationSettingsRequest method.
//	req, resp := client.PutNotificationSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/PutNotificationSettings
func (c *RolesAnywhere) PutNotificationSettingsRequest(input *PutNotificationSettingsInput) (req *request.Request, output *PutNotificationSettingsOutput) {
	op := &request.Operation{
		Name:       opPutNotificationSettings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/put-notifications-settings",
	}

	if input == nil {
		input = &PutNotificationSettingsInput{}
	}

	output = &PutNotificationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutNotificationSettings API operation for IAM Roles Anywhere.
//
// Attaches a list of notification settings to a trust anchor.
//
// A notification setting includes information such as event name, threshold,
// status of the notification setting, and the channel to notify.
//
// Required permissions: rolesanywhere:PutNotificationSettings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation PutNotificationSettings for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/PutNotificationSettings
func (c *RolesAnywhere) PutNotificationSettings(input *PutNotificationSettingsInput) (*PutNotificationSettingsOutput, error) {
	req, out := c.PutNotificationSettingsRequest(input)
	return out, req.Send()
}

// PutNotificationSettingsWithContext is the same as PutNotificationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See PutNotificationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) PutNotificationSettingsWithContext(ctx aws.Context, input *PutNotificationSettingsInput, opts ...request.Option) (*PutNotificationSettingsOutput, error) {
	req, out := c.PutNotificationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetNotificationSettings = "ResetNotificationSettings"

// ResetNotificationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the ResetNotificationSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetNotificationSettings for more information on using the ResetNotificationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ResetNotificationSettingsRequest method.
//	req, resp := client.ResetNotificationSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ResetNotificationSettings
func (c *RolesAnywhere) ResetNotificationSettingsRequest(input *ResetNotificationSettingsInput) (req *request.Request, output *ResetNotificationSettingsOutput) {
	op := &request.Operation{
		Name:       opResetNotificationSettings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/reset-notifications-settings",
	}

	if input == nil {
		input = &ResetNotificationSettingsInput{}
	}

	output = &ResetNotificationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetNotificationSettings API operation for IAM Roles Anywhere.
//
// Resets the custom notification setting to IAM Roles Anywhere default setting.
//
// Required permissions: rolesanywhere:ResetNotificationSettings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation ResetNotificationSettings for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/ResetNotificationSettings
func (c *RolesAnywhere) ResetNotificationSettings(input *ResetNotificationSettingsInput) (*ResetNotificationSettingsOutput, error) {
	req, out := c.ResetNotificationSettingsRequest(input)
	return out, req.Send()
}

// ResetNotificationSettingsWithContext is the same as ResetNotificationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See ResetNotificationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) ResetNotificationSettingsWithContext(ctx aws.Context, input *ResetNotificationSettingsInput, opts ...request.Option) (*ResetNotificationSettingsOutput, error) {
	req, out := c.ResetNotificationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/TagResource
func (c *RolesAnywhere) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/TagResource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for IAM Roles Anywhere.
//
// Attaches tags to a resource.
//
// Required permissions: rolesanywhere:TagResource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - TooManyTagsException
//     Too many tags.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/TagResource
func (c *RolesAnywhere) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UntagResource
func (c *RolesAnywhere) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/UntagResource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for IAM Roles Anywhere.
//
// Removes tags from the resource.
//
// Required permissions: rolesanywhere:UntagResource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UntagResource
func (c *RolesAnywhere) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCrl = "UpdateCrl"

// UpdateCrlRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCrl for more information on using the UpdateCrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCrlRequest method.
//	req, resp := client.UpdateCrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UpdateCrl
func (c *RolesAnywhere) UpdateCrlRequest(input *UpdateCrlInput) (req *request.Request, output *UpdateCrlOutput) {
	op := &request.Operation{
		Name:       opUpdateCrl,
		HTTPMethod: "PATCH",
		HTTPPath:   "/crl/{crlId}",
	}

	if input == nil {
		input = &UpdateCrlInput{}
	}

	output = &UpdateCrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCrl API operation for IAM Roles Anywhere.
//
// Updates the certificate revocation list (CRL). A CRL is a list of certificates
// that have been revoked by the issuing certificate authority (CA). IAM Roles
// Anywhere validates against the CRL before issuing credentials.
//
// Required permissions: rolesanywhere:UpdateCrl.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation UpdateCrl for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UpdateCrl
func (c *RolesAnywhere) UpdateCrl(input *UpdateCrlInput) (*UpdateCrlOutput, error) {
	req, out := c.UpdateCrlRequest(input)
	return out, req.Send()
}

// UpdateCrlWithContext is the same as UpdateCrl with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) UpdateCrlWithContext(ctx aws.Context, input *UpdateCrlInput, opts ...request.Option) (*UpdateCrlOutput, error) {
	req, out := c.UpdateCrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProfile = "UpdateProfile"

// UpdateProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProfile for more information on using the UpdateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProfileRequest method.
//	req, resp := client.UpdateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UpdateProfile
func (c *RolesAnywhere) UpdateProfileRequest(input *UpdateProfileInput) (req *request.Request, output *UpdateProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateProfile,
		HTTPMethod: "PATCH",
		HTTPPath:   "/profile/{profileId}",
	}

	if input == nil {
		input = &UpdateProfileInput{}
	}

	output = &UpdateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProfile API operation for IAM Roles Anywhere.
//
// Updates a profile, a list of the roles that IAM Roles Anywhere service is
// trusted to assume. You use profiles to intersect permissions with IAM managed
// policies.
//
// Required permissions: rolesanywhere:UpdateProfile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation UpdateProfile for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UpdateProfile
func (c *RolesAnywhere) UpdateProfile(input *UpdateProfileInput) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	return out, req.Send()
}

// UpdateProfileWithContext is the same as UpdateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) UpdateProfileWithContext(ctx aws.Context, input *UpdateProfileInput, opts ...request.Option) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrustAnchor = "UpdateTrustAnchor"

// UpdateTrustAnchorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrustAnchor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrustAnchor for more information on using the UpdateTrustAnchor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTrustAnchorRequest method.
//	req, resp := client.UpdateTrustAnchorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UpdateTrustAnchor
func (c *RolesAnywhere) UpdateTrustAnchorRequest(input *UpdateTrustAnchorInput) (req *request.Request, output *UpdateTrustAnchorOutput) {
	op := &request.Operation{
		Name:       opUpdateTrustAnchor,
		HTTPMethod: "PATCH",
		HTTPPath:   "/trustanchor/{trustAnchorId}",
	}

	if input == nil {
		input = &UpdateTrustAnchorInput{}
	}

	output = &UpdateTrustAnchorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrustAnchor API operation for IAM Roles Anywhere.
//
// Updates a trust anchor. You establish trust between IAM Roles Anywhere and
// your certificate authority (CA) by configuring a trust anchor. You can define
// a trust anchor as a reference to an Private Certificate Authority (Private
// CA) or by uploading a CA certificate. Your Amazon Web Services workloads
// can authenticate with the trust anchor using certificates issued by the CA
// in exchange for temporary Amazon Web Services credentials.
//
// Required permissions: rolesanywhere:UpdateTrustAnchor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for IAM Roles Anywhere's
// API operation UpdateTrustAnchor for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     Validation exception error.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rolesanywhere-2018-05-10/UpdateTrustAnchor
func (c *RolesAnywhere) UpdateTrustAnchor(input *UpdateTrustAnchorInput) (*UpdateTrustAnchorOutput, error) {
	req, out := c.UpdateTrustAnchorRequest(input)
	return out, req.Send()
}

// UpdateTrustAnchorWithContext is the same as UpdateTrustAnchor with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrustAnchor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RolesAnywhere) UpdateTrustAnchorWithContext(ctx aws.Context, input *UpdateTrustAnchorInput, opts ...request.Option) (*UpdateTrustAnchorOutput, error) {
	req, out := c.UpdateTrustAnchorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A mapping applied to the authenticating end-entity certificate.
type AttributeMapping struct {
	_ struct{} `type:"structure"`

	// Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
	CertificateField *string `locationName:"certificateField" type:"string" enum:"CertificateField"`

	// A list of mapping entries for every supported specifier or sub-field.
	MappingRules []*MappingRule `locationName:"mappingRules" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeMapping) GoString() string {
	return s.String()
}

// SetCertificateField sets the CertificateField field's value.
func (s *AttributeMapping) SetCertificateField(v string) *AttributeMapping {
	s.CertificateField = &v
	return s
}

// SetMappingRules sets the MappingRules field's value.
func (s *AttributeMapping) SetMappingRules(v []*MappingRule) *AttributeMapping {
	s.MappingRules = v
	return s
}

type CreateProfileInput struct {
	_ struct{} `type:"structure"`

	// Used to determine if a custom role session name will be accepted in a temporary
	// credential request.
	AcceptRoleSessionName *bool `locationName:"acceptRoleSessionName" type:"boolean"`

	// Used to determine how long sessions vended using this profile are valid for.
	// See the Expiration section of the CreateSession API documentation (https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object)
	// page for more details. In requests, if this value is not provided, the default
	// value will be 3600.
	DurationSeconds *int64 `locationName:"durationSeconds" min:"900" type:"integer"`

	// Specifies whether the profile is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// A list of managed policy ARNs that apply to the vended session credentials.
	ManagedPolicyArns []*string `locationName:"managedPolicyArns" type:"list"`

	// The name of the profile.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Specifies whether instance properties are required in temporary credential
	// requests with this profile.
	RequireInstanceProperties *bool `locationName:"requireInstanceProperties" type:"boolean"`

	// A list of IAM roles that this profile can assume in a temporary credential
	// request.
	//
	// RoleArns is a required field
	RoleArns []*string `locationName:"roleArns" type:"list" required:"true"`

	// A session policy that applies to the trust boundary of the vended session
	// credentials.
	SessionPolicy *string `locationName:"sessionPolicy" type:"string"`

	// The tags to attach to the profile.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProfileInput"}
	if s.DurationSeconds != nil && *s.DurationSeconds < 900 {
		invalidParams.Add(request.NewErrParamMinValue("DurationSeconds", 900))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArns == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArns"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptRoleSessionName sets the AcceptRoleSessionName field's value.
func (s *CreateProfileInput) SetAcceptRoleSessionName(v bool) *CreateProfileInput {
	s.AcceptRoleSessionName = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *CreateProfileInput) SetDurationSeconds(v int64) *CreateProfileInput {
	s.DurationSeconds = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *CreateProfileInput) SetEnabled(v bool) *CreateProfileInput {
	s.Enabled = &v
	return s
}

// SetManagedPolicyArns sets the ManagedPolicyArns field's value.
func (s *CreateProfileInput) SetManagedPolicyArns(v []*string) *CreateProfileInput {
	s.ManagedPolicyArns = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProfileInput) SetName(v string) *CreateProfileInput {
	s.Name = &v
	return s
}

// SetRequireInstanceProperties sets the RequireInstanceProperties field's value.
func (s *CreateProfileInput) SetRequireInstanceProperties(v bool) *CreateProfileInput {
	s.RequireInstanceProperties = &v
	return s
}

// SetRoleArns sets the RoleArns field's value.
func (s *CreateProfileInput) SetRoleArns(v []*string) *CreateProfileInput {
	s.RoleArns = v
	return s
}

// SetSessionPolicy sets the SessionPolicy field's value.
func (s *CreateProfileInput) SetSessionPolicy(v string) *CreateProfileInput {
	s.SessionPolicy = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProfileInput) SetTags(v []*Tag) *CreateProfileInput {
	s.Tags = v
	return s
}

type CreateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The state of the profile after a read or write operation.
	Profile *ProfileDetail `locationName:"profile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *CreateProfileOutput) SetProfile(v *ProfileDetail) *CreateProfileOutput {
	s.Profile = v
	return s
}

type CreateTrustAnchorInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the trust anchor is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The name of the trust anchor.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of notification settings to be associated to the trust anchor.
	NotificationSettings []*NotificationSetting `locationName:"notificationSettings" type:"list"`

	// The trust anchor type and its related certificate data.
	//
	// Source is a required field
	Source *Source `locationName:"source" type:"structure" required:"true"`

	// The tags to attach to the trust anchor.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrustAnchorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrustAnchorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrustAnchorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrustAnchorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.NotificationSettings != nil {
		for i, v := range s.NotificationSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NotificationSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateTrustAnchorInput) SetEnabled(v bool) *CreateTrustAnchorInput {
	s.Enabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTrustAnchorInput) SetName(v string) *CreateTrustAnchorInput {
	s.Name = &v
	return s
}

// SetNotificationSettings sets the NotificationSettings field's value.
func (s *CreateTrustAnchorInput) SetNotificationSettings(v []*NotificationSetting) *CreateTrustAnchorInput {
	s.NotificationSettings = v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateTrustAnchorInput) SetSource(v *Source) *CreateTrustAnchorInput {
	s.Source = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTrustAnchorInput) SetTags(v []*Tag) *CreateTrustAnchorInput {
	s.Tags = v
	return s
}

type CreateTrustAnchorOutput struct {
	_ struct{} `type:"structure"`

	// The state of the trust anchor after a read or write operation.
	//
	// TrustAnchor is a required field
	TrustAnchor *TrustAnchorDetail `locationName:"trustAnchor" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrustAnchorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrustAnchorOutput) GoString() string {
	return s.String()
}

// SetTrustAnchor sets the TrustAnchor field's value.
func (s *CreateTrustAnchorOutput) SetTrustAnchor(v *TrustAnchorDetail) *CreateTrustAnchorOutput {
	s.TrustAnchor = v
	return s
}

// A record of a presented X509 credential from a temporary credential request.
type CredentialSummary struct {
	_ struct{} `type:"structure"`

	// Indicates whether the credential is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// Indicates whether the temporary credential request was successful.
	Failed *bool `locationName:"failed" type:"boolean"`

	// The fully qualified domain name of the issuing certificate for the presented
	// end-entity certificate.
	Issuer *string `locationName:"issuer" type:"string"`

	// The ISO-8601 time stamp of when the certificate was last used in a temporary
	// credential request.
	SeenAt *time.Time `locationName:"seenAt" type:"timestamp" timestampFormat:"iso8601"`

	// The serial number of the certificate.
	SerialNumber *string `locationName:"serialNumber" type:"string"`

	// The PEM-encoded data of the certificate.
	X509CertificateData *string `locationName:"x509CertificateData" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CredentialSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CredentialSummary) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *CredentialSummary) SetEnabled(v bool) *CredentialSummary {
	s.Enabled = &v
	return s
}

// SetFailed sets the Failed field's value.
func (s *CredentialSummary) SetFailed(v bool) *CredentialSummary {
	s.Failed = &v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *CredentialSummary) SetIssuer(v string) *CredentialSummary {
	s.Issuer = &v
	return s
}

// SetSeenAt sets the SeenAt field's value.
func (s *CredentialSummary) SetSeenAt(v time.Time) *CredentialSummary {
	s.SeenAt = &v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *CredentialSummary) SetSerialNumber(v string) *CredentialSummary {
	s.SerialNumber = &v
	return s
}

// SetX509CertificateData sets the X509CertificateData field's value.
func (s *CredentialSummary) SetX509CertificateData(v string) *CredentialSummary {
	s.X509CertificateData = &v
	return s
}

// The state of the certificate revocation list (CRL) after a read or write
// operation.
type CrlDetail struct {
	_ struct{} `type:"structure"`

	// The ISO-8601 timestamp when the certificate revocation list (CRL) was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ARN of the certificate revocation list (CRL).
	CrlArn *string `locationName:"crlArn" type:"string"`

	// The state of the certificate revocation list (CRL) after a read or write
	// operation.
	// CrlData is automatically base64 encoded/decoded by the SDK.
	CrlData []byte `locationName:"crlData" type:"blob"`

	// The unique identifier of the certificate revocation list (CRL).
	CrlId *string `locationName:"crlId" min:"36" type:"string"`

	// Indicates whether the certificate revocation list (CRL) is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The name of the certificate revocation list (CRL).
	Name *string `locationName:"name" type:"string"`

	// The ARN of the TrustAnchor the certificate revocation list (CRL) will provide
	// revocation for.
	TrustAnchorArn *string `locationName:"trustAnchorArn" type:"string"`

	// The ISO-8601 timestamp when the certificate revocation list (CRL) was last
	// updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrlDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrlDetail) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CrlDetail) SetCreatedAt(v time.Time) *CrlDetail {
	s.CreatedAt = &v
	return s
}

// SetCrlArn sets the CrlArn field's value.
func (s *CrlDetail) SetCrlArn(v string) *CrlDetail {
	s.CrlArn = &v
	return s
}

// SetCrlData sets the CrlData field's value.
func (s *CrlDetail) SetCrlData(v []byte) *CrlDetail {
	s.CrlData = v
	return s
}

// SetCrlId sets the CrlId field's value.
func (s *CrlDetail) SetCrlId(v string) *CrlDetail {
	s.CrlId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *CrlDetail) SetEnabled(v bool) *CrlDetail {
	s.Enabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *CrlDetail) SetName(v string) *CrlDetail {
	s.Name = &v
	return s
}

// SetTrustAnchorArn sets the TrustAnchorArn field's value.
func (s *CrlDetail) SetTrustAnchorArn(v string) *CrlDetail {
	s.TrustAnchorArn = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CrlDetail) SetUpdatedAt(v time.Time) *CrlDetail {
	s.UpdatedAt = &v
	return s
}

type DeleteAttributeMappingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
	//
	// CertificateField is a required field
	CertificateField *string `location:"querystring" locationName:"certificateField" type:"string" required:"true" enum:"CertificateField"`

	// The unique identifier of the profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"profileId" min:"36" type:"string" required:"true"`

	// A list of specifiers of a certificate field; for example, CN, OU, UID from
	// a Subject.
	Specifiers []*string `location:"querystring" locationName:"specifiers" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttributeMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttributeMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAttributeMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAttributeMappingInput"}
	if s.CertificateField == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateField"))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateField sets the CertificateField field's value.
func (s *DeleteAttributeMappingInput) SetCertificateField(v string) *DeleteAttributeMappingInput {
	s.CertificateField = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *DeleteAttributeMappingInput) SetProfileId(v string) *DeleteAttributeMappingInput {
	s.ProfileId = &v
	return s
}

// SetSpecifiers sets the Specifiers field's value.
func (s *DeleteAttributeMappingInput) SetSpecifiers(v []*string) *DeleteAttributeMappingInput {
	s.Specifiers = v
	return s
}

type DeleteAttributeMappingOutput struct {
	_ struct{} `type:"structure"`

	// The state of the profile after a read or write operation.
	//
	// Profile is a required field
	Profile *ProfileDetail `locationName:"profile" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttributeMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttributeMappingOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *DeleteAttributeMappingOutput) SetProfile(v *ProfileDetail) *DeleteAttributeMappingOutput {
	s.Profile = v
	return s
}

type DeleteCrlInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the certificate revocation list (CRL).
	//
	// CrlId is a required field
	CrlId *string `location:"uri" locationName:"crlId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCrlInput"}
	if s.CrlId == nil {
		invalidParams.Add(request.NewErrParamRequired("CrlId"))
	}
	if s.CrlId != nil && len(*s.CrlId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CrlId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrlId sets the CrlId field's value.
func (s *DeleteCrlInput) SetCrlId(v string) *DeleteCrlInput {
	s.CrlId = &v
	return s
}

type DeleteCrlOutput struct {
	_ struct{} `type:"structure"`

	// The state of the certificate revocation list (CRL) after a read or write
	// operation.
	//
	// Crl is a required field
	Crl *CrlDetail `locationName:"crl" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCrlOutput) GoString() string {
	return s.String()
}

// SetCrl sets the Crl field's value.
func (s *DeleteCrlOutput) SetCrl(v *CrlDetail) *DeleteCrlOutput {
	s.Crl = v
	return s
}

type DeleteProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"profileId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileInput"}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileId sets the ProfileId field's value.
func (s *DeleteProfileInput) SetProfileId(v string) *DeleteProfileInput {
	s.ProfileId = &v
	return s
}

type DeleteProfileOutput struct {
	_ struct{} `type:"structure"`

	// The state of the profile after a read or write operation.
	Profile *ProfileDetail `locationName:"profile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *DeleteProfileOutput) SetProfile(v *ProfileDetail) *DeleteProfileOutput {
	s.Profile = v
	return s
}

type DeleteTrustAnchorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the trust anchor.
	//
	// TrustAnchorId is a required field
	TrustAnchorId *string `location:"uri" locationName:"trustAnchorId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrustAnchorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrustAnchorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrustAnchorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrustAnchorInput"}
	if s.TrustAnchorId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustAnchorId"))
	}
	if s.TrustAnchorId != nil && len(*s.TrustAnchorId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchorId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrustAnchorId sets the TrustAnchorId field's value.
func (s *DeleteTrustAnchorInput) SetTrustAnchorId(v string) *DeleteTrustAnchorInput {
	s.TrustAnchorId = &v
	return s
}

type DeleteTrustAnchorOutput struct {
	_ struct{} `type:"structure"`

	// The state of the trust anchor after a read or write operation.
	//
	// TrustAnchor is a required field
	TrustAnchor *TrustAnchorDetail `locationName:"trustAnchor" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrustAnchorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrustAnchorOutput) GoString() string {
	return s.String()
}

// SetTrustAnchor sets the TrustAnchor field's value.
func (s *DeleteTrustAnchorOutput) SetTrustAnchor(v *TrustAnchorDetail) *DeleteTrustAnchorOutput {
	s.TrustAnchor = v
	return s
}

type DisableCrlInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the certificate revocation list (CRL).
	//
	// CrlId is a required field
	CrlId *string `location:"uri" locationName:"crlId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableCrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableCrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableCrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableCrlInput"}
	if s.CrlId == nil {
		invalidParams.Add(request.NewErrParamRequired("CrlId"))
	}
	if s.CrlId != nil && len(*s.CrlId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CrlId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrlId sets the CrlId field's value.
func (s *DisableCrlInput) SetCrlId(v string) *DisableCrlInput {
	s.CrlId = &v
	return s
}

type DisableCrlOutput struct {
	_ struct{} `type:"structure"`

	// The state of the certificate revocation list (CRL) after a read or write
	// operation.
	//
	// Crl is a required field
	Crl *CrlDetail `locationName:"crl" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableCrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableCrlOutput) GoString() string {
	return s.String()
}

// SetCrl sets the Crl field's value.
func (s *DisableCrlOutput) SetCrl(v *CrlDetail) *DisableCrlOutput {
	s.Crl = v
	return s
}

type DisableProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"profileId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableProfileInput"}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileId sets the ProfileId field's value.
func (s *DisableProfileInput) SetProfileId(v string) *DisableProfileInput {
	s.ProfileId = &v
	return s
}

type DisableProfileOutput struct {
	_ struct{} `type:"structure"`

	// The state of the profile after a read or write operation.
	Profile *ProfileDetail `locationName:"profile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *DisableProfileOutput) SetProfile(v *ProfileDetail) *DisableProfileOutput {
	s.Profile = v
	return s
}

type DisableTrustAnchorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the trust anchor.
	//
	// TrustAnchorId is a required field
	TrustAnchorId *string `location:"uri" locationName:"trustAnchorId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableTrustAnchorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableTrustAnchorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableTrustAnchorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableTrustAnchorInput"}
	if s.TrustAnchorId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustAnchorId"))
	}
	if s.TrustAnchorId != nil && len(*s.TrustAnchorId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchorId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrustAnchorId sets the TrustAnchorId field's value.
func (s *DisableTrustAnchorInput) SetTrustAnchorId(v string) *DisableTrustAnchorInput {
	s.TrustAnchorId = &v
	return s
}

type DisableTrustAnchorOutput struct {
	_ struct{} `type:"structure"`

	// The state of the trust anchor after a read or write operation.
	//
	// TrustAnchor is a required field
	TrustAnchor *TrustAnchorDetail `locationName:"trustAnchor" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableTrustAnchorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableTrustAnchorOutput) GoString() string {
	return s.String()
}

// SetTrustAnchor sets the TrustAnchor field's value.
func (s *DisableTrustAnchorOutput) SetTrustAnchor(v *TrustAnchorDetail) *DisableTrustAnchorOutput {
	s.TrustAnchor = v
	return s
}

type EnableCrlInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the certificate revocation list (CRL).
	//
	// CrlId is a required field
	CrlId *string `location:"uri" locationName:"crlId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableCrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableCrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableCrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableCrlInput"}
	if s.CrlId == nil {
		invalidParams.Add(request.NewErrParamRequired("CrlId"))
	}
	if s.CrlId != nil && len(*s.CrlId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CrlId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrlId sets the CrlId field's value.
func (s *EnableCrlInput) SetCrlId(v string) *EnableCrlInput {
	s.CrlId = &v
	return s
}

type EnableCrlOutput struct {
	_ struct{} `type:"structure"`

	// The state of the certificate revocation list (CRL) after a read or write
	// operation.
	//
	// Crl is a required field
	Crl *CrlDetail `locationName:"crl" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableCrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableCrlOutput) GoString() string {
	return s.String()
}

// SetCrl sets the Crl field's value.
func (s *EnableCrlOutput) SetCrl(v *CrlDetail) *EnableCrlOutput {
	s.Crl = v
	return s
}

type EnableProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"profileId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableProfileInput"}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileId sets the ProfileId field's value.
func (s *EnableProfileInput) SetProfileId(v string) *EnableProfileInput {
	s.ProfileId = &v
	return s
}

type EnableProfileOutput struct {
	_ struct{} `type:"structure"`

	// The state of the profile after a read or write operation.
	Profile *ProfileDetail `locationName:"profile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *EnableProfileOutput) SetProfile(v *ProfileDetail) *EnableProfileOutput {
	s.Profile = v
	return s
}

type EnableTrustAnchorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the trust anchor.
	//
	// TrustAnchorId is a required field
	TrustAnchorId *string `location:"uri" locationName:"trustAnchorId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableTrustAnchorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableTrustAnchorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableTrustAnchorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableTrustAnchorInput"}
	if s.TrustAnchorId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustAnchorId"))
	}
	if s.TrustAnchorId != nil && len(*s.TrustAnchorId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchorId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrustAnchorId sets the TrustAnchorId field's value.
func (s *EnableTrustAnchorInput) SetTrustAnchorId(v string) *EnableTrustAnchorInput {
	s.TrustAnchorId = &v
	return s
}

type EnableTrustAnchorOutput struct {
	_ struct{} `type:"structure"`

	// The state of the trust anchor after a read or write operation.
	//
	// TrustAnchor is a required field
	TrustAnchor *TrustAnchorDetail `locationName:"trustAnchor" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableTrustAnchorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableTrustAnchorOutput) GoString() string {
	return s.String()
}

// SetTrustAnchor sets the TrustAnchor field's value.
func (s *EnableTrustAnchorOutput) SetTrustAnchor(v *TrustAnchorDetail) *EnableTrustAnchorOutput {
	s.TrustAnchor = v
	return s
}

type GetCrlInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the certificate revocation list (CRL).
	//
	// CrlId is a required field
	CrlId *string `location:"uri" locationName:"crlId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCrlInput"}
	if s.CrlId == nil {
		invalidParams.Add(request.NewErrParamRequired("CrlId"))
	}
	if s.CrlId != nil && len(*s.CrlId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CrlId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrlId sets the CrlId field's value.
func (s *GetCrlInput) SetCrlId(v string) *GetCrlInput {
	s.CrlId = &v
	return s
}

type GetCrlOutput struct {
	_ struct{} `type:"structure"`

	// The state of the certificate revocation list (CRL) after a read or write
	// operation.
	//
	// Crl is a required field
	Crl *CrlDetail `locationName:"crl" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCrlOutput) GoString() string {
	return s.String()
}

// SetCrl sets the Crl field's value.
func (s *GetCrlOutput) SetCrl(v *CrlDetail) *GetCrlOutput {
	s.Crl = v
	return s
}

type GetProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"profileId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProfileInput"}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileId sets the ProfileId field's value.
func (s *GetProfileInput) SetProfileId(v string) *GetProfileInput {
	s.ProfileId = &v
	return s
}

type GetProfileOutput struct {
	_ struct{} `type:"structure"`

	// The state of the profile after a read or write operation.
	Profile *ProfileDetail `locationName:"profile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *GetProfileOutput) SetProfile(v *ProfileDetail) *GetProfileOutput {
	s.Profile = v
	return s
}

type GetSubjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the subject.
	//
	// SubjectId is a required field
	SubjectId *string `location:"uri" locationName:"subjectId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSubjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSubjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSubjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSubjectInput"}
	if s.SubjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubjectId"))
	}
	if s.SubjectId != nil && len(*s.SubjectId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("SubjectId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubjectId sets the SubjectId field's value.
func (s *GetSubjectInput) SetSubjectId(v string) *GetSubjectInput {
	s.SubjectId = &v
	return s
}

type GetSubjectOutput struct {
	_ struct{} `type:"structure"`

	// The state of the subject after a read or write operation.
	Subject *SubjectDetail `locationName:"subject" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSubjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSubjectOutput) GoString() string {
	return s.String()
}

// SetSubject sets the Subject field's value.
func (s *GetSubjectOutput) SetSubject(v *SubjectDetail) *GetSubjectOutput {
	s.Subject = v
	return s
}

type GetTrustAnchorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the trust anchor.
	//
	// TrustAnchorId is a required field
	TrustAnchorId *string `location:"uri" locationName:"trustAnchorId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrustAnchorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrustAnchorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrustAnchorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTrustAnchorInput"}
	if s.TrustAnchorId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustAnchorId"))
	}
	if s.TrustAnchorId != nil && len(*s.TrustAnchorId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchorId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrustAnchorId sets the TrustAnchorId field's value.
func (s *GetTrustAnchorInput) SetTrustAnchorId(v string) *GetTrustAnchorInput {
	s.TrustAnchorId = &v
	return s
}

type GetTrustAnchorOutput struct {
	_ struct{} `type:"structure"`

	// The state of the trust anchor after a read or write operation.
	//
	// TrustAnchor is a required field
	TrustAnchor *TrustAnchorDetail `locationName:"trustAnchor" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrustAnchorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrustAnchorOutput) GoString() string {
	return s.String()
}

// SetTrustAnchor sets the TrustAnchor field's value.
func (s *GetTrustAnchorOutput) SetTrustAnchor(v *TrustAnchorDetail) *GetTrustAnchorOutput {
	s.TrustAnchor = v
	return s
}

type ImportCrlInput struct {
	_ struct{} `type:"structure"`

	// The x509 v3 specified certificate revocation list (CRL).
	// CrlData is automatically base64 encoded/decoded by the SDK.
	//
	// CrlData is a required field
	CrlData []byte `locationName:"crlData" min:"1" type:"blob" required:"true"`

	// Specifies whether the certificate revocation list (CRL) is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The name of the certificate revocation list (CRL).
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of tags to attach to the certificate revocation list (CRL).
	Tags []*Tag `locationName:"tags" type:"list"`

	// The ARN of the TrustAnchor the certificate revocation list (CRL) will provide
	// revocation for.
	//
	// TrustAnchorArn is a required field
	TrustAnchorArn *string `locationName:"trustAnchorArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportCrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportCrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportCrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportCrlInput"}
	if s.CrlData == nil {
		invalidParams.Add(request.NewErrParamRequired("CrlData"))
	}
	if s.CrlData != nil && len(s.CrlData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrlData", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TrustAnchorArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustAnchorArn"))
	}
	if s.TrustAnchorArn != nil && len(*s.TrustAnchorArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchorArn", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrlData sets the CrlData field's value.
func (s *ImportCrlInput) SetCrlData(v []byte) *ImportCrlInput {
	s.CrlData = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ImportCrlInput) SetEnabled(v bool) *ImportCrlInput {
	s.Enabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportCrlInput) SetName(v string) *ImportCrlInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportCrlInput) SetTags(v []*Tag) *ImportCrlInput {
	s.Tags = v
	return s
}

// SetTrustAnchorArn sets the TrustAnchorArn field's value.
func (s *ImportCrlInput) SetTrustAnchorArn(v string) *ImportCrlInput {
	s.TrustAnchorArn = &v
	return s
}

type ImportCrlOutput struct {
	_ struct{} `type:"structure"`

	// The state of the certificate revocation list (CRL) after a read or write
	// operation.
	//
	// Crl is a required field
	Crl *CrlDetail `locationName:"crl" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportCrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportCrlOutput) GoString() string {
	return s.String()
}

// SetCrl sets the Crl field's value.
func (s *ImportCrlOutput) SetCrl(v *CrlDetail) *ImportCrlOutput {
	s.Crl = v
	return s
}

// A key-value pair you set that identifies a property of the authenticating
// instance.
type InstanceProperty struct {
	_ struct{} `type:"structure"`

	// Indicates whether the temporary credential request was successful.
	Failed *bool `locationName:"failed" type:"boolean"`

	// A list of instanceProperty objects.
	Properties map[string]*string `locationName:"properties" type:"map"`

	// The ISO-8601 time stamp of when the certificate was last used in a temporary
	// credential request.
	SeenAt *time.Time `locationName:"seenAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceProperty) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *InstanceProperty) SetFailed(v bool) *InstanceProperty {
	s.Failed = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *InstanceProperty) SetProperties(v map[string]*string) *InstanceProperty {
	s.Properties = v
	return s
}

// SetSeenAt sets the SeenAt field's value.
func (s *InstanceProperty) SetSeenAt(v time.Time) *InstanceProperty {
	s.SeenAt = &v
	return s
}

type ListCrlsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A token that indicates where the output should continue from, if a previous
	// request did not show all results. To get the next results, make the request
	// again with this value.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The number of resources in the paginated list.
	PageSize *int64 `location:"querystring" locationName:"pageSize" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrlsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrlsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCrlsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCrlsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListCrlsInput) SetNextToken(v string) *ListCrlsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListCrlsInput) SetPageSize(v int64) *ListCrlsInput {
	s.PageSize = &v
	return s
}

type ListCrlsOutput struct {
	_ struct{} `type:"structure"`

	// A list of certificate revocation lists (CRL).
	Crls []*CrlDetail `locationName:"crls" type:"list"`

	// A token that indicates where the output should continue from, if a previous
	// request did not show all results. To get the next results, make the request
	// again with this value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrlsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCrlsOutput) GoString() string {
	return s.String()
}

// SetCrls sets the Crls field's value.
func (s *ListCrlsOutput) SetCrls(v []*CrlDetail) *ListCrlsOutput {
	s.Crls = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCrlsOutput) SetNextToken(v string) *ListCrlsOutput {
	s.NextToken = &v
	return s
}

type ListProfilesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A token that indicates where the output should continue from, if a previous
	// request did not show all results. To get the next results, make the request
	// again with this value.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The number of resources in the paginated list.
	PageSize *int64 `location:"querystring" locationName:"pageSize" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfilesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfilesInput) SetNextToken(v string) *ListProfilesInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListProfilesInput) SetPageSize(v int64) *ListProfilesInput {
	s.PageSize = &v
	return s
}

type ListProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates where the output should continue from, if a previous
	// request did not show all results. To get the next results, make the request
	// again with this value.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of profiles.
	Profiles []*ProfileDetail `locationName:"profiles" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfilesOutput) SetNextToken(v string) *ListProfilesOutput {
	s.NextToken = &v
	return s
}

// SetProfiles sets the Profiles field's value.
func (s *ListProfilesOutput) SetProfiles(v []*ProfileDetail) *ListProfilesOutput {
	s.Profiles = v
	return s
}

type ListSubjectsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A token that indicates where the output should continue from, if a previous
	// request did not show all results. To get the next results, make the request
	// again with this value.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The number of resources in the paginated list.
	PageSize *int64 `location:"querystring" locationName:"pageSize" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSubjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSubjectsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubjectsInput) SetNextToken(v string) *ListSubjectsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListSubjectsInput) SetPageSize(v int64) *ListSubjectsInput {
	s.PageSize = &v
	return s
}

type ListSubjectsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates where the output should continue from, if a previous
	// request did not show all results. To get the next results, make the request
	// again with this value.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of subjects.
	Subjects []*SubjectSummary `locationName:"subjects" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSubjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubjectsOutput) SetNextToken(v string) *ListSubjectsOutput {
	s.NextToken = &v
	return s
}

// SetSubjects sets the Subjects field's value.
func (s *ListSubjectsOutput) SetSubjects(v []*SubjectSummary) *ListSubjectsOutput {
	s.Subjects = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags attached to the resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTrustAnchorsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A token that indicates where the output should continue from, if a previous
	// request did not show all results. To get the next results, make the request
	// again with this value.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The number of resources in the paginated list.
	PageSize *int64 `location:"querystring" locationName:"pageSize" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustAnchorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustAnchorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrustAnchorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrustAnchorsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrustAnchorsInput) SetNextToken(v string) *ListTrustAnchorsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTrustAnchorsInput) SetPageSize(v int64) *ListTrustAnchorsInput {
	s.PageSize = &v
	return s
}

type ListTrustAnchorsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates where the output should continue from, if a previous
	// request did not show all results. To get the next results, make the request
	// again with this value.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of trust anchors.
	TrustAnchors []*TrustAnchorDetail `locationName:"trustAnchors" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustAnchorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustAnchorsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrustAnchorsOutput) SetNextToken(v string) *ListTrustAnchorsOutput {
	s.NextToken = &v
	return s
}

// SetTrustAnchors sets the TrustAnchors field's value.
func (s *ListTrustAnchorsOutput) SetTrustAnchors(v []*TrustAnchorDetail) *ListTrustAnchorsOutput {
	s.TrustAnchors = v
	return s
}

// A single mapping entry for each supported specifier or sub-field.
type MappingRule struct {
	_ struct{} `type:"structure"`

	// Specifier within a certificate field, such as CN, OU, or UID from the Subject
	// field.
	//
	// Specifier is a required field
	Specifier *string `locationName:"specifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MappingRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MappingRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MappingRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MappingRule"}
	if s.Specifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Specifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSpecifier sets the Specifier field's value.
func (s *MappingRule) SetSpecifier(v string) *MappingRule {
	s.Specifier = &v
	return s
}

// Customizable notification settings that will be applied to notification events.
// IAM Roles Anywhere consumes these settings while notifying across multiple
// channels - CloudWatch metrics, EventBridge, and Health Dashboard.
type NotificationSetting struct {
	_ struct{} `type:"structure"`

	// The specified channel of notification. IAM Roles Anywhere uses CloudWatch
	// metrics, EventBridge, and Health Dashboard to notify for an event.
	//
	// In the absence of a specific channel, IAM Roles Anywhere applies this setting
	// to 'ALL' channels.
	Channel *string `locationName:"channel" type:"string" enum:"NotificationChannel"`

	// Indicates whether the notification setting is enabled.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The event to which this notification setting is applied.
	//
	// Event is a required field
	Event *string `locationName:"event" type:"string" required:"true" enum:"NotificationEvent"`

	// The number of days before a notification event. This value is required for
	// a notification setting that is enabled.
	Threshold *int64 `locationName:"threshold" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationSetting"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Event == nil {
		invalidParams.Add(request.NewErrParamRequired("Event"))
	}
	if s.Threshold != nil && *s.Threshold < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Threshold", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannel sets the Channel field's value.
func (s *NotificationSetting) SetChannel(v string) *NotificationSetting {
	s.Channel = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *NotificationSetting) SetEnabled(v bool) *NotificationSetting {
	s.Enabled = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *NotificationSetting) SetEvent(v string) *NotificationSetting {
	s.Event = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *NotificationSetting) SetThreshold(v int64) *NotificationSetting {
	s.Threshold = &v
	return s
}

// The state of a notification setting.
//
// A notification setting includes information such as event name, threshold,
// status of the notification setting, and the channel to notify.
type NotificationSettingDetail struct {
	_ struct{} `type:"structure"`

	// The specified channel of notification. IAM Roles Anywhere uses CloudWatch
	// metrics, EventBridge, and Health Dashboard to notify for an event.
	//
	// In the absence of a specific channel, IAM Roles Anywhere applies this setting
	// to 'ALL' channels.
	Channel *string `locationName:"channel" type:"string" enum:"NotificationChannel"`

	// The principal that configured the notification setting. For default settings
	// configured by IAM Roles Anywhere, the value is rolesanywhere.amazonaws.com,
	// and for customized notifications settings, it is the respective account ID.
	ConfiguredBy *string `locationName:"configuredBy" min:"1" type:"string"`

	// Indicates whether the notification setting is enabled.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The event to which this notification setting is applied.
	//
	// Event is a required field
	Event *string `locationName:"event" type:"string" required:"true" enum:"NotificationEvent"`

	// The number of days before a notification event.
	Threshold *int64 `locationName:"threshold" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationSettingDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationSettingDetail) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *NotificationSettingDetail) SetChannel(v string) *NotificationSettingDetail {
	s.Channel = &v
	return s
}

// SetConfiguredBy sets the ConfiguredBy field's value.
func (s *NotificationSettingDetail) SetConfiguredBy(v string) *NotificationSettingDetail {
	s.ConfiguredBy = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *NotificationSettingDetail) SetEnabled(v bool) *NotificationSettingDetail {
	s.Enabled = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *NotificationSettingDetail) SetEvent(v string) *NotificationSettingDetail {
	s.Event = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *NotificationSettingDetail) SetThreshold(v int64) *NotificationSettingDetail {
	s.Threshold = &v
	return s
}

// A notification setting key to reset. A notification setting key includes
// the event and the channel.
type NotificationSettingKey struct {
	_ struct{} `type:"structure"`

	// The specified channel of notification.
	Channel *string `locationName:"channel" type:"string" enum:"NotificationChannel"`

	// The notification setting event to reset.
	//
	// Event is a required field
	Event *string `locationName:"event" type:"string" required:"true" enum:"NotificationEvent"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationSettingKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationSettingKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationSettingKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationSettingKey"}
	if s.Event == nil {
		invalidParams.Add(request.NewErrParamRequired("Event"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannel sets the Channel field's value.
func (s *NotificationSettingKey) SetChannel(v string) *NotificationSettingKey {
	s.Channel = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *NotificationSettingKey) SetEvent(v string) *NotificationSettingKey {
	s.Event = &v
	return s
}

// The state of the profile after a read or write operation.
type ProfileDetail struct {
	_ struct{} `type:"structure"`

	// Used to determine if a custom role session name will be accepted in a temporary
	// credential request.
	AcceptRoleSessionName *bool `locationName:"acceptRoleSessionName" type:"boolean"`

	// A mapping applied to the authenticating end-entity certificate.
	AttributeMappings []*AttributeMapping `locationName:"attributeMappings" type:"list"`

	// The ISO-8601 timestamp when the profile was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Web Services account that created the profile.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// Used to determine how long sessions vended using this profile are valid for.
	// See the Expiration section of the CreateSession API documentation (https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object)
	// page for more details. In requests, if this value is not provided, the default
	// value will be 3600.
	DurationSeconds *int64 `locationName:"durationSeconds" type:"integer"`

	// Indicates whether the profile is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// A list of managed policy ARNs that apply to the vended session credentials.
	ManagedPolicyArns []*string `locationName:"managedPolicyArns" type:"list"`

	// The name of the profile.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The ARN of the profile.
	ProfileArn *string `locationName:"profileArn" min:"1" type:"string"`

	// The unique identifier of the profile.
	ProfileId *string `locationName:"profileId" min:"36" type:"string"`

	// Specifies whether instance properties are required in temporary credential
	// requests with this profile.
	RequireInstanceProperties *bool `locationName:"requireInstanceProperties" type:"boolean"`

	// A list of IAM roles that this profile can assume in a temporary credential
	// request.
	RoleArns []*string `locationName:"roleArns" type:"list"`

	// A session policy that applies to the trust boundary of the vended session
	// credentials.
	SessionPolicy *string `locationName:"sessionPolicy" type:"string"`

	// The ISO-8601 timestamp when the profile was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileDetail) GoString() string {
	return s.String()
}

// SetAcceptRoleSessionName sets the AcceptRoleSessionName field's value.
func (s *ProfileDetail) SetAcceptRoleSessionName(v bool) *ProfileDetail {
	s.AcceptRoleSessionName = &v
	return s
}

// SetAttributeMappings sets the AttributeMappings field's value.
func (s *ProfileDetail) SetAttributeMappings(v []*AttributeMapping) *ProfileDetail {
	s.AttributeMappings = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ProfileDetail) SetCreatedAt(v time.Time) *ProfileDetail {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ProfileDetail) SetCreatedBy(v string) *ProfileDetail {
	s.CreatedBy = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *ProfileDetail) SetDurationSeconds(v int64) *ProfileDetail {
	s.DurationSeconds = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ProfileDetail) SetEnabled(v bool) *ProfileDetail {
	s.Enabled = &v
	return s
}

// SetManagedPolicyArns sets the ManagedPolicyArns field's value.
func (s *ProfileDetail) SetManagedPolicyArns(v []*string) *ProfileDetail {
	s.ManagedPolicyArns = v
	return s
}

// SetName sets the Name field's value.
func (s *ProfileDetail) SetName(v string) *ProfileDetail {
	s.Name = &v
	return s
}

// SetProfileArn sets the ProfileArn field's value.
func (s *ProfileDetail) SetProfileArn(v string) *ProfileDetail {
	s.ProfileArn = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *ProfileDetail) SetProfileId(v string) *ProfileDetail {
	s.ProfileId = &v
	return s
}

// SetRequireInstanceProperties sets the RequireInstanceProperties field's value.
func (s *ProfileDetail) SetRequireInstanceProperties(v bool) *ProfileDetail {
	s.RequireInstanceProperties = &v
	return s
}

// SetRoleArns sets the RoleArns field's value.
func (s *ProfileDetail) SetRoleArns(v []*string) *ProfileDetail {
	s.RoleArns = v
	return s
}

// SetSessionPolicy sets the SessionPolicy field's value.
func (s *ProfileDetail) SetSessionPolicy(v string) *ProfileDetail {
	s.SessionPolicy = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ProfileDetail) SetUpdatedAt(v time.Time) *ProfileDetail {
	s.UpdatedAt = &v
	return s
}

type PutAttributeMappingInput struct {
	_ struct{} `type:"structure"`

	// Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.
	//
	// CertificateField is a required field
	CertificateField *string `locationName:"certificateField" type:"string" required:"true" enum:"CertificateField"`

	// A list of mapping entries for every supported specifier or sub-field.
	//
	// MappingRules is a required field
	MappingRules []*MappingRule `locationName:"mappingRules" type:"list" required:"true"`

	// The unique identifier of the profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"profileId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAttributeMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAttributeMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAttributeMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAttributeMappingInput"}
	if s.CertificateField == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateField"))
	}
	if s.MappingRules == nil {
		invalidParams.Add(request.NewErrParamRequired("MappingRules"))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 36))
	}
	if s.MappingRules != nil {
		for i, v := range s.MappingRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MappingRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateField sets the CertificateField field's value.
func (s *PutAttributeMappingInput) SetCertificateField(v string) *PutAttributeMappingInput {
	s.CertificateField = &v
	return s
}

// SetMappingRules sets the MappingRules field's value.
func (s *PutAttributeMappingInput) SetMappingRules(v []*MappingRule) *PutAttributeMappingInput {
	s.MappingRules = v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *PutAttributeMappingInput) SetProfileId(v string) *PutAttributeMappingInput {
	s.ProfileId = &v
	return s
}

type PutAttributeMappingOutput struct {
	_ struct{} `type:"structure"`

	// The state of the profile after a read or write operation.
	//
	// Profile is a required field
	Profile *ProfileDetail `locationName:"profile" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAttributeMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAttributeMappingOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *PutAttributeMappingOutput) SetProfile(v *ProfileDetail) *PutAttributeMappingOutput {
	s.Profile = v
	return s
}

type PutNotificationSettingsInput struct {
	_ struct{} `type:"structure"`

	// A list of notification settings to be associated to the trust anchor.
	//
	// NotificationSettings is a required field
	NotificationSettings []*NotificationSetting `locationName:"notificationSettings" type:"list" required:"true"`

	// The unique identifier of the trust anchor.
	//
	// TrustAnchorId is a required field
	TrustAnchorId *string `locationName:"trustAnchorId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutNotificationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutNotificationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutNotificationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutNotificationSettingsInput"}
	if s.NotificationSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationSettings"))
	}
	if s.TrustAnchorId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustAnchorId"))
	}
	if s.TrustAnchorId != nil && len(*s.TrustAnchorId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchorId", 36))
	}
	if s.NotificationSettings != nil {
		for i, v := range s.NotificationSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NotificationSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotificationSettings sets the NotificationSettings field's value.
func (s *PutNotificationSettingsInput) SetNotificationSettings(v []*NotificationSetting) *PutNotificationSettingsInput {
	s.NotificationSettings = v
	return s
}

// SetTrustAnchorId sets the TrustAnchorId field's value.
func (s *PutNotificationSettingsInput) SetTrustAnchorId(v string) *PutNotificationSettingsInput {
	s.TrustAnchorId = &v
	return s
}

type PutNotificationSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The state of the trust anchor after a read or write operation.
	//
	// TrustAnchor is a required field
	TrustAnchor *TrustAnchorDetail `locationName:"trustAnchor" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutNotificationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutNotificationSettingsOutput) GoString() string {
	return s.String()
}

// SetTrustAnchor sets the TrustAnchor field's value.
func (s *PutNotificationSettingsOutput) SetTrustAnchor(v *TrustAnchorDetail) *PutNotificationSettingsOutput {
	s.TrustAnchor = v
	return s
}

type ResetNotificationSettingsInput struct {
	_ struct{} `type:"structure"`

	// A list of notification setting keys to reset. A notification setting key
	// includes the event and the channel.
	//
	// NotificationSettingKeys is a required field
	NotificationSettingKeys []*NotificationSettingKey `locationName:"notificationSettingKeys" type:"list" required:"true"`

	// The unique identifier of the trust anchor.
	//
	// TrustAnchorId is a required field
	TrustAnchorId *string `locationName:"trustAnchorId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResetNotificationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResetNotificationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetNotificationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetNotificationSettingsInput"}
	if s.NotificationSettingKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationSettingKeys"))
	}
	if s.TrustAnchorId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustAnchorId"))
	}
	if s.TrustAnchorId != nil && len(*s.TrustAnchorId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchorId", 36))
	}
	if s.NotificationSettingKeys != nil {
		for i, v := range s.NotificationSettingKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NotificationSettingKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotificationSettingKeys sets the NotificationSettingKeys field's value.
func (s *ResetNotificationSettingsInput) SetNotificationSettingKeys(v []*NotificationSettingKey) *ResetNotificationSettingsInput {
	s.NotificationSettingKeys = v
	return s
}

// SetTrustAnchorId sets the TrustAnchorId field's value.
func (s *ResetNotificationSettingsInput) SetTrustAnchorId(v string) *ResetNotificationSettingsInput {
	s.TrustAnchorId = &v
	return s
}

type ResetNotificationSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The state of the trust anchor after a read or write operation.
	//
	// TrustAnchor is a required field
	TrustAnchor *TrustAnchorDetail `locationName:"trustAnchor" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResetNotificationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResetNotificationSettingsOutput) GoString() string {
	return s.String()
}

// SetTrustAnchor sets the TrustAnchor field's value.
func (s *ResetNotificationSettingsOutput) SetTrustAnchor(v *TrustAnchorDetail) *ResetNotificationSettingsOutput {
	s.TrustAnchor = v
	return s
}

// The resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The trust anchor type and its related certificate data.
type Source struct {
	_ struct{} `type:"structure"`

	// The data field of the trust anchor depending on its type.
	SourceData *SourceData `locationName:"sourceData" type:"structure"`

	// The type of the trust anchor.
	SourceType *string `locationName:"sourceType" type:"string" enum:"TrustAnchorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Source) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Source) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Source"}
	if s.SourceData != nil {
		if err := s.SourceData.Validate(); err != nil {
			invalidParams.AddNested("SourceData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceData sets the SourceData field's value.
func (s *Source) SetSourceData(v *SourceData) *Source {
	s.SourceData = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Source) SetSourceType(v string) *Source {
	s.SourceType = &v
	return s
}

// The data field of the trust anchor depending on its type.
type SourceData struct {
	_ struct{} `type:"structure"`

	// The root certificate of the Private Certificate Authority specified by this
	// ARN is used in trust validation for temporary credential requests. Included
	// for trust anchors of type AWS_ACM_PCA.
	AcmPcaArn *string `locationName:"acmPcaArn" type:"string"`

	// The PEM-encoded data for the certificate anchor. Included for trust anchors
	// of type CERTIFICATE_BUNDLE.
	X509CertificateData *string `locationName:"x509CertificateData" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceData"}
	if s.X509CertificateData != nil && len(*s.X509CertificateData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("X509CertificateData", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcmPcaArn sets the AcmPcaArn field's value.
func (s *SourceData) SetAcmPcaArn(v string) *SourceData {
	s.AcmPcaArn = &v
	return s
}

// SetX509CertificateData sets the X509CertificateData field's value.
func (s *SourceData) SetX509CertificateData(v string) *SourceData {
	s.X509CertificateData = &v
	return s
}

// The state of the subject after a read or write operation.
type SubjectDetail struct {
	_ struct{} `type:"structure"`

	// The ISO-8601 timestamp when the subject was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The temporary session credentials vended at the last authenticating call
	// with this subject.
	Credentials []*CredentialSummary `locationName:"credentials" type:"list"`

	// The enabled status of the subject.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The specified instance properties associated with the request.
	InstanceProperties []*InstanceProperty `locationName:"instanceProperties" type:"list"`

	// The ISO-8601 timestamp of the last time this subject requested temporary
	// session credentials.
	LastSeenAt *time.Time `locationName:"lastSeenAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ARN of the resource.
	SubjectArn *string `locationName:"subjectArn" type:"string"`

	// The id of the resource
	SubjectId *string `locationName:"subjectId" min:"36" type:"string"`

	// The ISO-8601 timestamp when the subject was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The x509 principal identifier of the authenticating certificate.
	X509Subject *string `locationName:"x509Subject" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectDetail) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SubjectDetail) SetCreatedAt(v time.Time) *SubjectDetail {
	s.CreatedAt = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *SubjectDetail) SetCredentials(v []*CredentialSummary) *SubjectDetail {
	s.Credentials = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *SubjectDetail) SetEnabled(v bool) *SubjectDetail {
	s.Enabled = &v
	return s
}

// SetInstanceProperties sets the InstanceProperties field's value.
func (s *SubjectDetail) SetInstanceProperties(v []*InstanceProperty) *SubjectDetail {
	s.InstanceProperties = v
	return s
}

// SetLastSeenAt sets the LastSeenAt field's value.
func (s *SubjectDetail) SetLastSeenAt(v time.Time) *SubjectDetail {
	s.LastSeenAt = &v
	return s
}

// SetSubjectArn sets the SubjectArn field's value.
func (s *SubjectDetail) SetSubjectArn(v string) *SubjectDetail {
	s.SubjectArn = &v
	return s
}

// SetSubjectId sets the SubjectId field's value.
func (s *SubjectDetail) SetSubjectId(v string) *SubjectDetail {
	s.SubjectId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *SubjectDetail) SetUpdatedAt(v time.Time) *SubjectDetail {
	s.UpdatedAt = &v
	return s
}

// SetX509Subject sets the X509Subject field's value.
func (s *SubjectDetail) SetX509Subject(v string) *SubjectDetail {
	s.X509Subject = &v
	return s
}

// A summary representation of subjects.
type SubjectSummary struct {
	_ struct{} `type:"structure"`

	// The ISO-8601 time stamp of when the certificate was first used in a temporary
	// credential request.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The enabled status of the subject.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The ISO-8601 time stamp of when the certificate was last used in a temporary
	// credential request.
	LastSeenAt *time.Time `locationName:"lastSeenAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ARN of the resource.
	SubjectArn *string `locationName:"subjectArn" type:"string"`

	// The id of the resource.
	SubjectId *string `locationName:"subjectId" min:"36" type:"string"`

	// The ISO-8601 timestamp when the subject was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The x509 principal identifier of the authenticating certificate.
	X509Subject *string `locationName:"x509Subject" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubjectSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SubjectSummary) SetCreatedAt(v time.Time) *SubjectSummary {
	s.CreatedAt = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *SubjectSummary) SetEnabled(v bool) *SubjectSummary {
	s.Enabled = &v
	return s
}

// SetLastSeenAt sets the LastSeenAt field's value.
func (s *SubjectSummary) SetLastSeenAt(v time.Time) *SubjectSummary {
	s.LastSeenAt = &v
	return s
}

// SetSubjectArn sets the SubjectArn field's value.
func (s *SubjectSummary) SetSubjectArn(v string) *SubjectSummary {
	s.SubjectArn = &v
	return s
}

// SetSubjectId sets the SubjectId field's value.
func (s *SubjectSummary) SetSubjectId(v string) *SubjectSummary {
	s.SubjectId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *SubjectSummary) SetUpdatedAt(v time.Time) *SubjectSummary {
	s.UpdatedAt = &v
	return s
}

// SetX509Subject sets the X509Subject field's value.
func (s *SubjectSummary) SetX509Subject(v string) *SubjectSummary {
	s.X509Subject = &v
	return s
}

// A label that consists of a key and value you define.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true" sensitive:"true"`

	// The tag value.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tags to attach to the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Too many tags.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The state of the trust anchor after a read or write operation.
type TrustAnchorDetail struct {
	_ struct{} `type:"structure"`

	// The ISO-8601 timestamp when the trust anchor was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// Indicates whether the trust anchor is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The name of the trust anchor.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A list of notification settings to be associated to the trust anchor.
	NotificationSettings []*NotificationSettingDetail `locationName:"notificationSettings" type:"list"`

	// The trust anchor type and its related certificate data.
	Source *Source `locationName:"source" type:"structure"`

	// The ARN of the trust anchor.
	TrustAnchorArn *string `locationName:"trustAnchorArn" type:"string"`

	// The unique identifier of the trust anchor.
	TrustAnchorId *string `locationName:"trustAnchorId" min:"36" type:"string"`

	// The ISO-8601 timestamp when the trust anchor was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustAnchorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustAnchorDetail) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *TrustAnchorDetail) SetCreatedAt(v time.Time) *TrustAnchorDetail {
	s.CreatedAt = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *TrustAnchorDetail) SetEnabled(v bool) *TrustAnchorDetail {
	s.Enabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *TrustAnchorDetail) SetName(v string) *TrustAnchorDetail {
	s.Name = &v
	return s
}

// SetNotificationSettings sets the NotificationSettings field's value.
func (s *TrustAnchorDetail) SetNotificationSettings(v []*NotificationSettingDetail) *TrustAnchorDetail {
	s.NotificationSettings = v
	return s
}

// SetSource sets the Source field's value.
func (s *TrustAnchorDetail) SetSource(v *Source) *TrustAnchorDetail {
	s.Source = v
	return s
}

// SetTrustAnchorArn sets the TrustAnchorArn field's value.
func (s *TrustAnchorDetail) SetTrustAnchorArn(v string) *TrustAnchorDetail {
	s.TrustAnchorArn = &v
	return s
}

// SetTrustAnchorId sets the TrustAnchorId field's value.
func (s *TrustAnchorDetail) SetTrustAnchorId(v string) *TrustAnchorDetail {
	s.TrustAnchorId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *TrustAnchorDetail) SetUpdatedAt(v time.Time) *TrustAnchorDetail {
	s.UpdatedAt = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of keys. Tag keys are the unique identifiers of tags.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCrlInput struct {
	_ struct{} `type:"structure"`

	// The x509 v3 specified certificate revocation list (CRL).
	// CrlData is automatically base64 encoded/decoded by the SDK.
	CrlData []byte `locationName:"crlData" min:"1" type:"blob"`

	// The unique identifier of the certificate revocation list (CRL).
	//
	// CrlId is a required field
	CrlId *string `location:"uri" locationName:"crlId" min:"36" type:"string" required:"true"`

	// The name of the Crl.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCrlInput"}
	if s.CrlData != nil && len(s.CrlData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrlData", 1))
	}
	if s.CrlId == nil {
		invalidParams.Add(request.NewErrParamRequired("CrlId"))
	}
	if s.CrlId != nil && len(*s.CrlId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CrlId", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrlData sets the CrlData field's value.
func (s *UpdateCrlInput) SetCrlData(v []byte) *UpdateCrlInput {
	s.CrlData = v
	return s
}

// SetCrlId sets the CrlId field's value.
func (s *UpdateCrlInput) SetCrlId(v string) *UpdateCrlInput {
	s.CrlId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCrlInput) SetName(v string) *UpdateCrlInput {
	s.Name = &v
	return s
}

type UpdateCrlOutput struct {
	_ struct{} `type:"structure"`

	// The state of the certificate revocation list (CRL) after a read or write
	// operation.
	//
	// Crl is a required field
	Crl *CrlDetail `locationName:"crl" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCrlOutput) GoString() string {
	return s.String()
}

// SetCrl sets the Crl field's value.
func (s *UpdateCrlOutput) SetCrl(v *CrlDetail) *UpdateCrlOutput {
	s.Crl = v
	return s
}

type UpdateProfileInput struct {
	_ struct{} `type:"structure"`

	// Used to determine if a custom role session name will be accepted in a temporary
	// credential request.
	AcceptRoleSessionName *bool `locationName:"acceptRoleSessionName" type:"boolean"`

	// Used to determine how long sessions vended using this profile are valid for.
	// See the Expiration section of the CreateSession API documentation (https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object)
	// page for more details. In requests, if this value is not provided, the default
	// value will be 3600.
	DurationSeconds *int64 `locationName:"durationSeconds" min:"900" type:"integer"`

	// A list of managed policy ARNs that apply to the vended session credentials.
	ManagedPolicyArns []*string `locationName:"managedPolicyArns" type:"list"`

	// The name of the profile.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The unique identifier of the profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"profileId" min:"36" type:"string" required:"true"`

	// A list of IAM roles that this profile can assume in a temporary credential
	// request.
	RoleArns []*string `locationName:"roleArns" type:"list"`

	// A session policy that applies to the trust boundary of the vended session
	// credentials.
	SessionPolicy *string `locationName:"sessionPolicy" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProfileInput"}
	if s.DurationSeconds != nil && *s.DurationSeconds < 900 {
		invalidParams.Add(request.NewErrParamMinValue("DurationSeconds", 900))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 36))
	}
	if s.SessionPolicy != nil && len(*s.SessionPolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionPolicy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptRoleSessionName sets the AcceptRoleSessionName field's value.
func (s *UpdateProfileInput) SetAcceptRoleSessionName(v bool) *UpdateProfileInput {
	s.AcceptRoleSessionName = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *UpdateProfileInput) SetDurationSeconds(v int64) *UpdateProfileInput {
	s.DurationSeconds = &v
	return s
}

// SetManagedPolicyArns sets the ManagedPolicyArns field's value.
func (s *UpdateProfileInput) SetManagedPolicyArns(v []*string) *UpdateProfileInput {
	s.ManagedPolicyArns = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProfileInput) SetName(v string) *UpdateProfileInput {
	s.Name = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *UpdateProfileInput) SetProfileId(v string) *UpdateProfileInput {
	s.ProfileId = &v
	return s
}

// SetRoleArns sets the RoleArns field's value.
func (s *UpdateProfileInput) SetRoleArns(v []*string) *UpdateProfileInput {
	s.RoleArns = v
	return s
}

// SetSessionPolicy sets the SessionPolicy field's value.
func (s *UpdateProfileInput) SetSessionPolicy(v string) *UpdateProfileInput {
	s.SessionPolicy = &v
	return s
}

type UpdateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The state of the profile after a read or write operation.
	Profile *ProfileDetail `locationName:"profile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *UpdateProfileOutput) SetProfile(v *ProfileDetail) *UpdateProfileOutput {
	s.Profile = v
	return s
}

type UpdateTrustAnchorInput struct {
	_ struct{} `type:"structure"`

	// The name of the trust anchor.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The trust anchor type and its related certificate data.
	Source *Source `locationName:"source" type:"structure"`

	// The unique identifier of the trust anchor.
	//
	// TrustAnchorId is a required field
	TrustAnchorId *string `location:"uri" locationName:"trustAnchorId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrustAnchorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrustAnchorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrustAnchorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTrustAnchorInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TrustAnchorId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustAnchorId"))
	}
	if s.TrustAnchorId != nil && len(*s.TrustAnchorId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchorId", 36))
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateTrustAnchorInput) SetName(v string) *UpdateTrustAnchorInput {
	s.Name = &v
	return s
}

// SetSource sets the Source field's value.
func (s *UpdateTrustAnchorInput) SetSource(v *Source) *UpdateTrustAnchorInput {
	s.Source = v
	return s
}

// SetTrustAnchorId sets the TrustAnchorId field's value.
func (s *UpdateTrustAnchorInput) SetTrustAnchorId(v string) *UpdateTrustAnchorInput {
	s.TrustAnchorId = &v
	return s
}

type UpdateTrustAnchorOutput struct {
	_ struct{} `type:"structure"`

	// The state of the trust anchor after a read or write operation.
	//
	// TrustAnchor is a required field
	TrustAnchor *TrustAnchorDetail `locationName:"trustAnchor" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrustAnchorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrustAnchorOutput) GoString() string {
	return s.String()
}

// SetTrustAnchor sets the TrustAnchor field's value.
func (s *UpdateTrustAnchorOutput) SetTrustAnchor(v *TrustAnchorDetail) *UpdateTrustAnchorOutput {
	s.TrustAnchor = v
	return s
}

// Validation exception error.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// CertificateFieldX509subject is a CertificateField enum value
	CertificateFieldX509subject = "x509Subject"

	// CertificateFieldX509issuer is a CertificateField enum value
	CertificateFieldX509issuer = "x509Issuer"

	// CertificateFieldX509san is a CertificateField enum value
	CertificateFieldX509san = "x509SAN"
)

// CertificateField_Values returns all elements of the CertificateField enum
func CertificateField_Values() []string {
	return []string{
		CertificateFieldX509subject,
		CertificateFieldX509issuer,
		CertificateFieldX509san,
	}
}

const (
	// NotificationChannelAll is a NotificationChannel enum value
	NotificationChannelAll = "ALL"
)

// NotificationChannel_Values returns all elements of the NotificationChannel enum
func NotificationChannel_Values() []string {
	return []string{
		NotificationChannelAll,
	}
}

const (
	// NotificationEventCaCertificateExpiry is a NotificationEvent enum value
	NotificationEventCaCertificateExpiry = "CA_CERTIFICATE_EXPIRY"

	// NotificationEventEndEntityCertificateExpiry is a NotificationEvent enum value
	NotificationEventEndEntityCertificateExpiry = "END_ENTITY_CERTIFICATE_EXPIRY"
)

// NotificationEvent_Values returns all elements of the NotificationEvent enum
func NotificationEvent_Values() []string {
	return []string{
		NotificationEventCaCertificateExpiry,
		NotificationEventEndEntityCertificateExpiry,
	}
}

const (
	// TrustAnchorTypeAwsAcmPca is a TrustAnchorType enum value
	TrustAnchorTypeAwsAcmPca = "AWS_ACM_PCA"

	// TrustAnchorTypeCertificateBundle is a TrustAnchorType enum value
	TrustAnchorTypeCertificateBundle = "CERTIFICATE_BUNDLE"

	// TrustAnchorTypeSelfSignedRepository is a TrustAnchorType enum value
	TrustAnchorTypeSelfSignedRepository = "SELF_SIGNED_REPOSITORY"
)

// TrustAnchorType_Values returns all elements of the TrustAnchorType enum
func TrustAnchorType_Values() []string {
	return []string{
		TrustAnchorTypeAwsAcmPca,
		TrustAnchorTypeCertificateBundle,
		TrustAnchorTypeSelfSignedRepository,
	}
}
