// Code generated by go-swagger; DO NOT EDIT.

package pet

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPetUploadImageParams creates a new PetUploadImageParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPetUploadImageParams() *PetUploadImageParams {
	return &PetUploadImageParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPetUploadImageParamsWithTimeout creates a new PetUploadImageParams object
// with the ability to set a timeout on a request.
func NewPetUploadImageParamsWithTimeout(timeout time.Duration) *PetUploadImageParams {
	return &PetUploadImageParams{
		timeout: timeout,
	}
}

// NewPetUploadImageParamsWithContext creates a new PetUploadImageParams object
// with the ability to set a context for a request.
func NewPetUploadImageParamsWithContext(ctx context.Context) *PetUploadImageParams {
	return &PetUploadImageParams{
		Context: ctx,
	}
}

// NewPetUploadImageParamsWithHTTPClient creates a new PetUploadImageParams object
// with the ability to set a custom HTTPClient for a request.
func NewPetUploadImageParamsWithHTTPClient(client *http.Client) *PetUploadImageParams {
	return &PetUploadImageParams{
		HTTPClient: client,
	}
}

/*
PetUploadImageParams contains all the parameters to send to the API endpoint

	for the pet upload image operation.

	Typically these are written to a http.Request.
*/
type PetUploadImageParams struct {

	/* AdditionalMetadata.

	   Additional data to pass to server
	*/
	AdditionalMetadata *string

	/* File.

	   file to upload
	*/
	File runtime.NamedReadCloser

	/* PetID.

	   ID of pet to update

	   Format: int64
	*/
	PetID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the pet upload image params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PetUploadImageParams) WithDefaults() *PetUploadImageParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the pet upload image params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PetUploadImageParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the pet upload image params
func (o *PetUploadImageParams) WithTimeout(timeout time.Duration) *PetUploadImageParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the pet upload image params
func (o *PetUploadImageParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the pet upload image params
func (o *PetUploadImageParams) WithContext(ctx context.Context) *PetUploadImageParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the pet upload image params
func (o *PetUploadImageParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the pet upload image params
func (o *PetUploadImageParams) WithHTTPClient(client *http.Client) *PetUploadImageParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the pet upload image params
func (o *PetUploadImageParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAdditionalMetadata adds the additionalMetadata to the pet upload image params
func (o *PetUploadImageParams) WithAdditionalMetadata(additionalMetadata *string) *PetUploadImageParams {
	o.SetAdditionalMetadata(additionalMetadata)
	return o
}

// SetAdditionalMetadata adds the additionalMetadata to the pet upload image params
func (o *PetUploadImageParams) SetAdditionalMetadata(additionalMetadata *string) {
	o.AdditionalMetadata = additionalMetadata
}

// WithFile adds the file to the pet upload image params
func (o *PetUploadImageParams) WithFile(file runtime.NamedReadCloser) *PetUploadImageParams {
	o.SetFile(file)
	return o
}

// SetFile adds the file to the pet upload image params
func (o *PetUploadImageParams) SetFile(file runtime.NamedReadCloser) {
	o.File = file
}

// WithPetID adds the petID to the pet upload image params
func (o *PetUploadImageParams) WithPetID(petID int64) *PetUploadImageParams {
	o.SetPetID(petID)
	return o
}

// SetPetID adds the petId to the pet upload image params
func (o *PetUploadImageParams) SetPetID(petID int64) {
	o.PetID = petID
}

// WriteToRequest writes these params to a swagger request
func (o *PetUploadImageParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AdditionalMetadata != nil {

		// form param additionalMetadata
		var frAdditionalMetadata string
		if o.AdditionalMetadata != nil {
			frAdditionalMetadata = *o.AdditionalMetadata
		}
		fAdditionalMetadata := frAdditionalMetadata
		if fAdditionalMetadata != "" {
			if err := r.SetFormParam("additionalMetadata", fAdditionalMetadata); err != nil {
				return err
			}
		}
	}

	if o.File != nil {

		if o.File != nil {
			// form file param file
			if err := r.SetFileParam("file", o.File); err != nil {
				return err
			}
		}
	}

	// path param petId
	if err := r.SetPathParam("petId", swag.FormatInt64(o.PetID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
