package chaintypes

// Code generated by go-ipld-prime gengo.  DO NOT EDIT.

import (
	"github.com/ipld/go-ipld-prime/datamodel"
	"github.com/ipld/go-ipld-prime/node/mixins"
	"github.com/ipld/go-ipld-prime/schema"
)

func (n _Block) FieldParents() Parents {
	return &n.Parents
}
func (n _Block) FieldMessages() Messages {
	return &n.Messages
}

type _Block__Maybe struct {
	m schema.Maybe
	v Block
}
type MaybeBlock = *_Block__Maybe

func (m MaybeBlock) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeBlock) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeBlock) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeBlock) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeBlock) Must() Block {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__Block_Parents  = _String{"Parents"}
	fieldName__Block_Messages = _String{"Messages"}
)
var _ datamodel.Node = (Block)(&_Block{})
var _ schema.TypedNode = (Block)(&_Block{})

func (Block) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n Block) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "Parents":
		return &n.Parents, nil
	case "Messages":
		return &n.Messages, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n Block) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (Block) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "chaintypes.Block"}.LookupByIndex(0)
}
func (n Block) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n Block) MapIterator() datamodel.MapIterator {
	return &_Block__MapItr{n, 0}
}

type _Block__MapItr struct {
	n   Block
	idx int
}

func (itr *_Block__MapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
	if itr.idx >= 2 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__Block_Parents
		v = &itr.n.Parents
	case 1:
		k = &fieldName__Block_Messages
		v = &itr.n.Messages
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_Block__MapItr) Done() bool {
	return itr.idx >= 2
}

func (Block) ListIterator() datamodel.ListIterator {
	return nil
}
func (Block) Length() int64 {
	return 2
}
func (Block) IsAbsent() bool {
	return false
}
func (Block) IsNull() bool {
	return false
}
func (Block) AsBool() (bool, error) {
	return mixins.Map{TypeName: "chaintypes.Block"}.AsBool()
}
func (Block) AsInt() (int64, error) {
	return mixins.Map{TypeName: "chaintypes.Block"}.AsInt()
}
func (Block) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "chaintypes.Block"}.AsFloat()
}
func (Block) AsString() (string, error) {
	return mixins.Map{TypeName: "chaintypes.Block"}.AsString()
}
func (Block) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "chaintypes.Block"}.AsBytes()
}
func (Block) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "chaintypes.Block"}.AsLink()
}
func (Block) Prototype() datamodel.NodePrototype {
	return _Block__Prototype{}
}

type _Block__Prototype struct{}

func (_Block__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Block__Builder
	nb.Reset()
	return &nb
}

type _Block__Builder struct {
	_Block__Assembler
}

func (nb *_Block__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Block__Builder) Reset() {
	var w _Block
	var m schema.Maybe
	*nb = _Block__Builder{_Block__Assembler{w: &w, m: &m}}
}

type _Block__Assembler struct {
	w     *_Block
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm          schema.Maybe
	ca_Parents  _Parents__Assembler
	ca_Messages _Messages__Assembler
}

func (na *_Block__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_Parents.reset()
	na.ca_Messages.reset()
}

var (
	fieldBit__Block_Parents     = 1 << 0
	fieldBit__Block_Messages    = 1 << 1
	fieldBits__Block_sufficient = 0 + 1<<0 + 1<<1
)

func (na *_Block__Assembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_Block{}
	}
	return na, nil
}
func (_Block__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "chaintypes.Block"}.BeginList(0)
}
func (na *_Block__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "chaintypes.Block"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Block__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "chaintypes.Block"}.AssignBool(false)
}
func (_Block__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "chaintypes.Block"}.AssignInt(0)
}
func (_Block__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "chaintypes.Block"}.AssignFloat(0)
}
func (_Block__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "chaintypes.Block"}.AssignString("")
}
func (_Block__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "chaintypes.Block"}.AssignBytes(nil)
}
func (_Block__Assembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "chaintypes.Block"}.AssignLink(nil)
}
func (na *_Block__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Block); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "chaintypes.Block", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Block__Assembler) Prototype() datamodel.NodePrototype {
	return _Block__Prototype{}
}
func (ma *_Block__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_Parents.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_Messages.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_Block__Assembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "Parents":
		if ma.s&fieldBit__Block_Parents != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__Block_Parents}
		}
		ma.s += fieldBit__Block_Parents
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_Parents.w = &ma.w.Parents
		ma.ca_Parents.m = &ma.cm
		return &ma.ca_Parents, nil
	case "Messages":
		if ma.s&fieldBit__Block_Messages != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__Block_Messages}
		}
		ma.s += fieldBit__Block_Messages
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_Messages.w = &ma.w.Messages
		ma.ca_Messages.m = &ma.cm
		return &ma.ca_Messages, nil
	}
	return nil, schema.ErrInvalidKey{TypeName: "chaintypes.Block", Key: &_String{k}}
}
func (ma *_Block__Assembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_Block__KeyAssembler)(ma)
}
func (ma *_Block__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_Parents.w = &ma.w.Parents
		ma.ca_Parents.m = &ma.cm
		return &ma.ca_Parents
	case 1:
		ma.ca_Messages.w = &ma.w.Messages
		ma.ca_Messages.m = &ma.cm
		return &ma.ca_Messages
	default:
		panic("unreachable")
	}
}
func (ma *_Block__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__Block_sufficient != fieldBits__Block_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__Block_Parents == 0 {
			err.Missing = append(err.Missing, "Parents")
		}
		if ma.s&fieldBit__Block_Messages == 0 {
			err.Missing = append(err.Missing, "Messages")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_Block__Assembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_Block__Assembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _Block__KeyAssembler _Block__Assembler

func (_Block__KeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.KeyAssembler"}.BeginMap(0)
}
func (_Block__KeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.KeyAssembler"}.BeginList(0)
}
func (na *_Block__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.KeyAssembler"}.AssignNull()
}
func (_Block__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.KeyAssembler"}.AssignBool(false)
}
func (_Block__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.KeyAssembler"}.AssignInt(0)
}
func (_Block__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.KeyAssembler"}.AssignFloat(0)
}
func (ka *_Block__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "Parents":
		if ka.s&fieldBit__Block_Parents != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__Block_Parents}
		}
		ka.s += fieldBit__Block_Parents
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "Messages":
		if ka.s&fieldBit__Block_Messages != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__Block_Messages}
		}
		ka.s += fieldBit__Block_Messages
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	default:
		return schema.ErrInvalidKey{TypeName: "chaintypes.Block", Key: &_String{k}}
	}
}
func (_Block__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.KeyAssembler"}.AssignBytes(nil)
}
func (_Block__KeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.KeyAssembler"}.AssignLink(nil)
}
func (ka *_Block__KeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_Block__KeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (Block) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Block) Representation() datamodel.Node {
	return (*_Block__Repr)(n)
}

type _Block__Repr _Block

var (
	fieldName__Block_Parents_serial  = _String{"Parents"}
	fieldName__Block_Messages_serial = _String{"Messages"}
)
var _ datamodel.Node = &_Block__Repr{}

func (_Block__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n *_Block__Repr) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "Parents":
		return n.Parents.Representation(), nil
	case "Messages":
		return n.Messages.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n *_Block__Repr) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_Block__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "chaintypes.Block.Repr"}.LookupByIndex(0)
}
func (n _Block__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_Block__Repr) MapIterator() datamodel.MapIterator {
	return &_Block__ReprMapItr{n, 0}
}

type _Block__ReprMapItr struct {
	n   *_Block__Repr
	idx int
}

func (itr *_Block__ReprMapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
	if itr.idx >= 2 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__Block_Parents_serial
		v = itr.n.Parents.Representation()
	case 1:
		k = &fieldName__Block_Messages_serial
		v = itr.n.Messages.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_Block__ReprMapItr) Done() bool {
	return itr.idx >= 2
}
func (_Block__Repr) ListIterator() datamodel.ListIterator {
	return nil
}
func (rn *_Block__Repr) Length() int64 {
	l := 2
	return int64(l)
}
func (_Block__Repr) IsAbsent() bool {
	return false
}
func (_Block__Repr) IsNull() bool {
	return false
}
func (_Block__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "chaintypes.Block.Repr"}.AsBool()
}
func (_Block__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "chaintypes.Block.Repr"}.AsInt()
}
func (_Block__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "chaintypes.Block.Repr"}.AsFloat()
}
func (_Block__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "chaintypes.Block.Repr"}.AsString()
}
func (_Block__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "chaintypes.Block.Repr"}.AsBytes()
}
func (_Block__Repr) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "chaintypes.Block.Repr"}.AsLink()
}
func (_Block__Repr) Prototype() datamodel.NodePrototype {
	return _Block__ReprPrototype{}
}

type _Block__ReprPrototype struct{}

func (_Block__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Block__ReprBuilder
	nb.Reset()
	return &nb
}

type _Block__ReprBuilder struct {
	_Block__ReprAssembler
}

func (nb *_Block__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Block__ReprBuilder) Reset() {
	var w _Block
	var m schema.Maybe
	*nb = _Block__ReprBuilder{_Block__ReprAssembler{w: &w, m: &m}}
}

type _Block__ReprAssembler struct {
	w     *_Block
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm          schema.Maybe
	ca_Parents  _Parents__ReprAssembler
	ca_Messages _Messages__ReprAssembler
}

func (na *_Block__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_Parents.reset()
	na.ca_Messages.reset()
}
func (na *_Block__ReprAssembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_Block{}
	}
	return na, nil
}
func (_Block__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "chaintypes.Block.Repr"}.BeginList(0)
}
func (na *_Block__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "chaintypes.Block.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Block__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "chaintypes.Block.Repr"}.AssignBool(false)
}
func (_Block__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "chaintypes.Block.Repr"}.AssignInt(0)
}
func (_Block__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "chaintypes.Block.Repr"}.AssignFloat(0)
}
func (_Block__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "chaintypes.Block.Repr"}.AssignString("")
}
func (_Block__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "chaintypes.Block.Repr"}.AssignBytes(nil)
}
func (_Block__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "chaintypes.Block.Repr"}.AssignLink(nil)
}
func (na *_Block__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Block); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "chaintypes.Block.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Block__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _Block__ReprPrototype{}
}
func (ma *_Block__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_Block__ReprAssembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "Parents":
		if ma.s&fieldBit__Block_Parents != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__Block_Parents_serial}
		}
		ma.s += fieldBit__Block_Parents
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_Parents.w = &ma.w.Parents
		ma.ca_Parents.m = &ma.cm
		return &ma.ca_Parents, nil
	case "Messages":
		if ma.s&fieldBit__Block_Messages != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__Block_Messages_serial}
		}
		ma.s += fieldBit__Block_Messages
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_Messages.w = &ma.w.Messages
		ma.ca_Messages.m = &ma.cm
		return &ma.ca_Messages, nil
	default:
	}
	return nil, schema.ErrInvalidKey{TypeName: "chaintypes.Block.Repr", Key: &_String{k}}
}
func (ma *_Block__ReprAssembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_Block__ReprKeyAssembler)(ma)
}
func (ma *_Block__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_Parents.w = &ma.w.Parents
		ma.ca_Parents.m = &ma.cm
		return &ma.ca_Parents
	case 1:
		ma.ca_Messages.w = &ma.w.Messages
		ma.ca_Messages.m = &ma.cm
		return &ma.ca_Messages
	default:
		panic("unreachable")
	}
}
func (ma *_Block__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__Block_sufficient != fieldBits__Block_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__Block_Parents == 0 {
			err.Missing = append(err.Missing, "Parents")
		}
		if ma.s&fieldBit__Block_Messages == 0 {
			err.Missing = append(err.Missing, "Messages")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_Block__ReprAssembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_Block__ReprAssembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _Block__ReprKeyAssembler _Block__ReprAssembler

func (_Block__ReprKeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.Repr.KeyAssembler"}.BeginMap(0)
}
func (_Block__ReprKeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_Block__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.Repr.KeyAssembler"}.AssignNull()
}
func (_Block__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.Repr.KeyAssembler"}.AssignBool(false)
}
func (_Block__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.Repr.KeyAssembler"}.AssignInt(0)
}
func (_Block__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_Block__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "Parents":
		if ka.s&fieldBit__Block_Parents != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__Block_Parents_serial}
		}
		ka.s += fieldBit__Block_Parents
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "Messages":
		if ka.s&fieldBit__Block_Messages != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__Block_Messages_serial}
		}
		ka.s += fieldBit__Block_Messages
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	}
	return schema.ErrInvalidKey{TypeName: "chaintypes.Block.Repr", Key: &_String{k}}
}
func (_Block__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_Block__ReprKeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "chaintypes.Block.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_Block__ReprKeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_Block__ReprKeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}

func (n Bytes) Bytes() []byte {
	return n.x
}
func (_Bytes__Prototype) FromBytes(v []byte) (Bytes, error) {
	n := _Bytes{v}
	return &n, nil
}

type _Bytes__Maybe struct {
	m schema.Maybe
	v _Bytes
}
type MaybeBytes = *_Bytes__Maybe

func (m MaybeBytes) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeBytes) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeBytes) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeBytes) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeBytes) Must() Bytes {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (Bytes)(&_Bytes{})
var _ schema.TypedNode = (Bytes)(&_Bytes{})

func (Bytes) Kind() datamodel.Kind {
	return datamodel.Kind_Bytes
}
func (Bytes) LookupByString(string) (datamodel.Node, error) {
	return mixins.Bytes{TypeName: "chaintypes.Bytes"}.LookupByString("")
}
func (Bytes) LookupByNode(datamodel.Node) (datamodel.Node, error) {
	return mixins.Bytes{TypeName: "chaintypes.Bytes"}.LookupByNode(nil)
}
func (Bytes) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Bytes{TypeName: "chaintypes.Bytes"}.LookupByIndex(0)
}
func (Bytes) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return mixins.Bytes{TypeName: "chaintypes.Bytes"}.LookupBySegment(seg)
}
func (Bytes) MapIterator() datamodel.MapIterator {
	return nil
}
func (Bytes) ListIterator() datamodel.ListIterator {
	return nil
}
func (Bytes) Length() int64 {
	return -1
}
func (Bytes) IsAbsent() bool {
	return false
}
func (Bytes) IsNull() bool {
	return false
}
func (Bytes) AsBool() (bool, error) {
	return mixins.Bytes{TypeName: "chaintypes.Bytes"}.AsBool()
}
func (Bytes) AsInt() (int64, error) {
	return mixins.Bytes{TypeName: "chaintypes.Bytes"}.AsInt()
}
func (Bytes) AsFloat() (float64, error) {
	return mixins.Bytes{TypeName: "chaintypes.Bytes"}.AsFloat()
}
func (Bytes) AsString() (string, error) {
	return mixins.Bytes{TypeName: "chaintypes.Bytes"}.AsString()
}
func (n Bytes) AsBytes() ([]byte, error) {
	return n.x, nil
}
func (Bytes) AsLink() (datamodel.Link, error) {
	return mixins.Bytes{TypeName: "chaintypes.Bytes"}.AsLink()
}
func (Bytes) Prototype() datamodel.NodePrototype {
	return _Bytes__Prototype{}
}

type _Bytes__Prototype struct{}

func (_Bytes__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Bytes__Builder
	nb.Reset()
	return &nb
}

type _Bytes__Builder struct {
	_Bytes__Assembler
}

func (nb *_Bytes__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Bytes__Builder) Reset() {
	var w _Bytes
	var m schema.Maybe
	*nb = _Bytes__Builder{_Bytes__Assembler{w: &w, m: &m}}
}

type _Bytes__Assembler struct {
	w *_Bytes
	m *schema.Maybe
}

func (na *_Bytes__Assembler) reset() {}
func (_Bytes__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.BytesAssembler{TypeName: "chaintypes.Bytes"}.BeginMap(0)
}
func (_Bytes__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.BytesAssembler{TypeName: "chaintypes.Bytes"}.BeginList(0)
}
func (na *_Bytes__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.BytesAssembler{TypeName: "chaintypes.Bytes"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Bytes__Assembler) AssignBool(bool) error {
	return mixins.BytesAssembler{TypeName: "chaintypes.Bytes"}.AssignBool(false)
}
func (_Bytes__Assembler) AssignInt(int64) error {
	return mixins.BytesAssembler{TypeName: "chaintypes.Bytes"}.AssignInt(0)
}
func (_Bytes__Assembler) AssignFloat(float64) error {
	return mixins.BytesAssembler{TypeName: "chaintypes.Bytes"}.AssignFloat(0)
}
func (_Bytes__Assembler) AssignString(string) error {
	return mixins.BytesAssembler{TypeName: "chaintypes.Bytes"}.AssignString("")
}
func (na *_Bytes__Assembler) AssignBytes(v []byte) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_Bytes__Assembler) AssignLink(datamodel.Link) error {
	return mixins.BytesAssembler{TypeName: "chaintypes.Bytes"}.AssignLink(nil)
}
func (na *_Bytes__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Bytes); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsBytes(); err != nil {
		return err
	} else {
		return na.AssignBytes(v2)
	}
}
func (_Bytes__Assembler) Prototype() datamodel.NodePrototype {
	return _Bytes__Prototype{}
}
func (Bytes) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Bytes) Representation() datamodel.Node {
	return (*_Bytes__Repr)(n)
}

type _Bytes__Repr = _Bytes

var _ datamodel.Node = &_Bytes__Repr{}

type _Bytes__ReprPrototype = _Bytes__Prototype
type _Bytes__ReprAssembler = _Bytes__Assembler

func (n Link) Link() datamodel.Link {
	return n.x
}
func (_Link__Prototype) FromLink(v datamodel.Link) (Link, error) {
	n := _Link{v}
	return &n, nil
}

type _Link__Maybe struct {
	m schema.Maybe
	v _Link
}
type MaybeLink = *_Link__Maybe

func (m MaybeLink) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeLink) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeLink) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeLink) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeLink) Must() Link {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (Link)(&_Link{})
var _ schema.TypedNode = (Link)(&_Link{})

func (Link) Kind() datamodel.Kind {
	return datamodel.Kind_Link
}
func (Link) LookupByString(string) (datamodel.Node, error) {
	return mixins.Link{TypeName: "chaintypes.Link"}.LookupByString("")
}
func (Link) LookupByNode(datamodel.Node) (datamodel.Node, error) {
	return mixins.Link{TypeName: "chaintypes.Link"}.LookupByNode(nil)
}
func (Link) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Link{TypeName: "chaintypes.Link"}.LookupByIndex(0)
}
func (Link) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return mixins.Link{TypeName: "chaintypes.Link"}.LookupBySegment(seg)
}
func (Link) MapIterator() datamodel.MapIterator {
	return nil
}
func (Link) ListIterator() datamodel.ListIterator {
	return nil
}
func (Link) Length() int64 {
	return -1
}
func (Link) IsAbsent() bool {
	return false
}
func (Link) IsNull() bool {
	return false
}
func (Link) AsBool() (bool, error) {
	return mixins.Link{TypeName: "chaintypes.Link"}.AsBool()
}
func (Link) AsInt() (int64, error) {
	return mixins.Link{TypeName: "chaintypes.Link"}.AsInt()
}
func (Link) AsFloat() (float64, error) {
	return mixins.Link{TypeName: "chaintypes.Link"}.AsFloat()
}
func (Link) AsString() (string, error) {
	return mixins.Link{TypeName: "chaintypes.Link"}.AsString()
}
func (Link) AsBytes() ([]byte, error) {
	return mixins.Link{TypeName: "chaintypes.Link"}.AsBytes()
}
func (n Link) AsLink() (datamodel.Link, error) {
	return n.x, nil
}
func (Link) Prototype() datamodel.NodePrototype {
	return _Link__Prototype{}
}

type _Link__Prototype struct{}

func (_Link__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Link__Builder
	nb.Reset()
	return &nb
}

type _Link__Builder struct {
	_Link__Assembler
}

func (nb *_Link__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Link__Builder) Reset() {
	var w _Link
	var m schema.Maybe
	*nb = _Link__Builder{_Link__Assembler{w: &w, m: &m}}
}

type _Link__Assembler struct {
	w *_Link
	m *schema.Maybe
}

func (na *_Link__Assembler) reset() {}
func (_Link__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.LinkAssembler{TypeName: "chaintypes.Link"}.BeginMap(0)
}
func (_Link__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.LinkAssembler{TypeName: "chaintypes.Link"}.BeginList(0)
}
func (na *_Link__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.LinkAssembler{TypeName: "chaintypes.Link"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Link__Assembler) AssignBool(bool) error {
	return mixins.LinkAssembler{TypeName: "chaintypes.Link"}.AssignBool(false)
}
func (_Link__Assembler) AssignInt(int64) error {
	return mixins.LinkAssembler{TypeName: "chaintypes.Link"}.AssignInt(0)
}
func (_Link__Assembler) AssignFloat(float64) error {
	return mixins.LinkAssembler{TypeName: "chaintypes.Link"}.AssignFloat(0)
}
func (_Link__Assembler) AssignString(string) error {
	return mixins.LinkAssembler{TypeName: "chaintypes.Link"}.AssignString("")
}
func (_Link__Assembler) AssignBytes([]byte) error {
	return mixins.LinkAssembler{TypeName: "chaintypes.Link"}.AssignBytes(nil)
}
func (na *_Link__Assembler) AssignLink(v datamodel.Link) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (na *_Link__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Link); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsLink(); err != nil {
		return err
	} else {
		return na.AssignLink(v2)
	}
}
func (_Link__Assembler) Prototype() datamodel.NodePrototype {
	return _Link__Prototype{}
}
func (Link) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Link) Representation() datamodel.Node {
	return (*_Link__Repr)(n)
}

type _Link__Repr = _Link

var _ datamodel.Node = &_Link__Repr{}

type _Link__ReprPrototype = _Link__Prototype
type _Link__ReprAssembler = _Link__Assembler

func (n *_Messages) Lookup(idx int64) Bytes {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return v
}
func (n *_Messages) LookupMaybe(idx int64) MaybeBytes {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return &_Bytes__Maybe{
		m: schema.Maybe_Value,
		v: *v,
	}
}

var _Messages__valueAbsent = _Bytes__Maybe{m: schema.Maybe_Absent}

func (n Messages) Iterator() *Messages__Itr {
	return &Messages__Itr{n, 0}
}

type Messages__Itr struct {
	n   Messages
	idx int
}

func (itr *Messages__Itr) Next() (idx int64, v Bytes) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil
	}
	idx = int64(itr.idx)
	v = &itr.n.x[itr.idx]
	itr.idx++
	return
}
func (itr *Messages__Itr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

type _Messages__Maybe struct {
	m schema.Maybe
	v _Messages
}
type MaybeMessages = *_Messages__Maybe

func (m MaybeMessages) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeMessages) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeMessages) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeMessages) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeMessages) Must() Messages {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (Messages)(&_Messages{})
var _ schema.TypedNode = (Messages)(&_Messages{})

func (Messages) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (Messages) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "chaintypes.Messages"}.LookupByString("")
}
func (n Messages) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	idx, err := k.AsInt()
	if err != nil {
		return nil, err
	}
	return n.LookupByIndex(idx)
}
func (n Messages) LookupByIndex(idx int64) (datamodel.Node, error) {
	if n.Length() <= idx {
		return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfInt(idx)}
	}
	v := &n.x[idx]
	return v, nil
}
func (n Messages) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "chaintypes.Messages", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (Messages) MapIterator() datamodel.MapIterator {
	return nil
}
func (n Messages) ListIterator() datamodel.ListIterator {
	return &_Messages__ListItr{n, 0}
}

type _Messages__ListItr struct {
	n   Messages
	idx int
}

func (itr *_Messages__ListItr) Next() (idx int64, v datamodel.Node, _ error) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil, datamodel.ErrIteratorOverread{}
	}
	idx = int64(itr.idx)
	x := &itr.n.x[itr.idx]
	v = x
	itr.idx++
	return
}
func (itr *_Messages__ListItr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

func (n Messages) Length() int64 {
	return int64(len(n.x))
}
func (Messages) IsAbsent() bool {
	return false
}
func (Messages) IsNull() bool {
	return false
}
func (Messages) AsBool() (bool, error) {
	return mixins.List{TypeName: "chaintypes.Messages"}.AsBool()
}
func (Messages) AsInt() (int64, error) {
	return mixins.List{TypeName: "chaintypes.Messages"}.AsInt()
}
func (Messages) AsFloat() (float64, error) {
	return mixins.List{TypeName: "chaintypes.Messages"}.AsFloat()
}
func (Messages) AsString() (string, error) {
	return mixins.List{TypeName: "chaintypes.Messages"}.AsString()
}
func (Messages) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "chaintypes.Messages"}.AsBytes()
}
func (Messages) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "chaintypes.Messages"}.AsLink()
}
func (Messages) Prototype() datamodel.NodePrototype {
	return _Messages__Prototype{}
}

type _Messages__Prototype struct{}

func (_Messages__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Messages__Builder
	nb.Reset()
	return &nb
}

type _Messages__Builder struct {
	_Messages__Assembler
}

func (nb *_Messages__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Messages__Builder) Reset() {
	var w _Messages
	var m schema.Maybe
	*nb = _Messages__Builder{_Messages__Assembler{w: &w, m: &m}}
}

type _Messages__Assembler struct {
	w     *_Messages
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _Bytes__Assembler
}

func (na *_Messages__Assembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_Messages__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages"}.BeginMap(0)
}
func (na *_Messages__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_Bytes, 0, sizeHint)
	}
	return na, nil
}
func (na *_Messages__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "chaintypes.Messages"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Messages__Assembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages"}.AssignBool(false)
}
func (_Messages__Assembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages"}.AssignInt(0)
}
func (_Messages__Assembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages"}.AssignFloat(0)
}
func (_Messages__Assembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages"}.AssignString("")
}
func (_Messages__Assembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages"}.AssignBytes(nil)
}
func (_Messages__Assembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages"}.AssignLink(nil)
}
func (na *_Messages__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Messages); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "chaintypes.Messages", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Messages__Assembler) Prototype() datamodel.NodePrototype {
	return _Messages__Prototype{}
}
func (la *_Messages__Assembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_Messages__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _Bytes{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_Messages__Assembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_Messages__Assembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _Bytes__Prototype{}
}
func (Messages) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Messages) Representation() datamodel.Node {
	return (*_Messages__Repr)(n)
}

type _Messages__Repr _Messages

var _ datamodel.Node = &_Messages__Repr{}

func (_Messages__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (_Messages__Repr) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "chaintypes.Messages.Repr"}.LookupByString("")
}
func (nr *_Messages__Repr) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	v, err := (Messages)(nr).LookupByNode(k)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(Bytes).Representation(), nil
}
func (nr *_Messages__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	v, err := (Messages)(nr).LookupByIndex(idx)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(Bytes).Representation(), nil
}
func (n _Messages__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "chaintypes.Messages.Repr", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (_Messages__Repr) MapIterator() datamodel.MapIterator {
	return nil
}
func (nr *_Messages__Repr) ListIterator() datamodel.ListIterator {
	return &_Messages__ReprListItr{(Messages)(nr), 0}
}

type _Messages__ReprListItr _Messages__ListItr

func (itr *_Messages__ReprListItr) Next() (idx int64, v datamodel.Node, err error) {
	idx, v, err = (*_Messages__ListItr)(itr).Next()
	if err != nil || v == datamodel.Null {
		return
	}
	return idx, v.(Bytes).Representation(), nil
}
func (itr *_Messages__ReprListItr) Done() bool {
	return (*_Messages__ListItr)(itr).Done()
}

func (rn *_Messages__Repr) Length() int64 {
	return int64(len(rn.x))
}
func (_Messages__Repr) IsAbsent() bool {
	return false
}
func (_Messages__Repr) IsNull() bool {
	return false
}
func (_Messages__Repr) AsBool() (bool, error) {
	return mixins.List{TypeName: "chaintypes.Messages.Repr"}.AsBool()
}
func (_Messages__Repr) AsInt() (int64, error) {
	return mixins.List{TypeName: "chaintypes.Messages.Repr"}.AsInt()
}
func (_Messages__Repr) AsFloat() (float64, error) {
	return mixins.List{TypeName: "chaintypes.Messages.Repr"}.AsFloat()
}
func (_Messages__Repr) AsString() (string, error) {
	return mixins.List{TypeName: "chaintypes.Messages.Repr"}.AsString()
}
func (_Messages__Repr) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "chaintypes.Messages.Repr"}.AsBytes()
}
func (_Messages__Repr) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "chaintypes.Messages.Repr"}.AsLink()
}
func (_Messages__Repr) Prototype() datamodel.NodePrototype {
	return _Messages__ReprPrototype{}
}

type _Messages__ReprPrototype struct{}

func (_Messages__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Messages__ReprBuilder
	nb.Reset()
	return &nb
}

type _Messages__ReprBuilder struct {
	_Messages__ReprAssembler
}

func (nb *_Messages__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Messages__ReprBuilder) Reset() {
	var w _Messages
	var m schema.Maybe
	*nb = _Messages__ReprBuilder{_Messages__ReprAssembler{w: &w, m: &m}}
}

type _Messages__ReprAssembler struct {
	w     *_Messages
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _Bytes__ReprAssembler
}

func (na *_Messages__ReprAssembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_Messages__ReprAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages.Repr"}.BeginMap(0)
}
func (na *_Messages__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_Bytes, 0, sizeHint)
	}
	return na, nil
}
func (na *_Messages__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "chaintypes.Messages.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Messages__ReprAssembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages.Repr"}.AssignBool(false)
}
func (_Messages__ReprAssembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages.Repr"}.AssignInt(0)
}
func (_Messages__ReprAssembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages.Repr"}.AssignFloat(0)
}
func (_Messages__ReprAssembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages.Repr"}.AssignString("")
}
func (_Messages__ReprAssembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages.Repr"}.AssignBytes(nil)
}
func (_Messages__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Messages.Repr"}.AssignLink(nil)
}
func (na *_Messages__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Messages); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "chaintypes.Messages.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Messages__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _Messages__ReprPrototype{}
}
func (la *_Messages__ReprAssembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_Messages__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _Bytes{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_Messages__ReprAssembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_Messages__ReprAssembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _Bytes__ReprPrototype{}
}

func (n *_Parents) Lookup(idx int64) Link {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return v
}
func (n *_Parents) LookupMaybe(idx int64) MaybeLink {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return &_Link__Maybe{
		m: schema.Maybe_Value,
		v: *v,
	}
}

var _Parents__valueAbsent = _Link__Maybe{m: schema.Maybe_Absent}

func (n Parents) Iterator() *Parents__Itr {
	return &Parents__Itr{n, 0}
}

type Parents__Itr struct {
	n   Parents
	idx int
}

func (itr *Parents__Itr) Next() (idx int64, v Link) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil
	}
	idx = int64(itr.idx)
	v = &itr.n.x[itr.idx]
	itr.idx++
	return
}
func (itr *Parents__Itr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

type _Parents__Maybe struct {
	m schema.Maybe
	v _Parents
}
type MaybeParents = *_Parents__Maybe

func (m MaybeParents) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeParents) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeParents) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeParents) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeParents) Must() Parents {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (Parents)(&_Parents{})
var _ schema.TypedNode = (Parents)(&_Parents{})

func (Parents) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (Parents) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "chaintypes.Parents"}.LookupByString("")
}
func (n Parents) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	idx, err := k.AsInt()
	if err != nil {
		return nil, err
	}
	return n.LookupByIndex(idx)
}
func (n Parents) LookupByIndex(idx int64) (datamodel.Node, error) {
	if n.Length() <= idx {
		return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfInt(idx)}
	}
	v := &n.x[idx]
	return v, nil
}
func (n Parents) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "chaintypes.Parents", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (Parents) MapIterator() datamodel.MapIterator {
	return nil
}
func (n Parents) ListIterator() datamodel.ListIterator {
	return &_Parents__ListItr{n, 0}
}

type _Parents__ListItr struct {
	n   Parents
	idx int
}

func (itr *_Parents__ListItr) Next() (idx int64, v datamodel.Node, _ error) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil, datamodel.ErrIteratorOverread{}
	}
	idx = int64(itr.idx)
	x := &itr.n.x[itr.idx]
	v = x
	itr.idx++
	return
}
func (itr *_Parents__ListItr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

func (n Parents) Length() int64 {
	return int64(len(n.x))
}
func (Parents) IsAbsent() bool {
	return false
}
func (Parents) IsNull() bool {
	return false
}
func (Parents) AsBool() (bool, error) {
	return mixins.List{TypeName: "chaintypes.Parents"}.AsBool()
}
func (Parents) AsInt() (int64, error) {
	return mixins.List{TypeName: "chaintypes.Parents"}.AsInt()
}
func (Parents) AsFloat() (float64, error) {
	return mixins.List{TypeName: "chaintypes.Parents"}.AsFloat()
}
func (Parents) AsString() (string, error) {
	return mixins.List{TypeName: "chaintypes.Parents"}.AsString()
}
func (Parents) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "chaintypes.Parents"}.AsBytes()
}
func (Parents) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "chaintypes.Parents"}.AsLink()
}
func (Parents) Prototype() datamodel.NodePrototype {
	return _Parents__Prototype{}
}

type _Parents__Prototype struct{}

func (_Parents__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Parents__Builder
	nb.Reset()
	return &nb
}

type _Parents__Builder struct {
	_Parents__Assembler
}

func (nb *_Parents__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Parents__Builder) Reset() {
	var w _Parents
	var m schema.Maybe
	*nb = _Parents__Builder{_Parents__Assembler{w: &w, m: &m}}
}

type _Parents__Assembler struct {
	w     *_Parents
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _Link__Assembler
}

func (na *_Parents__Assembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_Parents__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents"}.BeginMap(0)
}
func (na *_Parents__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_Link, 0, sizeHint)
	}
	return na, nil
}
func (na *_Parents__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "chaintypes.Parents"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Parents__Assembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents"}.AssignBool(false)
}
func (_Parents__Assembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents"}.AssignInt(0)
}
func (_Parents__Assembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents"}.AssignFloat(0)
}
func (_Parents__Assembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents"}.AssignString("")
}
func (_Parents__Assembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents"}.AssignBytes(nil)
}
func (_Parents__Assembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents"}.AssignLink(nil)
}
func (na *_Parents__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Parents); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "chaintypes.Parents", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Parents__Assembler) Prototype() datamodel.NodePrototype {
	return _Parents__Prototype{}
}
func (la *_Parents__Assembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_Parents__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _Link{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_Parents__Assembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_Parents__Assembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _Link__Prototype{}
}
func (Parents) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Parents) Representation() datamodel.Node {
	return (*_Parents__Repr)(n)
}

type _Parents__Repr _Parents

var _ datamodel.Node = &_Parents__Repr{}

func (_Parents__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (_Parents__Repr) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "chaintypes.Parents.Repr"}.LookupByString("")
}
func (nr *_Parents__Repr) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	v, err := (Parents)(nr).LookupByNode(k)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(Link).Representation(), nil
}
func (nr *_Parents__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	v, err := (Parents)(nr).LookupByIndex(idx)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(Link).Representation(), nil
}
func (n _Parents__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "chaintypes.Parents.Repr", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (_Parents__Repr) MapIterator() datamodel.MapIterator {
	return nil
}
func (nr *_Parents__Repr) ListIterator() datamodel.ListIterator {
	return &_Parents__ReprListItr{(Parents)(nr), 0}
}

type _Parents__ReprListItr _Parents__ListItr

func (itr *_Parents__ReprListItr) Next() (idx int64, v datamodel.Node, err error) {
	idx, v, err = (*_Parents__ListItr)(itr).Next()
	if err != nil || v == datamodel.Null {
		return
	}
	return idx, v.(Link).Representation(), nil
}
func (itr *_Parents__ReprListItr) Done() bool {
	return (*_Parents__ListItr)(itr).Done()
}

func (rn *_Parents__Repr) Length() int64 {
	return int64(len(rn.x))
}
func (_Parents__Repr) IsAbsent() bool {
	return false
}
func (_Parents__Repr) IsNull() bool {
	return false
}
func (_Parents__Repr) AsBool() (bool, error) {
	return mixins.List{TypeName: "chaintypes.Parents.Repr"}.AsBool()
}
func (_Parents__Repr) AsInt() (int64, error) {
	return mixins.List{TypeName: "chaintypes.Parents.Repr"}.AsInt()
}
func (_Parents__Repr) AsFloat() (float64, error) {
	return mixins.List{TypeName: "chaintypes.Parents.Repr"}.AsFloat()
}
func (_Parents__Repr) AsString() (string, error) {
	return mixins.List{TypeName: "chaintypes.Parents.Repr"}.AsString()
}
func (_Parents__Repr) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "chaintypes.Parents.Repr"}.AsBytes()
}
func (_Parents__Repr) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "chaintypes.Parents.Repr"}.AsLink()
}
func (_Parents__Repr) Prototype() datamodel.NodePrototype {
	return _Parents__ReprPrototype{}
}

type _Parents__ReprPrototype struct{}

func (_Parents__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Parents__ReprBuilder
	nb.Reset()
	return &nb
}

type _Parents__ReprBuilder struct {
	_Parents__ReprAssembler
}

func (nb *_Parents__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Parents__ReprBuilder) Reset() {
	var w _Parents
	var m schema.Maybe
	*nb = _Parents__ReprBuilder{_Parents__ReprAssembler{w: &w, m: &m}}
}

type _Parents__ReprAssembler struct {
	w     *_Parents
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _Link__ReprAssembler
}

func (na *_Parents__ReprAssembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_Parents__ReprAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents.Repr"}.BeginMap(0)
}
func (na *_Parents__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_Link, 0, sizeHint)
	}
	return na, nil
}
func (na *_Parents__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "chaintypes.Parents.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Parents__ReprAssembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents.Repr"}.AssignBool(false)
}
func (_Parents__ReprAssembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents.Repr"}.AssignInt(0)
}
func (_Parents__ReprAssembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents.Repr"}.AssignFloat(0)
}
func (_Parents__ReprAssembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents.Repr"}.AssignString("")
}
func (_Parents__ReprAssembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents.Repr"}.AssignBytes(nil)
}
func (_Parents__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "chaintypes.Parents.Repr"}.AssignLink(nil)
}
func (na *_Parents__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Parents); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "chaintypes.Parents.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Parents__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _Parents__ReprPrototype{}
}
func (la *_Parents__ReprAssembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_Parents__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _Link{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_Parents__ReprAssembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_Parents__ReprAssembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _Link__ReprPrototype{}
}

func (n String) String() string {
	return n.x
}
func (_String__Prototype) fromString(w *_String, v string) error {
	*w = _String{v}
	return nil
}
func (_String__Prototype) FromString(v string) (String, error) {
	n := _String{v}
	return &n, nil
}

type _String__Maybe struct {
	m schema.Maybe
	v _String
}
type MaybeString = *_String__Maybe

func (m MaybeString) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeString) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeString) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeString) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeString) Must() String {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (String)(&_String{})
var _ schema.TypedNode = (String)(&_String{})

func (String) Kind() datamodel.Kind {
	return datamodel.Kind_String
}
func (String) LookupByString(string) (datamodel.Node, error) {
	return mixins.String{TypeName: "chaintypes.String"}.LookupByString("")
}
func (String) LookupByNode(datamodel.Node) (datamodel.Node, error) {
	return mixins.String{TypeName: "chaintypes.String"}.LookupByNode(nil)
}
func (String) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.String{TypeName: "chaintypes.String"}.LookupByIndex(0)
}
func (String) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return mixins.String{TypeName: "chaintypes.String"}.LookupBySegment(seg)
}
func (String) MapIterator() datamodel.MapIterator {
	return nil
}
func (String) ListIterator() datamodel.ListIterator {
	return nil
}
func (String) Length() int64 {
	return -1
}
func (String) IsAbsent() bool {
	return false
}
func (String) IsNull() bool {
	return false
}
func (String) AsBool() (bool, error) {
	return mixins.String{TypeName: "chaintypes.String"}.AsBool()
}
func (String) AsInt() (int64, error) {
	return mixins.String{TypeName: "chaintypes.String"}.AsInt()
}
func (String) AsFloat() (float64, error) {
	return mixins.String{TypeName: "chaintypes.String"}.AsFloat()
}
func (n String) AsString() (string, error) {
	return n.x, nil
}
func (String) AsBytes() ([]byte, error) {
	return mixins.String{TypeName: "chaintypes.String"}.AsBytes()
}
func (String) AsLink() (datamodel.Link, error) {
	return mixins.String{TypeName: "chaintypes.String"}.AsLink()
}
func (String) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}

type _String__Prototype struct{}

func (_String__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _String__Builder
	nb.Reset()
	return &nb
}

type _String__Builder struct {
	_String__Assembler
}

func (nb *_String__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_String__Builder) Reset() {
	var w _String
	var m schema.Maybe
	*nb = _String__Builder{_String__Assembler{w: &w, m: &m}}
}

type _String__Assembler struct {
	w *_String
	m *schema.Maybe
}

func (na *_String__Assembler) reset() {}
func (_String__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "chaintypes.String"}.BeginMap(0)
}
func (_String__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "chaintypes.String"}.BeginList(0)
}
func (na *_String__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.StringAssembler{TypeName: "chaintypes.String"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_String__Assembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "chaintypes.String"}.AssignBool(false)
}
func (_String__Assembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "chaintypes.String"}.AssignInt(0)
}
func (_String__Assembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "chaintypes.String"}.AssignFloat(0)
}
func (na *_String__Assembler) AssignString(v string) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_String__Assembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "chaintypes.String"}.AssignBytes(nil)
}
func (_String__Assembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "chaintypes.String"}.AssignLink(nil)
}
func (na *_String__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_String); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return na.AssignString(v2)
	}
}
func (_String__Assembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (String) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n String) Representation() datamodel.Node {
	return (*_String__Repr)(n)
}

type _String__Repr = _String

var _ datamodel.Node = &_String__Repr{}

type _String__ReprPrototype = _String__Prototype
type _String__ReprAssembler = _String__Assembler
