// Copyright (c) 2016, 2018, 2021, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// API Gateway API
//
// API for the API Gateway service. Use this API to manage gateways, deployments, and related items.
// For more information, see
// Overview of API Gateway (https://docs.cloud.oracle.com/iaas/Content/APIGateway/Concepts/apigatewayoverview.htm).
//

package apigateway

import (
	"github.com/oracle/oci-go-sdk/v32/common"
)

// WorkRequest A description of the work request status.
type WorkRequest struct {

	// The OCID (https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm) of the resource.
	Id *string `mandatory:"true" json:"id"`

	// The type of the work request.
	OperationType WorkRequestOperationTypeEnum `mandatory:"true" json:"operationType"`

	// The status of the work request.
	Status WorkRequestStatusEnum `mandatory:"true" json:"status"`

	// The OCID (https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm) of the compartment in which the
	// resource is created.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// The resources affected by this work request.
	Resources []WorkRequestResource `mandatory:"true" json:"resources"`

	// Percentage of the request completed.
	PercentComplete *float32 `mandatory:"true" json:"percentComplete"`

	// The date and time the request was created, as described in
	// RFC 3339 (https://tools.ietf.org/rfc/rfc3339), section 14.29.
	TimeAccepted *common.SDKTime `mandatory:"true" json:"timeAccepted"`

	// The date and time the request was started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339),
	// section 14.29.
	TimeStarted *common.SDKTime `mandatory:"false" json:"timeStarted"`

	// The date and time the request was finished, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339).
	TimeFinished *common.SDKTime `mandatory:"false" json:"timeFinished"`
}

func (m WorkRequest) String() string {
	return common.PointerString(m)
}

// WorkRequestOperationTypeEnum Enum with underlying type: string
type WorkRequestOperationTypeEnum string

// Set of constants representing the allowable values for WorkRequestOperationTypeEnum
const (
	WorkRequestOperationTypeCreateGateway     WorkRequestOperationTypeEnum = "CREATE_GATEWAY"
	WorkRequestOperationTypeUpdateGateway     WorkRequestOperationTypeEnum = "UPDATE_GATEWAY"
	WorkRequestOperationTypeDeleteGateway     WorkRequestOperationTypeEnum = "DELETE_GATEWAY"
	WorkRequestOperationTypeCreateDeployment  WorkRequestOperationTypeEnum = "CREATE_DEPLOYMENT"
	WorkRequestOperationTypeUpdateDeployment  WorkRequestOperationTypeEnum = "UPDATE_DEPLOYMENT"
	WorkRequestOperationTypeDeleteDeployment  WorkRequestOperationTypeEnum = "DELETE_DEPLOYMENT"
	WorkRequestOperationTypeCreateCertificate WorkRequestOperationTypeEnum = "CREATE_CERTIFICATE"
	WorkRequestOperationTypeUpdateCertificate WorkRequestOperationTypeEnum = "UPDATE_CERTIFICATE"
	WorkRequestOperationTypeDeleteCertificate WorkRequestOperationTypeEnum = "DELETE_CERTIFICATE"
	WorkRequestOperationTypeCreateApi         WorkRequestOperationTypeEnum = "CREATE_API"
	WorkRequestOperationTypeUpdateApi         WorkRequestOperationTypeEnum = "UPDATE_API"
	WorkRequestOperationTypeDeleteApi         WorkRequestOperationTypeEnum = "DELETE_API"
	WorkRequestOperationTypeValidateApi       WorkRequestOperationTypeEnum = "VALIDATE_API"
)

var mappingWorkRequestOperationType = map[string]WorkRequestOperationTypeEnum{
	"CREATE_GATEWAY":     WorkRequestOperationTypeCreateGateway,
	"UPDATE_GATEWAY":     WorkRequestOperationTypeUpdateGateway,
	"DELETE_GATEWAY":     WorkRequestOperationTypeDeleteGateway,
	"CREATE_DEPLOYMENT":  WorkRequestOperationTypeCreateDeployment,
	"UPDATE_DEPLOYMENT":  WorkRequestOperationTypeUpdateDeployment,
	"DELETE_DEPLOYMENT":  WorkRequestOperationTypeDeleteDeployment,
	"CREATE_CERTIFICATE": WorkRequestOperationTypeCreateCertificate,
	"UPDATE_CERTIFICATE": WorkRequestOperationTypeUpdateCertificate,
	"DELETE_CERTIFICATE": WorkRequestOperationTypeDeleteCertificate,
	"CREATE_API":         WorkRequestOperationTypeCreateApi,
	"UPDATE_API":         WorkRequestOperationTypeUpdateApi,
	"DELETE_API":         WorkRequestOperationTypeDeleteApi,
	"VALIDATE_API":       WorkRequestOperationTypeValidateApi,
}

// GetWorkRequestOperationTypeEnumValues Enumerates the set of values for WorkRequestOperationTypeEnum
func GetWorkRequestOperationTypeEnumValues() []WorkRequestOperationTypeEnum {
	values := make([]WorkRequestOperationTypeEnum, 0)
	for _, v := range mappingWorkRequestOperationType {
		values = append(values, v)
	}
	return values
}

// WorkRequestStatusEnum Enum with underlying type: string
type WorkRequestStatusEnum string

// Set of constants representing the allowable values for WorkRequestStatusEnum
const (
	WorkRequestStatusAccepted   WorkRequestStatusEnum = "ACCEPTED"
	WorkRequestStatusInProgress WorkRequestStatusEnum = "IN_PROGRESS"
	WorkRequestStatusFailed     WorkRequestStatusEnum = "FAILED"
	WorkRequestStatusSucceeded  WorkRequestStatusEnum = "SUCCEEDED"
	WorkRequestStatusCanceling  WorkRequestStatusEnum = "CANCELING"
	WorkRequestStatusCanceled   WorkRequestStatusEnum = "CANCELED"
)

var mappingWorkRequestStatus = map[string]WorkRequestStatusEnum{
	"ACCEPTED":    WorkRequestStatusAccepted,
	"IN_PROGRESS": WorkRequestStatusInProgress,
	"FAILED":      WorkRequestStatusFailed,
	"SUCCEEDED":   WorkRequestStatusSucceeded,
	"CANCELING":   WorkRequestStatusCanceling,
	"CANCELED":    WorkRequestStatusCanceled,
}

// GetWorkRequestStatusEnumValues Enumerates the set of values for WorkRequestStatusEnum
func GetWorkRequestStatusEnumValues() []WorkRequestStatusEnum {
	values := make([]WorkRequestStatusEnum, 0)
	for _, v := range mappingWorkRequestStatus {
		values = append(values, v)
	}
	return values
}
