// Copyright (c) 2016, 2018, 2021, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Vault Service Key Management API
//
// API for managing and performing operations with keys and vaults. (For the API for managing secrets, see the Vault Service
// Secret Management API. For the API for retrieving secrets, see the Vault Service Secret Retrieval API.)
//

package keymanagement

import (
	"github.com/oracle/oci-go-sdk/v32/common"
)

// KeyShape The cryptographic properties of a key.
type KeyShape struct {

	// The algorithm used by a key's key versions to encrypt or decrypt.
	Algorithm KeyShapeAlgorithmEnum `mandatory:"true" json:"algorithm"`

	// The length of the key, expressed as an integer. Values of 16, 24, or 32 are supported.
	Length *int `mandatory:"true" json:"length"`
}

func (m KeyShape) String() string {
	return common.PointerString(m)
}

// KeyShapeAlgorithmEnum Enum with underlying type: string
type KeyShapeAlgorithmEnum string

// Set of constants representing the allowable values for KeyShapeAlgorithmEnum
const (
	KeyShapeAlgorithmAes KeyShapeAlgorithmEnum = "AES"
	KeyShapeAlgorithmRsa KeyShapeAlgorithmEnum = "RSA"
)

var mappingKeyShapeAlgorithm = map[string]KeyShapeAlgorithmEnum{
	"AES": KeyShapeAlgorithmAes,
	"RSA": KeyShapeAlgorithmRsa,
}

// GetKeyShapeAlgorithmEnumValues Enumerates the set of values for KeyShapeAlgorithmEnum
func GetKeyShapeAlgorithmEnumValues() []KeyShapeAlgorithmEnum {
	values := make([]KeyShapeAlgorithmEnum, 0)
	for _, v := range mappingKeyShapeAlgorithm {
		values = append(values, v)
	}
	return values
}
