// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Functions Service API
//
// API for the Functions service.
//

package functions

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ConfigDetails Details about the required and optional Function configurations needed for proper performance of the PBF.
type ConfigDetails struct {

	// The key name of the config param.
	Key *string `mandatory:"true" json:"key"`

	// Details about why this config is required and what it will be used for.
	Description *string `mandatory:"true" json:"description"`

	// Is this a required config or an optional one. Requests with required config params missing will be rejected.
	IsOptional *bool `mandatory:"false" json:"isOptional"`
}

func (m ConfigDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ConfigDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
