// Reverse shell and command payloads.
//
// The reverse package contains all the code for reverse shell payloads. Each of these payload types can be
// used either in the raw string format for manipulation or via the specific payload type provided by the
// project.
//
// This package is designed to be abstract enough to allow for multiple types of composition, but always with
// the fact that payloads are almost always string or byte oriented. With this in mind the payloads may be
// invoked with a constructed type or a direct string call.
//
// For example, here are the 3 ways to create a netcat reverse shell payload that result in the same payload:
//
//	reverse.Netcat.Default("127.0.0.1", 1337)
//	reverse.Netcat.Mknod("127.0.0.1", 1337)
//	fmt.Sprintf(reverse.NetcatMknod, "127.0.0.1", 1337)
//
// Each of the defined payload types should utilize a Default reverse shell constant that corresponds to the
// most common case.
package reverse

// Defines the Default function to be created for each type of payload.
type Reverse interface {
	Default
}

type Default interface{}

// Defines the default Bash struct and all associated payload functions.
type (
	BashPayload       struct{}
	GJScriptPayload   struct{}
	JJSScriptPayload  struct{}
	JavascriptPayload struct{}
	JavaPayload       struct{}
	NetcatPayload     struct{}
	OpenSSLPayload    struct{}
	PHPPayload        struct{}
	PythonPayload     struct{}
	TelnetPayload     struct{}
	GroovyPayload     struct{}
	VBSHTTPPayload    struct{}
)

var (
	// Example: makes the Bash payloads accessible via `reverse.Bash`.
	Bash       = &BashPayload{}
	GJScript   = &GJScriptPayload{}
	JJS        = &JJSScriptPayload{}
	Java       = &JavaPayload{}
	Javascript = &JavascriptPayload{}
	Netcat     = &NetcatPayload{}
	OpenSSL    = &OpenSSLPayload{}
	PHP        = &PHPPayload{}
	Python     = &PythonPayload{}
	Telnet     = &TelnetPayload{}
	Groovy     = &GroovyPayload{}
	VBSHTTP    = &VBSHTTPPayload{}
)
