// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: opentelemetry/proto/profiles/v1experimental/profiles.proto

package v1experimental

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"

	v11 "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	v1 "go.opentelemetry.io/collector/pdata/internal/data/protogen/resource/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// ProfilesData represents the profiles data that can be stored in persistent storage,
// OR can be embedded by other protocols that transfer OTLP profiles data but do not
// implement the OTLP protocol.
//
// The main difference between this message and collector protocol is that
// in this message there will not be any "control" or "metadata" specific to
// OTLP protocol.
//
// When new fields are added into this message, the OTLP request MUST be updated
// as well.
type ProfilesData struct {
	// An array of ResourceProfiles.
	// For data coming from a single resource this array will typically contain
	// one element. Intermediary nodes that receive data from multiple origins
	// typically batch the data before forwarding further and in that case this
	// array will contain multiple elements.
	ResourceProfiles []*ResourceProfiles `protobuf:"bytes,1,rep,name=resource_profiles,json=resourceProfiles,proto3" json:"resource_profiles,omitempty"`
}

func (m *ProfilesData) Reset()         { *m = ProfilesData{} }
func (m *ProfilesData) String() string { return proto.CompactTextString(m) }
func (*ProfilesData) ProtoMessage()    {}
func (*ProfilesData) Descriptor() ([]byte, []int) {
	return fileDescriptor_394731f2296acea3, []int{0}
}
func (m *ProfilesData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProfilesData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProfilesData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProfilesData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProfilesData.Merge(m, src)
}
func (m *ProfilesData) XXX_Size() int {
	return m.Size()
}
func (m *ProfilesData) XXX_DiscardUnknown() {
	xxx_messageInfo_ProfilesData.DiscardUnknown(m)
}

var xxx_messageInfo_ProfilesData proto.InternalMessageInfo

func (m *ProfilesData) GetResourceProfiles() []*ResourceProfiles {
	if m != nil {
		return m.ResourceProfiles
	}
	return nil
}

// A collection of ScopeProfiles from a Resource.
type ResourceProfiles struct {
	// The resource for the profiles in this message.
	// If this field is not set then no resource info is known.
	Resource v1.Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource"`
	// A list of ScopeProfiles that originate from a resource.
	ScopeProfiles []*ScopeProfiles `protobuf:"bytes,2,rep,name=scope_profiles,json=scopeProfiles,proto3" json:"scope_profiles,omitempty"`
	// The Schema URL, if known. This is the identifier of the Schema that the resource data
	// is recorded in. To learn more about Schema URL see
	// https://opentelemetry.io/docs/specs/otel/schemas/#schema-url
	// This schema_url applies to the data in the "resource" field. It does not apply
	// to the data in the "scope_profiles" field which have their own schema_url field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *ResourceProfiles) Reset()         { *m = ResourceProfiles{} }
func (m *ResourceProfiles) String() string { return proto.CompactTextString(m) }
func (*ResourceProfiles) ProtoMessage()    {}
func (*ResourceProfiles) Descriptor() ([]byte, []int) {
	return fileDescriptor_394731f2296acea3, []int{1}
}
func (m *ResourceProfiles) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceProfiles) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceProfiles.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceProfiles) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceProfiles.Merge(m, src)
}
func (m *ResourceProfiles) XXX_Size() int {
	return m.Size()
}
func (m *ResourceProfiles) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceProfiles.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceProfiles proto.InternalMessageInfo

func (m *ResourceProfiles) GetResource() v1.Resource {
	if m != nil {
		return m.Resource
	}
	return v1.Resource{}
}

func (m *ResourceProfiles) GetScopeProfiles() []*ScopeProfiles {
	if m != nil {
		return m.ScopeProfiles
	}
	return nil
}

func (m *ResourceProfiles) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// A collection of ProfileContainers produced by an InstrumentationScope.
type ScopeProfiles struct {
	// The instrumentation scope information for the profiles in this message.
	// Semantically when InstrumentationScope isn't set, it is equivalent with
	// an empty instrumentation scope name (unknown).
	Scope v11.InstrumentationScope `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope"`
	// A list of ProfileContainers that originate from an instrumentation scope.
	Profiles []*ProfileContainer `protobuf:"bytes,2,rep,name=profiles,proto3" json:"profiles,omitempty"`
	// The Schema URL, if known. This is the identifier of the Schema that the metric data
	// is recorded in. To learn more about Schema URL see
	// https://opentelemetry.io/docs/specs/otel/schemas/#schema-url
	// This schema_url applies to all profiles in the "profiles" field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *ScopeProfiles) Reset()         { *m = ScopeProfiles{} }
func (m *ScopeProfiles) String() string { return proto.CompactTextString(m) }
func (*ScopeProfiles) ProtoMessage()    {}
func (*ScopeProfiles) Descriptor() ([]byte, []int) {
	return fileDescriptor_394731f2296acea3, []int{2}
}
func (m *ScopeProfiles) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScopeProfiles) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScopeProfiles.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScopeProfiles) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScopeProfiles.Merge(m, src)
}
func (m *ScopeProfiles) XXX_Size() int {
	return m.Size()
}
func (m *ScopeProfiles) XXX_DiscardUnknown() {
	xxx_messageInfo_ScopeProfiles.DiscardUnknown(m)
}

var xxx_messageInfo_ScopeProfiles proto.InternalMessageInfo

func (m *ScopeProfiles) GetScope() v11.InstrumentationScope {
	if m != nil {
		return m.Scope
	}
	return v11.InstrumentationScope{}
}

func (m *ScopeProfiles) GetProfiles() []*ProfileContainer {
	if m != nil {
		return m.Profiles
	}
	return nil
}

func (m *ScopeProfiles) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// A ProfileContainer represents a single profile. It wraps pprof profile with OpenTelemetry specific metadata.
type ProfileContainer struct {
	// A globally unique identifier for a profile. The ID is a 16-byte array. An ID with
	// all zeroes is considered invalid.
	//
	// This field is required.
	ProfileId []byte `protobuf:"bytes,1,opt,name=profile_id,json=profileId,proto3" json:"profile_id,omitempty"`
	// start_time_unix_nano is the start time of the profile.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// This field is semantically required and it is expected that end_time >= start_time.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// end_time_unix_nano is the end time of the profile.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// This field is semantically required and it is expected that end_time >= start_time.
	EndTimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=end_time_unix_nano,json=endTimeUnixNano,proto3" json:"end_time_unix_nano,omitempty"`
	// attributes is a collection of key/value pairs. Note, global attributes
	// like server name can be set using the resource API. Examples of attributes:
	//
	//     "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
	//     "/http/server_latency": 300
	//     "abc.com/myattribute": true
	//     "abc.com/score": 10.239
	//
	// The OpenTelemetry API specification further restricts the allowed value types:
	// https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/common/README.md#attribute
	// Attribute keys MUST be unique (it is not allowed to have more than one
	// attribute with the same key).
	Attributes []v11.KeyValue `protobuf:"bytes,4,rep,name=attributes,proto3" json:"attributes"`
	// dropped_attributes_count is the number of attributes that were discarded. Attributes
	// can be discarded because their keys are too long or because there are too many
	// attributes. If this value is 0, then no attributes were dropped.
	DroppedAttributesCount uint32 `protobuf:"varint,5,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
	// Specifies format of the original payload. Common values are defined in semantic conventions. [required if original_payload is present]
	OriginalPayloadFormat string `protobuf:"bytes,6,opt,name=original_payload_format,json=originalPayloadFormat,proto3" json:"original_payload_format,omitempty"`
	// Original payload can be stored in this field. This can be useful for users who want to get the original payload.
	// Formats such as JFR are highly extensible and can contain more information than what is defined in this spec.
	// Inclusion of original payload should be configurable by the user. Default behavior should be to not include the original payload.
	// If the original payload is in pprof format, it SHOULD not be included in this field.
	// The field is optional, however if it is present `profile` MUST be present and contain the same profiling information.
	OriginalPayload []byte `protobuf:"bytes,7,opt,name=original_payload,json=originalPayload,proto3" json:"original_payload,omitempty"`
	// This is a reference to a pprof profile. Required, even when original_payload is present.
	Profile Profile `protobuf:"bytes,8,opt,name=profile,proto3" json:"profile"`
}

func (m *ProfileContainer) Reset()         { *m = ProfileContainer{} }
func (m *ProfileContainer) String() string { return proto.CompactTextString(m) }
func (*ProfileContainer) ProtoMessage()    {}
func (*ProfileContainer) Descriptor() ([]byte, []int) {
	return fileDescriptor_394731f2296acea3, []int{3}
}
func (m *ProfileContainer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProfileContainer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProfileContainer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProfileContainer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProfileContainer.Merge(m, src)
}
func (m *ProfileContainer) XXX_Size() int {
	return m.Size()
}
func (m *ProfileContainer) XXX_DiscardUnknown() {
	xxx_messageInfo_ProfileContainer.DiscardUnknown(m)
}

var xxx_messageInfo_ProfileContainer proto.InternalMessageInfo

func (m *ProfileContainer) GetProfileId() []byte {
	if m != nil {
		return m.ProfileId
	}
	return nil
}

func (m *ProfileContainer) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *ProfileContainer) GetEndTimeUnixNano() uint64 {
	if m != nil {
		return m.EndTimeUnixNano
	}
	return 0
}

func (m *ProfileContainer) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *ProfileContainer) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

func (m *ProfileContainer) GetOriginalPayloadFormat() string {
	if m != nil {
		return m.OriginalPayloadFormat
	}
	return ""
}

func (m *ProfileContainer) GetOriginalPayload() []byte {
	if m != nil {
		return m.OriginalPayload
	}
	return nil
}

func (m *ProfileContainer) GetProfile() Profile {
	if m != nil {
		return m.Profile
	}
	return Profile{}
}

func init() {
	proto.RegisterType((*ProfilesData)(nil), "opentelemetry.proto.profiles.v1experimental.ProfilesData")
	proto.RegisterType((*ResourceProfiles)(nil), "opentelemetry.proto.profiles.v1experimental.ResourceProfiles")
	proto.RegisterType((*ScopeProfiles)(nil), "opentelemetry.proto.profiles.v1experimental.ScopeProfiles")
	proto.RegisterType((*ProfileContainer)(nil), "opentelemetry.proto.profiles.v1experimental.ProfileContainer")
}

func init() {
	proto.RegisterFile("opentelemetry/proto/profiles/v1experimental/profiles.proto", fileDescriptor_394731f2296acea3)
}

var fileDescriptor_394731f2296acea3 = []byte{
	// 652 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x94, 0x51, 0x6b, 0xdb, 0x3a,
	0x14, 0xc7, 0xe3, 0xa6, 0x4d, 0x52, 0xb5, 0xb9, 0x4d, 0x45, 0xef, 0xbd, 0xa6, 0x70, 0x73, 0x43,
	0x5e, 0x96, 0xae, 0x60, 0x93, 0x76, 0x8c, 0x51, 0x18, 0x63, 0xed, 0x36, 0xe8, 0xca, 0xd6, 0xe0,
	0xb5, 0x85, 0xed, 0xc5, 0xa8, 0xf1, 0x69, 0xa6, 0x61, 0x4b, 0x46, 0x96, 0x43, 0xba, 0x4f, 0xb1,
	0xcf, 0xb1, 0x4f, 0xd2, 0xc7, 0xee, 0x6d, 0x6c, 0x30, 0x46, 0xfb, 0xb2, 0x7e, 0x8b, 0x61, 0x59,
	0xf6, 0x12, 0x93, 0x51, 0xb2, 0x17, 0x23, 0x9f, 0xf3, 0x3f, 0xbf, 0xa3, 0xff, 0x91, 0x10, 0xda,
	0xe1, 0x21, 0x30, 0x09, 0x3e, 0x04, 0x20, 0xc5, 0xb9, 0x1d, 0x0a, 0x2e, 0x79, 0xf2, 0x3d, 0xa3,
	0x3e, 0x44, 0xf6, 0xb0, 0x0b, 0xa3, 0x10, 0x04, 0x0d, 0x80, 0x49, 0xe2, 0xe7, 0x71, 0x4b, 0xc9,
	0xf0, 0xe6, 0x44, 0x6d, 0x1a, 0xb4, 0x72, 0xcd, 0x64, 0xed, 0xfa, 0xda, 0x80, 0x0f, 0x78, 0x8a,
	0x4f, 0x56, 0xa9, 0x7a, 0xfd, 0xee, 0xb4, 0xf6, 0x7d, 0x1e, 0x04, 0x9c, 0xd9, 0xc3, 0xae, 0x5e,
	0x69, 0xad, 0x35, 0x4d, 0x2b, 0x20, 0xe2, 0xb1, 0xe8, 0x43, 0xa2, 0xce, 0xd6, 0x5a, 0xff, 0x68,
	0x26, 0x6b, 0x49, 0x02, 0x46, 0x12, 0x98, 0x07, 0x5e, 0x0a, 0x68, 0xbf, 0x47, 0xcb, 0x3d, 0x2d,
	0x7f, 0x42, 0x24, 0xc1, 0xef, 0xd0, 0x6a, 0xd6, 0xc2, 0xcd, 0x38, 0xa6, 0xd1, 0x2a, 0x77, 0x96,
	0xb6, 0x1e, 0x5a, 0x33, 0xcc, 0xc2, 0x72, 0x34, 0x25, 0xa3, 0x3b, 0x0d, 0x51, 0x88, 0xb4, 0x6f,
	0x0c, 0xd4, 0x28, 0xca, 0xf0, 0x01, 0xaa, 0x65, 0x42, 0xd3, 0x68, 0x19, 0x9d, 0xa5, 0xad, 0x8d,
	0xa9, 0x7d, 0xf3, 0x41, 0x0c, 0xbb, 0x79, 0xaf, 0xdd, 0xf9, 0x8b, 0x6f, 0xff, 0x97, 0x9c, 0x1c,
	0x80, 0x09, 0xfa, 0x2b, 0xea, 0xf3, 0x70, 0xcc, 0xca, 0x9c, 0xb2, 0xb2, 0x33, 0x93, 0x95, 0x57,
	0x09, 0x22, 0xf7, 0x51, 0x8f, 0xc6, 0x7f, 0xf1, 0x7f, 0x08, 0x45, 0xfd, 0xb7, 0x10, 0x10, 0x37,
	0x16, 0xbe, 0x59, 0x6e, 0x19, 0x9d, 0x45, 0x67, 0x31, 0x8d, 0x1c, 0x0b, 0xff, 0x79, 0xa5, 0xf6,
	0xa3, 0xda, 0xb8, 0xa9, 0xb6, 0xbf, 0x18, 0xa8, 0x3e, 0xc1, 0xc1, 0x87, 0x68, 0x41, 0x91, 0xb4,
	0xcb, 0xed, 0xa9, 0x5b, 0xd2, 0x97, 0x63, 0xd8, 0xb5, 0xf6, 0x59, 0x24, 0x45, 0xac, 0x76, 0x24,
	0x29, 0x67, 0x8a, 0xa5, 0xfd, 0xa6, 0x1c, 0xfc, 0x1a, 0xd5, 0x0a, 0x36, 0x67, 0x3b, 0x31, 0xbd,
	0xb3, 0x3d, 0xce, 0x24, 0xa1, 0x0c, 0x84, 0x93, 0xe3, 0x6e, 0x31, 0xd9, 0xfe, 0x54, 0x46, 0x8d,
	0x62, 0x75, 0x52, 0xa3, 0xeb, 0x5d, 0xea, 0x29, 0x93, 0xcb, 0xce, 0xa2, 0x8e, 0xec, 0x7b, 0xd8,
	0x46, 0x6b, 0x91, 0x24, 0x42, 0xba, 0x92, 0x06, 0xe0, 0xc6, 0x8c, 0x8e, 0x5c, 0x46, 0x18, 0x37,
	0xe7, 0x5a, 0x46, 0xa7, 0xe2, 0xac, 0xaa, 0xdc, 0x11, 0x0d, 0xe0, 0x98, 0xd1, 0xd1, 0x4b, 0xc2,
	0x38, 0xde, 0x44, 0x18, 0x98, 0x57, 0x94, 0x97, 0x95, 0x7c, 0x05, 0x98, 0x37, 0x21, 0x7e, 0x81,
	0x10, 0x91, 0x52, 0xd0, 0xd3, 0x58, 0x42, 0x64, 0xce, 0xab, 0x69, 0xdc, 0xb9, 0x65, 0xc2, 0x07,
	0x70, 0x7e, 0x42, 0xfc, 0x38, 0x9b, 0xea, 0x18, 0x00, 0x3f, 0x40, 0xa6, 0x27, 0x78, 0x18, 0x82,
	0xe7, 0xfe, 0x8a, 0xba, 0x7d, 0x1e, 0x33, 0x69, 0x2e, 0xb4, 0x8c, 0x4e, 0xdd, 0xf9, 0x47, 0xe7,
	0x1f, 0xe7, 0xe9, 0xbd, 0x24, 0x8b, 0xef, 0xa3, 0x7f, 0xb9, 0xa0, 0x03, 0xca, 0x88, 0xef, 0x86,
	0xe4, 0xdc, 0xe7, 0xc4, 0x73, 0xcf, 0xb8, 0x08, 0x88, 0x34, 0x2b, 0x6a, 0x8c, 0x7f, 0x67, 0xe9,
	0x5e, 0x9a, 0x7d, 0xa6, 0x92, 0x78, 0x03, 0x35, 0x8a, 0x75, 0x66, 0x55, 0xcd, 0x70, 0xa5, 0x50,
	0x80, 0x8f, 0x50, 0x55, 0x8f, 0xd5, 0xac, 0xa9, 0xab, 0x74, 0xef, 0x4f, 0x8e, 0x5d, 0xbb, 0xce,
	0x50, 0xbb, 0x5f, 0x8d, 0x8b, 0xab, 0xa6, 0x71, 0x79, 0xd5, 0x34, 0xbe, 0x5f, 0x35, 0x8d, 0x0f,
	0xd7, 0xcd, 0xd2, 0xe5, 0x75, 0xb3, 0xf4, 0xf9, 0xba, 0x59, 0x42, 0x16, 0xe5, 0xb3, 0x74, 0xd8,
	0xad, 0x67, 0x77, 0xbe, 0x97, 0xc8, 0x7a, 0xc6, 0x1b, 0x67, 0x50, 0x04, 0xd0, 0xe4, 0x45, 0xf4,
	0x7d, 0xe8, 0x4b, 0x2e, 0xec, 0xd0, 0x23, 0x92, 0xd8, 0x94, 0x49, 0x10, 0x8c, 0xf8, 0xb6, 0xfa,
	0x53, 0x1d, 0x06, 0xc0, 0x7e, 0xf7, 0xb8, 0x7d, 0x9c, 0xdb, 0x3c, 0x0c, 0x81, 0x1d, 0xe5, 0x44,
	0xd5, 0x2b, 0x33, 0x17, 0x59, 0x27, 0xdd, 0xa7, 0x63, 0xea, 0xd3, 0x8a, 0xe2, 0x6d, 0xff, 0x0c,
	0x00, 0x00, 0xff, 0xff, 0xe1, 0x89, 0x49, 0xa4, 0x1b, 0x06, 0x00, 0x00,
}

func (m *ProfilesData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProfilesData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProfilesData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ResourceProfiles) > 0 {
		for iNdEx := len(m.ResourceProfiles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceProfiles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ResourceProfiles) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceProfiles) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceProfiles) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintProfiles(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ScopeProfiles) > 0 {
		for iNdEx := len(m.ScopeProfiles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ScopeProfiles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintProfiles(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ScopeProfiles) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScopeProfiles) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScopeProfiles) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintProfiles(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Profiles) > 0 {
		for iNdEx := len(m.Profiles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Profiles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.Scope.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintProfiles(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ProfileContainer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProfileContainer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProfileContainer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Profile.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintProfiles(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x42
	if len(m.OriginalPayload) > 0 {
		i -= len(m.OriginalPayload)
		copy(dAtA[i:], m.OriginalPayload)
		i = encodeVarintProfiles(dAtA, i, uint64(len(m.OriginalPayload)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.OriginalPayloadFormat) > 0 {
		i -= len(m.OriginalPayloadFormat)
		copy(dAtA[i:], m.OriginalPayloadFormat)
		i = encodeVarintProfiles(dAtA, i, uint64(len(m.OriginalPayloadFormat)))
		i--
		dAtA[i] = 0x32
	}
	if m.DroppedAttributesCount != 0 {
		i = encodeVarintProfiles(dAtA, i, uint64(m.DroppedAttributesCount))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProfiles(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.EndTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.EndTimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.ProfileId) > 0 {
		i -= len(m.ProfileId)
		copy(dAtA[i:], m.ProfileId)
		i = encodeVarintProfiles(dAtA, i, uint64(len(m.ProfileId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintProfiles(dAtA []byte, offset int, v uint64) int {
	offset -= sovProfiles(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ProfilesData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ResourceProfiles) > 0 {
		for _, e := range m.ResourceProfiles {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	return n
}

func (m *ResourceProfiles) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Resource.Size()
	n += 1 + l + sovProfiles(uint64(l))
	if len(m.ScopeProfiles) > 0 {
		for _, e := range m.ScopeProfiles {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovProfiles(uint64(l))
	}
	return n
}

func (m *ScopeProfiles) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Scope.Size()
	n += 1 + l + sovProfiles(uint64(l))
	if len(m.Profiles) > 0 {
		for _, e := range m.Profiles {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovProfiles(uint64(l))
	}
	return n
}

func (m *ProfileContainer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProfileId)
	if l > 0 {
		n += 1 + l + sovProfiles(uint64(l))
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.EndTimeUnixNano != 0 {
		n += 9
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovProfiles(uint64(l))
		}
	}
	if m.DroppedAttributesCount != 0 {
		n += 1 + sovProfiles(uint64(m.DroppedAttributesCount))
	}
	l = len(m.OriginalPayloadFormat)
	if l > 0 {
		n += 1 + l + sovProfiles(uint64(l))
	}
	l = len(m.OriginalPayload)
	if l > 0 {
		n += 1 + l + sovProfiles(uint64(l))
	}
	l = m.Profile.Size()
	n += 1 + l + sovProfiles(uint64(l))
	return n
}

func sovProfiles(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozProfiles(x uint64) (n int) {
	return sovProfiles(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ProfilesData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProfilesData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProfilesData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceProfiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceProfiles = append(m.ResourceProfiles, &ResourceProfiles{})
			if err := m.ResourceProfiles[len(m.ResourceProfiles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceProfiles) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceProfiles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceProfiles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScopeProfiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScopeProfiles = append(m.ScopeProfiles, &ScopeProfiles{})
			if err := m.ScopeProfiles[len(m.ScopeProfiles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScopeProfiles) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScopeProfiles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScopeProfiles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Scope.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Profiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Profiles = append(m.Profiles, &ProfileContainer{})
			if err := m.Profiles[len(m.Profiles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProfileContainer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProfileContainer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProfileContainer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProfileId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProfileId = append(m.ProfileId[:0], dAtA[iNdEx:postIndex]...)
			if m.ProfileId == nil {
				m.ProfileId = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTimeUnixNano", wireType)
			}
			m.EndTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.EndTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			m.DroppedAttributesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAttributesCount |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalPayloadFormat", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OriginalPayloadFormat = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginalPayload", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OriginalPayload = append(m.OriginalPayload[:0], dAtA[iNdEx:postIndex]...)
			if m.OriginalPayload == nil {
				m.OriginalPayload = []byte{}
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Profile", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProfiles
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProfiles
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Profile.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProfiles(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProfiles
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipProfiles(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowProfiles
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProfiles
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthProfiles
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupProfiles
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthProfiles
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthProfiles        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowProfiles          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupProfiles = fmt.Errorf("proto: unexpected end of group")
)
