/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.target;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.Architecture;
import org.jetbrains.kotlin.konan.target.BinaryFormat;
import org.jetbrains.kotlin.konan.target.Family;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.SanitizerKind;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0002\u001a\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\b*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001f\u001a\u00020\u0001*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006 "}, d2={"supportsGrandCentralDispatch", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getSupportsGrandCentralDispatch", "(Lorg/jetbrains/kotlin/konan/target/KonanTarget;)Z", "binaryFormat", "Lorg/jetbrains/kotlin/konan/target/BinaryFormat;", "customArgsForKonanSources", "", "", "hasAddressDependencyInMemoryModel", "hasFoundationFramework", "hasUIKitFramework", "needSmallBinary", "pointerBits", "", "suportsMemMem", "supportedSanitizers", "Lorg/jetbrains/kotlin/konan/target/SanitizerKind;", "supports64BitAtomics", "supports64BitMulOverflow", "supportsCodeCoverage", "supportsCoreSymbolication", "supportsExceptions", "supportsGccUnwind", "supportsIosCrashLog", "supportsLibBacktrace", "supportsMimallocAllocator", "supportsObjcInterop", "supportsThreads", "supportsUnalignedAccess", "supportsWinAPIUnwind", "kotlin-native-utils"})
public final class KonanTargetExtenstionsKt {
    @Nullable
    public static final BinaryFormat binaryFormat(@NotNull KonanTarget $this$binaryFormat) {
        BinaryFormat binaryFormat;
        Intrinsics.checkNotNullParameter((Object)$this$binaryFormat, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$binaryFormat.getFamily().ordinal()]) {
            case 1: {
                binaryFormat = BinaryFormat.MACH_O;
                break;
            }
            case 2: {
                binaryFormat = BinaryFormat.MACH_O;
                break;
            }
            case 3: {
                binaryFormat = BinaryFormat.MACH_O;
                break;
            }
            case 4: {
                binaryFormat = BinaryFormat.MACH_O;
                break;
            }
            case 5: {
                binaryFormat = BinaryFormat.ELF;
                break;
            }
            case 6: {
                binaryFormat = BinaryFormat.ELF;
                break;
            }
            case 7: {
                binaryFormat = BinaryFormat.PE_COFF;
                break;
            }
            case 8: 
            case 9: {
                binaryFormat = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return binaryFormat;
    }

    public static final int pointerBits(@NotNull KonanTarget $this$pointerBits) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$pointerBits, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$pointerBits.getArchitecture().ordinal()]) {
            case 1: {
                n = 64;
                break;
            }
            case 2: {
                n = 32;
                break;
            }
            case 3: {
                if (Intrinsics.areEqual((Object)$this$pointerBits, (Object)KonanTarget.WATCHOS_ARM64.INSTANCE)) {
                    n = 32;
                    break;
                }
                n = 64;
                break;
            }
            case 4: {
                n = 32;
                break;
            }
            case 5: {
                n = 32;
                break;
            }
            case 6: {
                n = 32;
                break;
            }
            case 7: {
                n = 32;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public static final boolean supportsCodeCoverage(@NotNull KonanTarget $this$supportsCodeCoverage) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsCodeCoverage, (String)"<this>");
        return false;
    }

    public static final boolean supportsMimallocAllocator(@NotNull KonanTarget $this$supportsMimallocAllocator) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsMimallocAllocator, (String)"<this>");
        KonanTarget konanTarget = $this$supportsMimallocAllocator;
        return konanTarget instanceof KonanTarget.LINUX_X64 ? true : (konanTarget instanceof KonanTarget.MINGW_X86 ? true : (konanTarget instanceof KonanTarget.MINGW_X64 ? true : (konanTarget instanceof KonanTarget.MACOS_X64 ? true : (konanTarget instanceof KonanTarget.MACOS_ARM64 ? true : (konanTarget instanceof KonanTarget.LINUX_ARM64 ? true : (konanTarget instanceof KonanTarget.LINUX_ARM32_HFP ? true : (konanTarget instanceof KonanTarget.ANDROID_X64 ? true : (konanTarget instanceof KonanTarget.ANDROID_ARM64 ? true : (konanTarget instanceof KonanTarget.IOS_ARM32 ? true : (konanTarget instanceof KonanTarget.IOS_ARM64 ? true : (konanTarget instanceof KonanTarget.IOS_X64 ? true : (konanTarget instanceof KonanTarget.IOS_SIMULATOR_ARM64 ? true : ((((((((((konanTarget instanceof KonanTarget.WATCHOS_ARM32 ? true : konanTarget instanceof KonanTarget.WATCHOS_ARM64) ? true : konanTarget instanceof KonanTarget.WATCHOS_SIMULATOR_ARM64) ? true : konanTarget instanceof KonanTarget.WATCHOS_X64) ? true : konanTarget instanceof KonanTarget.WATCHOS_X86) ? true : konanTarget instanceof KonanTarget.TVOS_ARM64) ? true : konanTarget instanceof KonanTarget.TVOS_SIMULATOR_ARM64) ? true : konanTarget instanceof KonanTarget.TVOS_X64) ? true : konanTarget instanceof KonanTarget.ANDROID_X86) ? true : konanTarget instanceof KonanTarget.ANDROID_ARM32) ? false : ((konanTarget instanceof KonanTarget.LINUX_MIPS32 ? true : konanTarget instanceof KonanTarget.LINUX_MIPSEL32) ? false : ((konanTarget instanceof KonanTarget.WASM32 ? true : konanTarget instanceof KonanTarget.ZEPHYR) ? false : false)))))))))))))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean supportsLibBacktrace(@NotNull KonanTarget $this$supportsLibBacktrace) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsLibBacktrace, (String)"<this>");
        if ($this$supportsLibBacktrace.getFamily().isAppleFamily()) return true;
        if ($this$supportsLibBacktrace.getFamily() == Family.LINUX) {
            Architecture[] architectureArray = new Architecture[]{Architecture.MIPS32, Architecture.MIPSEL32};
            if (!CollectionsKt.listOf((Object[])architectureArray).contains((Object)$this$supportsLibBacktrace.getArchitecture())) return true;
        }
        if ($this$supportsLibBacktrace.getFamily() != Family.ANDROID) return false;
        return true;
    }

    public static final boolean supportsCoreSymbolication(@NotNull KonanTarget $this$supportsCoreSymbolication) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsCoreSymbolication, (String)"<this>");
        Object[] objectArray = new KonanTarget[]{KonanTarget.MACOS_X64.INSTANCE, KonanTarget.MACOS_ARM64.INSTANCE, KonanTarget.IOS_X64.INSTANCE, KonanTarget.IOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.TVOS_X64.INSTANCE, KonanTarget.TVOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.WATCHOS_X86.INSTANCE, KonanTarget.WATCHOS_X64.INSTANCE, KonanTarget.WATCHOS_SIMULATOR_ARM64.INSTANCE};
        return CollectionsKt.listOf((Object[])objectArray).contains($this$supportsCoreSymbolication);
    }

    public static final boolean supportsGccUnwind(@NotNull KonanTarget $this$supportsGccUnwind) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsGccUnwind, (String)"<this>");
        return $this$supportsGccUnwind.getFamily() == Family.ANDROID || $this$supportsGccUnwind.getFamily() == Family.LINUX || $this$supportsGccUnwind instanceof KonanTarget.MINGW_X86;
    }

    public static final boolean supportsWinAPIUnwind(@NotNull KonanTarget $this$supportsWinAPIUnwind) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsWinAPIUnwind, (String)"<this>");
        return $this$supportsWinAPIUnwind instanceof KonanTarget.MINGW_X64;
    }

    public static final boolean supportsThreads(@NotNull KonanTarget $this$supportsThreads) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsThreads, (String)"<this>");
        KonanTarget konanTarget = $this$supportsThreads;
        return konanTarget instanceof KonanTarget.WASM32 ? false : !(konanTarget instanceof KonanTarget.ZEPHYR);
    }

    public static final boolean supportsExceptions(@NotNull KonanTarget $this$supportsExceptions) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsExceptions, (String)"<this>");
        KonanTarget konanTarget = $this$supportsExceptions;
        return konanTarget instanceof KonanTarget.WASM32 ? false : !(konanTarget instanceof KonanTarget.ZEPHYR);
    }

    public static final boolean suportsMemMem(@NotNull KonanTarget $this$suportsMemMem) {
        Intrinsics.checkNotNullParameter((Object)$this$suportsMemMem, (String)"<this>");
        KonanTarget konanTarget = $this$suportsMemMem;
        return konanTarget instanceof KonanTarget.WASM32 ? false : (konanTarget instanceof KonanTarget.MINGW_X86 ? false : (konanTarget instanceof KonanTarget.MINGW_X64 ? false : !(konanTarget instanceof KonanTarget.ZEPHYR)));
    }

    public static final boolean supportsObjcInterop(@NotNull KonanTarget $this$supportsObjcInterop) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsObjcInterop, (String)"<this>");
        return $this$supportsObjcInterop.getFamily().isAppleFamily();
    }

    public static final boolean hasFoundationFramework(@NotNull KonanTarget $this$hasFoundationFramework) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFoundationFramework, (String)"<this>");
        return $this$hasFoundationFramework.getFamily().isAppleFamily();
    }

    public static final boolean hasUIKitFramework(@NotNull KonanTarget $this$hasUIKitFramework) {
        Intrinsics.checkNotNullParameter((Object)$this$hasUIKitFramework, (String)"<this>");
        return $this$hasUIKitFramework.getFamily() == Family.IOS || $this$hasUIKitFramework.getFamily() == Family.TVOS;
    }

    public static final boolean supports64BitMulOverflow(@NotNull KonanTarget $this$supports64BitMulOverflow) {
        Intrinsics.checkNotNullParameter((Object)$this$supports64BitMulOverflow, (String)"<this>");
        KonanTarget konanTarget = $this$supports64BitMulOverflow;
        return konanTarget instanceof KonanTarget.MINGW_X86 ? false : (konanTarget instanceof KonanTarget.LINUX_ARM32_HFP ? false : (konanTarget instanceof KonanTarget.LINUX_MIPS32 ? false : (konanTarget instanceof KonanTarget.LINUX_MIPSEL32 ? false : (konanTarget instanceof KonanTarget.WASM32 ? false : (konanTarget instanceof KonanTarget.ZEPHYR ? false : (konanTarget instanceof KonanTarget.ANDROID_ARM32 ? false : !(konanTarget instanceof KonanTarget.ANDROID_X86)))))));
    }

    public static final boolean supportsIosCrashLog(@NotNull KonanTarget $this$supportsIosCrashLog) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsIosCrashLog, (String)"<this>");
        KonanTarget konanTarget = $this$supportsIosCrashLog;
        return Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.IOS_ARM32.INSTANCE) ? true : (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.IOS_ARM64.INSTANCE) ? true : (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.WATCHOS_ARM32.INSTANCE) ? true : (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.WATCHOS_ARM64.INSTANCE) ? true : Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.TVOS_ARM64.INSTANCE))));
    }

    public static final boolean supports64BitAtomics(@NotNull KonanTarget $this$supports64BitAtomics) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$supports64BitAtomics, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$supports64BitAtomics.getArchitecture().ordinal()]) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                bl = false;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl && !Intrinsics.areEqual((Object)$this$supports64BitAtomics, (Object)KonanTarget.WATCHOS_ARM64.INSTANCE) && !Intrinsics.areEqual((Object)$this$supports64BitAtomics, (Object)KonanTarget.WATCHOS_X86.INSTANCE);
    }

    public static final boolean supportsUnalignedAccess(@NotNull KonanTarget $this$supportsUnalignedAccess) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$supportsUnalignedAccess, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$supportsUnalignedAccess.getArchitecture().ordinal()]) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                bl = false;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl && !Intrinsics.areEqual((Object)$this$supportsUnalignedAccess, (Object)KonanTarget.WATCHOS_ARM64.INSTANCE);
    }

    public static final boolean needSmallBinary(@NotNull KonanTarget $this$needSmallBinary) {
        Intrinsics.checkNotNullParameter((Object)$this$needSmallBinary, (String)"<this>");
        return $this$needSmallBinary.getFamily() == Family.WATCHOS ? true : ($this$needSmallBinary.getFamily().isAppleFamily() ? $this$needSmallBinary.getArchitecture() == Architecture.ARM32 : false);
    }

    @NotNull
    public static final List<SanitizerKind> supportedSanitizers(@NotNull KonanTarget $this$supportedSanitizers) {
        Intrinsics.checkNotNullParameter((Object)$this$supportedSanitizers, (String)"<this>");
        KonanTarget konanTarget = $this$supportedSanitizers;
        return konanTarget instanceof KonanTarget.LINUX_X64 ? CollectionsKt.listOf((Object)((Object)SanitizerKind.ADDRESS)) : (konanTarget instanceof KonanTarget.MACOS_X64 ? CollectionsKt.listOf((Object)((Object)SanitizerKind.THREAD)) : CollectionsKt.emptyList());
    }

    public static final boolean hasAddressDependencyInMemoryModel(@NotNull KonanTarget $this$hasAddressDependencyInMemoryModel) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasAddressDependencyInMemoryModel, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$hasAddressDependencyInMemoryModel.getArchitecture().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = true;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean getSupportsGrandCentralDispatch(@NotNull KonanTarget $this$supportsGrandCentralDispatch) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$supportsGrandCentralDispatch, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$supportsGrandCentralDispatch.getFamily().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final List<String> customArgsForKonanSources(@NotNull KonanTarget $this$customArgsForKonanSources) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$customArgsForKonanSources, (String)"<this>");
        KonanTarget konanTarget = $this$customArgsForKonanSources;
        if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.WASM32.INSTANCE)) {
            Object[] objectArray = new String[]{"KONAN_NO_FFI=1", "KONAN_INTERNAL_DLMALLOC=1", "KONAN_INTERNAL_SNPRINTF=1", "KONAN_INTERNAL_NOW=1", "KONAN_NO_CTORS_SECTION=1", "KONAN_NO_BACKTRACE=1", "KONAN_NO_EXTERNAL_CALLS_CHECKER=1"};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else if (konanTarget instanceof KonanTarget.ZEPHYR) {
            Object[] objectArray = new String[]{"KONAN_NO_FFI=1", "KONAN_NO_MATH=1", "KONAN_INTERNAL_SNPRINTF=1", "KONAN_INTERNAL_NOW=1", "KONAN_NO_CTORS_SECTION=1", "KONAN_NO_BACKTRACE=1"};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Family.values().length];
            try {
                nArray[Family.WATCHOS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.IOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.TVOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.OSX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.ANDROID.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.LINUX.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.MINGW.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.WASM.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.ZEPHYR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Architecture.values().length];
            try {
                nArray[Architecture.X64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Architecture.X86.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Architecture.ARM64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Architecture.ARM32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Architecture.MIPS32.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Architecture.MIPSEL32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Architecture.WASM32.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

