/**
 * Copyright 1997, Steven M. Robbins <steve@nyongwa.montreal.qc.ca>
 * $Id: JavaDeps.java,v 1.14.2.3 1998/11/09 22:11:03 steve Exp $
 **/

package smr.JavaDeps;


import java.io.*;
import java.util.Enumeration;


public class JavaDeps
{
    public static java.io.PrintStream out = System.out;
    
    static String lineSeparator = System.getProperty( "line.separator" );
    
    static String version = "JavaDeps version 1.1";
    static String usage = "Usage: jdeps [options] [srcfile ... | -f file]" + lineSeparator
    + "For a list of options, use --help";
    static String copyright = "Copyright 1997,1998 Steve M. Robbins";
    static String bugs = "Please report bugs to "
    + "<steve@nyongwa.montreal.qc.ca>";
    static String url = "http://www.cs.mcgill.ca/~stever/software/JavaDeps";
    
    static String buildCommand = "$(JAVACOMPILE)";
    static String headerBuildCommand = "$(JAVAHEADER)";
    static boolean buildStubs = false;
    static String classVariable = "CLASSES";
    static String destDir = null;
    static boolean jmkSyntax = false;
    static boolean emitComments = true;
    static boolean noBuildCommands = false;
    static boolean beVerbose = false;
    static boolean enableDebugging = false;

    static void die( String errorMessage )
    {
	System.err.println( errorMessage );
	System.err.println();
	System.err.println( bugs );
	System.exit( 1 );
    }

    static void printVersion()
    {
	System.err.println( version );
	System.err.println( copyright );
	System.err.println( "See " + url + " for updates." );
	System.err.println();
	System.err.println( bugs );
    }
    
    static void printHelp()
    {
	System.err.println( version );
	System.err.println( usage );
	System.err.println();
	System.err.println( "  -b CMD, --build=CMD" +
			    "\tCommand used in build rules [" +
			    buildCommand + "]" );
	System.err.println( "  -C VARNAME, --classvar=VARNAME" );
	System.err.println( "\t\t\tMakefile variable for classes [" +
			    classVariable + "]" );
	System.err.println( "  -d DIR, --dir=DIR" +
			    "\tDirectory for class files" );
	System.err.println(
	"\t\t\tThis must be the same as in the javac command" );
	System.err.println( "  --debug\t\tEnable debugging" );
	System.err.println( "  -f FILE\t\tRead list of source files from FILE,");
	System.err.println( "\t\t\trather than from the command line" );	
	System.err.println( "  -h, --help\t\tShow this help text, then exit" );
	System.err.println( "  -j, --jmk\t\tGenerate jmk syntax rules" );
	System.err.println( "  -n\t\t\tDo not emit build commands" );
	System.err.println(
	"  --native\t\tOutput commands to build header files" );
	System.err.println(
	"  --native=stubs\tOutput commands to build both headers and stubs" );
	System.err.println( "  -o FILE, --output=FILE\tWrite output to FILE" );
	System.err.println( "  --silent\t\tDo not emit comments" );
	System.err.println( "  -v, --verbose\t\tBe verbose" );
	System.err.println( "  --version\t\tShow version, then exit" );
	System.err.println();
	System.err.println( bugs );
    }

    static void message( String msg )
    {
	if ( beVerbose )
	    System.err.println( msg );
    }

    public static void main(String args[])
    {
	ParseOptions po = null;
	String longFlags[] = { "debug", "help", "native", "silent",
			       "version", "verbose", "jmk" };
	String longOpts[] = { "build", "classvar", "dir", "output" };

	try {
	    po = new ParseOptions( args, "hnvj", "bCdfo",
				   longFlags, longOpts );
	} catch ( InvalidOptionException e ) {
	    System.err.println( e.getMessage() );
	    System.exit( 1 );
	}

	enableDebugging = po.seenOption( "debug" );
	if ( po.seenOption( 'h' ) || po.seenOption( "help" ) ) {
	    printHelp();
	    System.exit( 0 );
	} else if ( po.seenOption( "version" ) ) {
	    printVersion();
	    System.exit( 0 );
	}
	noBuildCommands = po.seenOption( 'n' );
	emitComments = ! po.seenOption( "silent" );
	beVerbose = po.seenOption( 'v' ) || po.seenOption( "verbose" );
	jmkSyntax = po.seenOption( 'j' ) || po.seenOption( "jmk" );
	
        if( jmkSyntax ) {
            buildCommand = "exec JAVACOMPILE COMPILEARGS";
        } 
	buildCommand = po.getOptionArgument( 'b', buildCommand );
	buildCommand = po.getOptionArgument( "build", buildCommand );

	if ( po.seenOption( "native" ) ) {
	    if ( "stubs".equalsIgnoreCase( po.getOptionArgument( "native" )))
		buildStubs = true;
	} else {
	    headerBuildCommand = null;
	}
	
	classVariable = po.getOptionArgument( 'C', classVariable );
	classVariable = po.getOptionArgument( "classvar", classVariable );
	
	destDir = po.getOptionArgument( 'd', destDir );
	destDir = po.getOptionArgument( "dir", destDir );

	Enumeration srcList;

	if ( po.seenOption( 'f' ) ) {
	    try {
		FileInputStream in = 
		    new FileInputStream( po.getOptionArgument( 'f' ) );
		srcList = new ParameterEnumeration( in );
	    } catch ( FileNotFoundException e ) {
		srcList = null; // to shut up javac		 
		System.err.println( e.getMessage() );
		System.exit(1);
	    }
	} else {
	    srcList = new ParameterEnumeration( po.getRemainingArgs() );
	}

        if( po.seenOption( 'o' ) || po.seenOption("output")) {
	   String outputFilename = po.getOptionArgument('o');
	   outputFilename = po.getOptionArgument("output", outputFilename);
            try {
		FileOutputStream fileOut = 
		    new FileOutputStream( po.getOptionArgument( 'o' ) );
                out = new PrintStream( fileOut );
	    } catch ( Exception e ) {
		System.err.println( e.getMessage() );
		System.exit(1);
            }
        }
        
	if ( ! srcList.hasMoreElements() )
	    die( usage );
	
	if ( noBuildCommands )
	    buildCommand = null;

	DepTable deps = new DepTable( destDir );
        DepTable.setJmk( jmkSyntax );
	Java parser = null;

	boolean noErrors = true;

	while ( srcList.hasMoreElements() ) {
	    String src = (String)srcList.nextElement();
	    message( "Processing file " + src );
	    try {
		FileInputStream in = new FileInputStream( src );
		deps.startFile( src );
	    
		if ( parser == null ) {
		    parser = new Java( in );
		    parser.setTable( deps );
		} else {
		    parser.ReInit( in );
		}

		parser.CompilationUnit();

	    } catch ( FileNotFoundException e ) {
		System.err.println( "Can not find file: " + src );
		noErrors = false;
	    } catch ( ParseException e ) {
		System.err.println( "Parse error in file " + src + ":" );
		System.err.println( e.getMessage() );
		noErrors = false;
	    }
	    System.runFinalization();
	    System.gc();
	}
	if ( noErrors ) {
	    message( "Successful parse; writing output" );
	    deps.dump( enableDebugging, emitComments, buildStubs,
		       buildCommand, headerBuildCommand,
		       classVariable );
            if( po.seenOption( 'o' ) ) {
                out.flush();
                out.close();
            }        
	} else {
	    System.err.println( "Errors encountered; no output" );
	}
    }
}
