/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.attribute.CodeException;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.AStore;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.Goto;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Jsr;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTry;
import jd.core.process.analyzer.instruction.bytecode.ComparisonInstructionAnalyzer;
import jd.core.process.analyzer.instruction.fast.UnexpectedInstructionException;
import jd.core.process.analyzer.instruction.fast.visitor.CheckLocalVariableUsedVisitor;
import jd.core.process.analyzer.instruction.fast.visitor.FastCompareInstructionVisitor;
import jd.core.process.analyzer.util.InstructionUtil;
import jd.core.util.IntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastCodeExceptionAnalyzer {
    public static List<FastCodeException> AggregateCodeExceptions(Method method, List<Instruction> list) {
        CodeException[] arrayOfCodeException = method.getCodeExceptions();
        if (arrayOfCodeException == null || arrayOfCodeException.length == 0) {
            return null;
        }
        ArrayList<FastAggregatedCodeException> fastAggregatedCodeExceptions = new ArrayList<FastAggregatedCodeException>(arrayOfCodeException.length);
        FastCodeExceptionAnalyzer.PopulateListOfFastAggregatedCodeException(method, list, fastAggregatedCodeExceptions);
        int length = fastAggregatedCodeExceptions.size();
        ArrayList<FastCodeException> fastCodeExceptions = new ArrayList<FastCodeException>(length);
        fastCodeExceptions.add(FastCodeExceptionAnalyzer.NewFastCodeException(list, (FastAggregatedCodeException)fastAggregatedCodeExceptions.get(0)));
        int i = 1;
        while (i < length) {
            FastAggregatedCodeException fastAggregatedCodeException = (FastAggregatedCodeException)fastAggregatedCodeExceptions.get(i);
            if (!FastCodeExceptionAnalyzer.UpdateFastCodeException(fastCodeExceptions, fastAggregatedCodeException)) {
                fastCodeExceptions.add(FastCodeExceptionAnalyzer.NewFastCodeException(list, fastAggregatedCodeException));
            }
            ++i;
        }
        Collections.sort(fastCodeExceptions);
        i = fastCodeExceptions.size() - 1;
        while (i >= 1) {
            FastCodeException fce1 = fastCodeExceptions.get(i);
            FastCodeException fce2 = fastCodeExceptions.get(i - 1);
            if (!(fce1.tryFromOffset != fce2.tryFromOffset || fce1.tryToOffset != fce2.tryToOffset || fce1.synchronizedFlag != fce2.synchronizedFlag || fce1.afterOffset != -1 && fce1.afterOffset <= fce2.maxOffset || fce2.afterOffset != -1 && fce2.afterOffset <= fce1.maxOffset)) {
                fce2.catches.addAll(fce1.catches);
                Collections.sort(fce2.catches);
                if (fce2.nbrFinally == 0) {
                    fce2.finallyFromOffset = fce1.finallyFromOffset;
                    fce2.nbrFinally = fce1.nbrFinally;
                }
                if (fce2.maxOffset < fce1.maxOffset) {
                    fce2.maxOffset = fce1.maxOffset;
                }
                if (fce2.afterOffset == -1 || fce1.afterOffset != -1 && fce1.afterOffset < fce2.afterOffset) {
                    fce2.afterOffset = fce1.afterOffset;
                }
                fastCodeExceptions.remove(i);
            }
            --i;
        }
        ArrayList<int[]> switchCaseOffsets = FastCodeExceptionAnalyzer.SearchSwitchCaseOffsets(list);
        int i2 = fastCodeExceptions.size() - 1;
        while (i2 >= 0) {
            FastCodeException fce = fastCodeExceptions.get(i2);
            FastCodeExceptionAnalyzer.DefineType(list, fce);
            if (fce.type == 0) {
                System.err.println("Undefined type catch");
            }
            FastCodeExceptionAnalyzer.ComputeAfterOffset(method, list, switchCaseOffsets, fastCodeExceptions, fce, i2);
            length = list.size();
            if (fce.afterOffset == -1 && length > 0) {
                Instruction lastInstruction = list.get(length - 1);
                fce.afterOffset = lastInstruction.offset;
                if (lastInstruction.opcode != 177 && lastInstruction.opcode != 273) {
                    ++fce.afterOffset;
                }
            }
            --i2;
        }
        Collections.sort(fastCodeExceptions);
        return fastCodeExceptions;
    }

    private static void PopulateListOfFastAggregatedCodeException(Method method, List<Instruction> list, List<FastAggregatedCodeException> fastAggregatedCodeExceptions) {
        int length = method.getCode().length;
        if (length == 0) {
            return;
        }
        FastAggregatedCodeException[] array = new FastAggregatedCodeException[length];
        CodeException[] arrayOfCodeException = method.getCodeExceptions();
        length = arrayOfCodeException.length;
        int i = 0;
        while (i < length) {
            FastAggregatedCodeException face;
            CodeException codeException = arrayOfCodeException[i];
            if (array[codeException.handler_pc] == null) {
                face = new FastAggregatedCodeException(i, codeException.start_pc, codeException.end_pc, codeException.handler_pc, codeException.catch_type);
                fastAggregatedCodeExceptions.add(face);
                array[codeException.handler_pc] = face;
            } else {
                face = array[codeException.handler_pc];
                if (face.catch_type == 0) {
                    ++face.nbrFinally;
                } else if (FastCodeExceptionAnalyzer.IsNotAlreadyStored(face, codeException.catch_type)) {
                    if (face.otherCatchTypes == null) {
                        face.otherCatchTypes = new int[length];
                    }
                    face.otherCatchTypes[i] = codeException.catch_type;
                }
            }
            ++i;
        }
        i = fastAggregatedCodeExceptions.size();
        while (i-- > 0) {
            FastAggregatedCodeException face = fastAggregatedCodeExceptions.get(i);
            if (face.catch_type != 0 || !FastCodeExceptionAnalyzer.IsASynchronizedBlock(list, face)) continue;
            face.synchronizedFlag = true;
        }
    }

    private static boolean IsNotAlreadyStored(FastAggregatedCodeException face, int catch_type) {
        if (face.catch_type == catch_type) {
            return false;
        }
        if (face.otherCatchTypes != null) {
            int i = face.otherCatchTypes.length;
            while (i-- > 0) {
                if (face.otherCatchTypes[i] != catch_type) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean IsASynchronizedBlock(List<Instruction> list, FastAggregatedCodeException face) {
        int varMonitorIndex;
        int index = InstructionUtil.getIndexForOffset(list, face.start_pc);
        if (index == -1) {
            return false;
        }
        if (list.get((int)index).opcode == 195) {
            return true;
        }
        if (index < 1) {
            return false;
        }
        Instruction instruction = list.get(index - 1);
        if (instruction.opcode != 194) {
            return false;
        }
        MonitorEnter monitorEnter = (MonitorEnter)instruction;
        switch (monitorEnter.objectref.opcode) {
            case 25: {
                if (index < 2) {
                    return false;
                }
                instruction = list.get(index - 2);
                if (instruction.opcode != 58) {
                    return false;
                }
                AStore astore = (AStore)instruction;
                varMonitorIndex = astore.index;
                break;
            }
            case 265: {
                AssignmentInstruction ai = (AssignmentInstruction)monitorEnter.objectref;
                if (ai.value1.opcode != 25) {
                    return false;
                }
                ALoad aload = (ALoad)ai.value1;
                varMonitorIndex = aload.index;
                break;
            }
            default: {
                return false;
            }
        }
        boolean checkMonitorExit = false;
        int length = list.size();
        index = InstructionUtil.getIndexForOffset(list, face.handler_pc);
        block8: while (index < length) {
            instruction = list.get(index++);
            switch (instruction.opcode) {
                case 195: {
                    checkMonitorExit = true;
                    MonitorExit monitorExit = (MonitorExit)instruction;
                    if (monitorExit.objectref.opcode != 25 || ((ALoad)monitorExit.objectref).index != varMonitorIndex) continue block8;
                    return true;
                }
                case 177: 
                case 191: 
                case 273: {
                    return false;
                }
            }
        }
        return !checkMonitorExit && index == length;
    }

    private static boolean UpdateFastCodeException(List<FastCodeException> fastCodeExceptions, FastAggregatedCodeException fastAggregatedCodeException) {
        int length = fastCodeExceptions.size();
        if (fastAggregatedCodeException.catch_type == 0) {
            FastCodeException fce;
            int i = 0;
            while (i < length) {
                fce = fastCodeExceptions.get(i);
                if (fce.finallyFromOffset == -1 && fastAggregatedCodeException.start_pc == fce.tryFromOffset && fastAggregatedCodeException.end_pc == fce.tryToOffset && fastAggregatedCodeException.handler_pc > fce.maxOffset && !fastAggregatedCodeException.synchronizedFlag && (fce.afterOffset == -1 || fastAggregatedCodeException.end_pc < fce.afterOffset && fastAggregatedCodeException.handler_pc < fce.afterOffset)) {
                    fce.maxOffset = fastAggregatedCodeException.handler_pc;
                    fce.finallyFromOffset = fastAggregatedCodeException.handler_pc;
                    fce.nbrFinally += fastAggregatedCodeException.nbrFinally;
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < length) {
                fce = fastCodeExceptions.get(i);
                if (fce.finallyFromOffset == -1 && fastAggregatedCodeException.start_pc == fce.tryFromOffset && fastAggregatedCodeException.end_pc >= fce.tryToOffset && fastAggregatedCodeException.handler_pc > fce.maxOffset && !fastAggregatedCodeException.synchronizedFlag && (fce.afterOffset == -1 || fastAggregatedCodeException.end_pc < fce.afterOffset && fastAggregatedCodeException.handler_pc < fce.afterOffset)) {
                    fce.maxOffset = fastAggregatedCodeException.handler_pc;
                    fce.finallyFromOffset = fastAggregatedCodeException.handler_pc;
                    fce.nbrFinally += fastAggregatedCodeException.nbrFinally;
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static FastCodeException NewFastCodeException(List<Instruction> list, FastAggregatedCodeException fastCodeException) {
        FastCodeException fce = new FastCodeException(fastCodeException.start_pc, fastCodeException.end_pc, fastCodeException.handler_pc, fastCodeException.synchronizedFlag);
        if (fastCodeException.catch_type == 0) {
            fce.finallyFromOffset = fastCodeException.handler_pc;
            fce.nbrFinally += fastCodeException.nbrFinally;
        } else {
            fce.catches.add(new FastCodeExceptionCatch(fastCodeException.catch_type, fastCodeException.otherCatchTypes, fastCodeException.handler_pc));
        }
        fce.afterOffset = FastCodeExceptionAnalyzer.SearchAfterOffset(list, fastCodeException.handler_pc);
        return fce;
    }

    private static int SearchAfterOffset(List<Instruction> list, int offset) {
        int index = InstructionUtil.getIndexForOffset(list, offset);
        if (index <= 0) {
            return offset;
        }
        Instruction i = list.get(--index);
        switch (i.opcode) {
            case 167: {
                int branch = ((Goto)i).branch;
                if (branch < 0) {
                    return -1;
                }
                int jumpOffset = i.offset + branch;
                index = InstructionUtil.getIndexForOffset(list, jumpOffset);
                if (index <= 0) {
                    return -1;
                }
                i = list.get(index);
                if (i.opcode != 168) {
                    return jumpOffset;
                }
                branch = ((Jsr)i).branch;
                if (branch > 0) {
                    return i.offset + branch;
                }
                return jumpOffset + 1;
            }
            case 169: {
                while (--index >= 3) {
                    if (list.get((int)index).opcode != 191 || list.get((int)(index - 1)).opcode != 168 || list.get((int)(index - 2)).opcode != 58 || list.get((int)(index - 3)).opcode != 167) continue;
                    Goto g = (Goto)list.get(index - 3);
                    return g.GetJumpOffset();
                }
                break;
            }
        }
        return -1;
    }

    private static ArrayList<int[]> SearchSwitchCaseOffsets(List<Instruction> list) {
        ArrayList<int[]> switchCaseOffsets = new ArrayList<int[]>();
        int i = list.size();
        while (i-- > 0) {
            Instruction instruction = list.get(i);
            switch (instruction.opcode) {
                case 170: 
                case 171: {
                    Switch s = (Switch)instruction;
                    int j = s.offsets.length;
                    int[] offsets = new int[j + 1];
                    offsets[j] = s.offset + s.defaultOffset;
                    while (j-- > 0) {
                        offsets[j] = s.offset + s.offsets[j];
                    }
                    Arrays.sort(offsets);
                    switchCaseOffsets.add(offsets);
                }
            }
        }
        return switchCaseOffsets;
    }

    private static void DefineType(List<Instruction> list, FastCodeException fastCodeException) {
        block0 : switch (fastCodeException.nbrFinally) {
            case 0: {
                fastCodeException.type = 1;
                break;
            }
            case 1: {
                if (fastCodeException.catches == null || fastCodeException.catches.size() == 0) {
                    int index = InstructionUtil.getIndexForOffset(list, fastCodeException.finallyFromOffset);
                    if (index < 0) {
                        return;
                    }
                    Instruction instruction = list.get(index - 1);
                    block4 : switch (instruction.opcode) {
                        case 167: {
                            if (FastCodeExceptionAnalyzer.TryBlockContainsJsr(list, fastCodeException)) {
                                fastCodeException.type = 2;
                                break;
                            }
                            switch (list.get((int)(index - 2)).opcode) {
                                case 195: {
                                    fastCodeException.type = 5;
                                    break block4;
                                }
                            }
                            int jumpOffset = ((Goto)instruction).GetJumpOffset();
                            instruction = InstructionUtil.getInstructionAt(list, jumpOffset);
                            if (instruction.opcode == 168) {
                                fastCodeException.type = 3;
                                break;
                            }
                            fastCodeException.type = 13;
                            break;
                        }
                        case 177: 
                        case 273: {
                            if (FastCodeExceptionAnalyzer.TryBlockContainsJsr(list, fastCodeException)) {
                                fastCodeException.type = 2;
                                break;
                            }
                            switch (list.get((int)(index - 2)).opcode) {
                                case 195: {
                                    fastCodeException.type = 5;
                                    break block4;
                                }
                            }
                            Instruction firstFinallyInstruction = list.get(index + 1);
                            int exceptionIndex = ((AStore)list.get((int)index)).index;
                            int lenght = list.size();
                            while (++index < lenght) {
                                instruction = list.get(index);
                                if (instruction.opcode != 191) continue;
                                AThrow athrow = (AThrow)instruction;
                                if (athrow.value.opcode == 25 && ((ALoad)athrow.value).index == exceptionIndex) break;
                            }
                            if (++index >= lenght) {
                                fastCodeException.type = 10;
                                break;
                            }
                            instruction = list.get(index);
                            fastCodeException.type = instruction.opcode != firstFinallyInstruction.opcode || firstFinallyInstruction.lineNumber == Instruction.UNKNOWN_LINE_NUMBER || firstFinallyInstruction.lineNumber != instruction.lineNumber ? 10 : 13;
                            break;
                        }
                        case 191: {
                            switch (list.get((int)(index + 1)).opcode) {
                                case 168: {
                                    fastCodeException.type = 4;
                                    break block4;
                                }
                            }
                            if (list.get((int)index).opcode == 195) {
                                fastCodeException.type = 2;
                                break;
                            }
                            fastCodeException.type = 11;
                            break;
                        }
                        case 169: {
                            fastCodeException.type = 6;
                        }
                    }
                    break;
                }
                int index = InstructionUtil.getIndexForOffset(list, fastCodeException.catches.get((int)0).fromOffset);
                if (index < 0) {
                    return;
                }
                Instruction instruction = list.get(--index);
                if (instruction.opcode == 167) {
                    Goto g = (Goto)instruction;
                    instruction = list.get(--index);
                    if (instruction.opcode == 168) {
                        fastCodeException.type = 9;
                        break;
                    }
                    index = InstructionUtil.getIndexForOffset(list, g.GetJumpOffset());
                    instruction = list.get(index);
                    if (instruction.opcode == 168) {
                        fastCodeException.type = 7;
                        break;
                    }
                    instruction = list.get(index - 1);
                    if (instruction.opcode == 191) {
                        fastCodeException.type = 14;
                        break;
                    }
                    fastCodeException.type = 8;
                    break;
                }
                if (instruction.opcode == 169) {
                    fastCodeException.type = 7;
                    break;
                }
                instruction = list.get(--index);
                if (instruction.opcode != 168) break;
                fastCodeException.type = 9;
                break;
            }
            default: {
                int branch;
                int index;
                if (fastCodeException.catches == null || fastCodeException.catches.size() == 0) {
                    int index2 = InstructionUtil.getIndexForOffset(list, fastCodeException.tryToOffset);
                    if (index2 < 0) {
                        return;
                    }
                    Instruction instruction = list.get(index2);
                    switch (instruction.opcode) {
                        case 168: {
                            fastCodeException.type = 9;
                            break block0;
                        }
                        case 191: {
                            fastCodeException.type = 12;
                            break block0;
                        }
                        case 167: {
                            Goto g = (Goto)instruction;
                            instruction = InstructionUtil.getInstructionAt(list, g.GetJumpOffset());
                            if (instruction == null) {
                                return;
                            }
                            if (instruction.opcode == 168 && ((Jsr)instruction).branch < 0) {
                                fastCodeException.type = 12;
                                break block0;
                            }
                            if (index2 > 0 && list.get((int)(index2 - 1)).opcode == 168) {
                                fastCodeException.type = 9;
                                break block0;
                            }
                            fastCodeException.type = 10;
                            break block0;
                        }
                        case 87: {
                            FastCodeExceptionAnalyzer.DefineTypeJikes122Or142(list, fastCodeException, ((Pop)instruction).objectref, index2);
                            break block0;
                        }
                        case 58: {
                            FastCodeExceptionAnalyzer.DefineTypeJikes122Or142(list, fastCodeException, ((AStore)instruction).valueref, index2);
                            break block0;
                        }
                        case 177: 
                        case 273: {
                            if (index2 > 0 && list.get((int)(index2 - 1)).opcode == 168) {
                                fastCodeException.type = 9;
                                break block0;
                            }
                            fastCodeException.type = 10;
                            break block0;
                        }
                    }
                    fastCodeException.type = 10;
                    break;
                }
                boolean uniqueJumpAddressFlag = true;
                int uniqueJumpAddress = -1;
                if (fastCodeException.catches != null) {
                    int i = fastCodeException.catches.size() - 1;
                    while (i >= 0) {
                        FastCodeExceptionCatch fcec = fastCodeException.catches.get(i);
                        int index3 = InstructionUtil.getIndexForOffset(list, fcec.fromOffset);
                        if (index3 != -1) {
                            int branch2;
                            Instruction instruction = list.get(index3 - 1);
                            if (instruction.opcode == 167 && (branch2 = ((Goto)instruction).branch) > 0) {
                                int jumpAddress = instruction.offset + branch2;
                                if (uniqueJumpAddress == -1) {
                                    uniqueJumpAddress = jumpAddress;
                                } else if (uniqueJumpAddress != jumpAddress) {
                                    uniqueJumpAddressFlag = false;
                                    break;
                                }
                            }
                        }
                        --i;
                    }
                }
                if ((index = InstructionUtil.getIndexForOffset(list, fastCodeException.finallyFromOffset)) < 0) {
                    return;
                }
                Instruction instruction = list.get(--index);
                if (uniqueJumpAddressFlag && instruction.opcode == 167 && (branch = ((Goto)instruction).branch) > 0) {
                    int jumpAddress = instruction.offset + branch;
                    if (uniqueJumpAddress == -1) {
                        uniqueJumpAddress = jumpAddress;
                    } else if (uniqueJumpAddress != jumpAddress) {
                        uniqueJumpAddressFlag = false;
                    }
                }
                if (!uniqueJumpAddressFlag) {
                    fastCodeException.type = 14;
                    return;
                }
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.tryToOffset);
                if (index < 0) {
                    return;
                }
                instruction = list.get(index);
                switch (instruction.opcode) {
                    case 168: {
                        fastCodeException.type = 9;
                        break block0;
                    }
                    case 191: {
                        fastCodeException.type = 12;
                        break block0;
                    }
                    case 167: {
                        Goto g = (Goto)instruction;
                        instruction = InstructionUtil.getInstructionAt(list, g.GetJumpOffset());
                        if (instruction == null) {
                            return;
                        }
                        if (instruction.opcode == 168 && ((Jsr)instruction).branch < 0) {
                            fastCodeException.type = 12;
                            break block0;
                        }
                        if (index > 0 && list.get((int)(index - 1)).opcode == 168) {
                            fastCodeException.type = 9;
                            break block0;
                        }
                        fastCodeException.type = 10;
                        break block0;
                    }
                    case 87: {
                        FastCodeExceptionAnalyzer.DefineTypeJikes122Or142(list, fastCodeException, ((Pop)instruction).objectref, index);
                        break block0;
                    }
                    case 58: {
                        FastCodeExceptionAnalyzer.DefineTypeJikes122Or142(list, fastCodeException, ((AStore)instruction).valueref, index);
                        break block0;
                    }
                    case 177: 
                    case 273: {
                        instruction = InstructionUtil.getInstructionAt(list, uniqueJumpAddress);
                        if (instruction != null && instruction.opcode == 168 && ((Jsr)instruction).branch < 0) {
                            fastCodeException.type = 12;
                            break block0;
                        }
                        if (index > 0 && list.get((int)(index - 1)).opcode == 168) {
                            fastCodeException.type = 9;
                            break block0;
                        }
                        fastCodeException.type = 10;
                        break block0;
                    }
                }
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.finallyFromOffset);
                Instruction firstFinallyInstruction = list.get(index + 1);
                if (firstFinallyInstruction.opcode != 58) {
                    fastCodeException.type = 10;
                    break;
                }
                int exceptionIndex = ((AStore)list.get((int)index)).index;
                int lenght = list.size();
                while (++index < lenght) {
                    instruction = list.get(index);
                    if (instruction.opcode != 191) continue;
                    AThrow athrow = (AThrow)instruction;
                    if (athrow.value.opcode == 25 && ((ALoad)athrow.value).index == exceptionIndex) break;
                }
                if (++index >= lenght) {
                    fastCodeException.type = 10;
                    break;
                }
                instruction = list.get(index);
                fastCodeException.type = instruction.opcode != firstFinallyInstruction.opcode || firstFinallyInstruction.lineNumber == Instruction.UNKNOWN_LINE_NUMBER || firstFinallyInstruction.lineNumber != instruction.lineNumber ? 10 : 14;
            }
        }
    }

    private static boolean TryBlockContainsJsr(List<Instruction> list, FastCodeException fastCodeException) {
        int index = InstructionUtil.getIndexForOffset(list, fastCodeException.tryToOffset);
        if (index != -1) {
            int tryFromOffset = fastCodeException.tryFromOffset;
            while (true) {
                Instruction instruction = list.get(index);
                if (instruction.offset <= tryFromOffset) break;
                if (instruction.opcode == 168 && ((Jsr)instruction).GetJumpOffset() > fastCodeException.finallyFromOffset) {
                    return true;
                }
                if (index == 0) break;
                --index;
            }
        }
        return false;
    }

    private static void DefineTypeJikes122Or142(List<Instruction> list, FastCodeException fastCodeException, Instruction instruction, int index) {
        if (instruction.opcode == 270) {
            int jumpAddress;
            instruction = list.get(--index);
            if (instruction.opcode == 167 && (instruction = InstructionUtil.getInstructionAt(list, jumpAddress = ((Goto)instruction).GetJumpOffset())) != null && instruction.opcode == 168) {
                fastCodeException.type = 12;
                return;
            }
        }
        fastCodeException.type = 10;
    }

    /*
     * Unable to fully structure code
     */
    private static void ComputeAfterOffset(Method method, List<Instruction> list, ArrayList<int[]> switchCaseOffsets, ArrayList<FastCodeException> fastCodeExceptions, FastCodeException fastCodeException, int fastCodeExceptionIndex) {
        block0 : switch (fastCodeException.type) {
            case 7: {
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.afterOffset);
                if (index < 0 || index >= list.size()) {
                    return;
                }
                length = list.size();
                offsetSet = new IntSet();
                retCounter = 0;
                while (++index < length) {
                    i = list.get(index);
                    switch (i.opcode) {
                        case 168: {
                            offsetSet.add(((Jsr)i).GetJumpOffset());
                            break;
                        }
                        case 169: {
                            if (offsetSet.size() == retCounter) {
                                fastCodeException.afterOffset = i.offset + 1;
                                return;
                            }
                            ++retCounter;
                        }
                    }
                }
                break;
            }
            case 8: {
                instruction = InstructionUtil.getInstructionAt(list, fastCodeException.afterOffset);
                if (instruction == null) {
                    return;
                }
                fastCodeException.afterOffset = instruction.offset + 1;
                break;
            }
            case 3: {
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.afterOffset);
                if (index < 0 || index >= list.size()) {
                    return;
                }
                i = list.get(++index);
                if (i.opcode != 167) {
                    return;
                }
                fastCodeException.afterOffset = ((Goto)i).GetJumpOffset();
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.finallyFromOffset);
                if (index < 0) {
                    return;
                }
                lenght = list.size();
                instruction = list.get(index);
                block14 : switch (instruction.opcode) {
                    case 87: {
                        while (++index < lenght) {
                            instruction = list.get(index);
                            if (instruction.opcode != 191) continue;
                            fastCodeException.afterOffset = instruction.offset + 1;
                            break block14;
                        }
                        break block0;
                    }
                    case 58: {
                        finallyStartIndex = index + 1;
                        exceptionIndex = ((AStore)instruction).index;
                        while (++index < lenght) {
                            instruction = list.get(index);
                            if (instruction.opcode != 191) continue;
                            athrow = (AThrow)instruction;
                            if (athrow.value.opcode == 25 && ((ALoad)athrow.value).index == exceptionIndex) break;
                        }
                        if ((index += index - finallyStartIndex + 1) >= lenght) break block0;
                        fastCodeException.afterOffset = list.get((int)index).offset;
                    }
                }
                break;
            }
            case 14: {
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.finallyFromOffset);
                if (index < 0) {
                    return;
                }
                instruction = list.get(index);
                if (instruction.opcode != 58) {
                    return;
                }
                finallyStartIndex = index + 1;
                exceptionIndex = ((AStore)instruction).index;
                lenght = list.size();
                while (++index < lenght) {
                    instruction = list.get(index);
                    if (instruction.opcode != 191) continue;
                    athrow = (AThrow)instruction;
                    if (athrow.value.opcode == 25 && ((ALoad)athrow.value).index == exceptionIndex) break;
                }
                delta = index - finallyStartIndex;
                afterOffset = list.get((int)(index += delta + 1)).offset;
                if (index < lenght && list.get((int)index).opcode == 167) {
                    g = (Goto)list.get(index);
                    jumpOffset = g.GetJumpOffset();
                    indexTmp = index + delta + 1;
                    if (indexTmp < lenght && list.get((int)(indexTmp - 1)).offset < jumpOffset && jumpOffset <= list.get((int)indexTmp).offset) {
                        afterOffset = FastCodeExceptionAnalyzer.ReduceAfterOffsetWithBranchInstructions(list, fastCodeException, fastCodeException.finallyFromOffset, list.get((int)indexTmp).offset);
                        if (!fastCodeException.synchronizedFlag) {
                            afterOffset = FastCodeExceptionAnalyzer.ReduceAfterOffsetWithLineNumbers(list, fastCodeException, afterOffset);
                        }
                        afterOffset = FastCodeExceptionAnalyzer.ReduceAfterOffsetWithExceptions(fastCodeExceptions, fastCodeException.tryFromOffset, fastCodeException.finallyFromOffset, afterOffset);
                    }
                }
                fastCodeException.afterOffset = afterOffset;
                break;
            }
            case 2: {
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.finallyFromOffset);
                if (index <= 0) {
                    return;
                }
                length = list.size();
                offsetOfJsrsLength = list.get((int)(length - 1)).offset + 1;
                offsetOfJsrs = new boolean[offsetOfJsrsLength];
                level = 0;
                while (++index < length) {
                    i = list.get(index);
                    if (offsetOfJsrs[i.offset]) {
                        ++level;
                    }
                    if (i.opcode == 168) {
                        jumpOffset = ((Jsr)i).GetJumpOffset();
                        if (jumpOffset >= offsetOfJsrsLength) continue;
                        offsetOfJsrs[jumpOffset] = true;
                        continue;
                    }
                    if (i.opcode != 169) continue;
                    if (level <= 1) {
                        fastCodeException.afterOffset = i.offset + 1;
                        break block0;
                    }
                    --level;
                }
                break;
            }
            case 4: 
            case 9: {
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.finallyFromOffset);
                if (index <= 0) {
                    return;
                }
                length = list.size();
                while (++index < length) {
                    i = list.get(index);
                    if (i.opcode != 169) continue;
                    fastCodeException.afterOffset = ++index < length ? list.get((int)index).offset : i.offset + 1;
                    break block0;
                }
                break;
            }
            default: {
                length = list.size();
                afterOffset = fastCodeException.afterOffset;
                if (afterOffset == -1) {
                    afterOffset = list.get((int)(length - 1)).offset + 1;
                }
                afterOffset = FastCodeExceptionAnalyzer.ReduceAfterOffsetWithBranchInstructions(list, fastCodeException, fastCodeException.maxOffset, afterOffset);
                if (!fastCodeException.synchronizedFlag) {
                    afterOffset = FastCodeExceptionAnalyzer.ReduceAfterOffsetWithLineNumbers(list, fastCodeException, afterOffset);
                }
                afterOffset = FastCodeExceptionAnalyzer.ReduceAfterOffsetWithSwitchInstructions(switchCaseOffsets, fastCodeException.tryFromOffset, fastCodeException.maxOffset, afterOffset);
                fastCodeException.afterOffset = afterOffset = FastCodeExceptionAnalyzer.ReduceAfterOffsetWithExceptions(fastCodeExceptions, fastCodeException.tryFromOffset, fastCodeException.maxOffset, afterOffset);
                tryFromOffset = 0x7FFFFFFF;
                tryIndex = fastCodeExceptionIndex + 1;
                while (tryIndex < fastCodeExceptions.size()) {
                    tryFromOffsetTmp = fastCodeExceptions.get((int)tryIndex).tryFromOffset;
                    if (tryFromOffsetTmp > fastCodeException.maxOffset) {
                        tryFromOffset = tryFromOffsetTmp;
                        break;
                    }
                    ++tryIndex;
                }
                index = maxIndex = InstructionUtil.getIndexForOffset(list, fastCodeException.maxOffset);
                while (index < length) {
                    instruction = list.get(index);
                    if (instruction.offset >= afterOffset) break block0;
                    if (instruction.offset <= tryFromOffset) ** GOTO lbl171
                    fce = fastCodeExceptions.get(tryIndex);
                    afterOffsetTmp = fce.afterOffset;
                    while (true) {
                        if (++tryIndex < fastCodeExceptions.size()) ** GOTO lbl159
                        tryFromOffset = 0x7FFFFFFF;
                        ** GOTO lbl169
lbl159:
                        // 1 sources

                        tryFromOffsetTmp = fastCodeExceptions.get((int)tryIndex).tryFromOffset;
                        if (fce.tryFromOffset == tryFromOffsetTmp) ** GOTO lbl163
                        tryFromOffset = tryFromOffsetTmp;
                        if (true) ** GOTO lbl169
lbl163:
                        // 1 sources

                        fceTmp = fastCodeExceptions.get(tryIndex);
                        if (afterOffsetTmp >= fceTmp.afterOffset) continue;
                        afterOffsetTmp = fceTmp.afterOffset;
                    }
                    do {
                        ++index;
lbl169:
                        // 3 sources

                    } while (index < length && list.get((int)index).offset < afterOffsetTmp);
                    continue;
lbl171:
                    // 1 sources

                    block18 : switch (instruction.opcode) {
                        case 177: 
                        case 191: 
                        case 273: {
                            if (CheckLocalVariableUsedVisitor.Visit(method.getLocalVariables(), fastCodeException.maxOffset, instruction)) {
                                fastCodeException.afterOffset = instruction.offset + 1;
                            } else if (FastCodeExceptionAnalyzer.CheckTernaryOperator(list, index)) {
                                fastCodeException.afterOffset = instruction.offset + 1;
                            } else if (index + 1 >= length) {
                                fastCodeException.afterOffset = instruction.opcode == 191 ? instruction.offset + 1 : instruction.offset;
                            } else {
                                tryFromIndex = InstructionUtil.getIndexForOffset(list, fastCodeException.tryFromOffset);
                                beforeInstructionOffset = index == 0 ? 0 : list.get((int)(index - 1)).offset;
                                fastCodeException.afterOffset = InstructionUtil.CheckNoJumpToInterval(list, tryFromIndex, maxIndex, beforeInstructionOffset, instruction.offset) != false ? instruction.offset + 1 : instruction.offset;
                            }
                            return;
                        }
                        case 167: 
                        case 260: 
                        case 261: 
                        case 262: {
                            if (instruction.opcode == 167) {
                                jumpOffsetTmp = ((BranchInstruction)instruction).GetJumpOffset();
                            } else {
                                index = ComparisonInstructionAnalyzer.GetLastIndex(list, index);
                                lastBi = (BranchInstruction)list.get(index);
                                jumpOffsetTmp = lastBi.GetJumpOffset();
                            }
                            if (jumpOffsetTmp > instruction.offset) {
                                if (jumpOffsetTmp < afterOffset) {
                                    while (++index < length) {
                                        if (list.get((int)index).offset < jumpOffsetTmp) continue;
                                        --index;
                                        break block18;
                                    }
                                    break;
                                }
                                if (instruction.opcode == 167 || jumpOffsetTmp != afterOffset) {
                                    tryFromIndex = InstructionUtil.getIndexForOffset(list, fastCodeException.tryFromOffset);
                                    beforeInstructionOffset = index == 0 ? 0 : list.get((int)(index - 1)).offset;
                                    fastCodeException.afterOffset = InstructionUtil.CheckNoJumpToInterval(list, tryFromIndex, maxIndex, beforeInstructionOffset, instruction.offset) != false ? instruction.offset + 1 : instruction.offset;
                                }
                                return;
                            }
                            if (jumpOffsetTmp > fastCodeException.tryFromOffset) break;
                            if (index > 0 && instruction.lineNumber != Instruction.UNKNOWN_LINE_NUMBER) {
                                beforeInstruction = list.get(index - 1);
                                if (instruction.lineNumber == beforeInstruction.lineNumber) {
                                    fastCodeException.afterOffset = beforeInstruction.opcode == 58 && ((AStore)beforeInstruction).valueref.opcode == 270 ? instruction.offset : (beforeInstruction.opcode == 87 && ((Pop)beforeInstruction).objectref.opcode == 270 ? instruction.offset : beforeInstruction.offset);
                                    return;
                                }
                            }
                            fastCodeException.afterOffset = instruction.offset;
                            return;
                        }
                        case 170: 
                        case 171: {
                            s = (Switch)instruction;
                            maxOffset = s.defaultOffset;
                            i = s.offsets.length;
                            while (i-- > 0) {
                                offset = s.offsets[i];
                                if (maxOffset >= offset) continue;
                                maxOffset = offset;
                            }
                            if (maxOffset >= afterOffset) break;
                            while (++index < length) {
                                if (list.get((int)index).offset < maxOffset) continue;
                                --index;
                                break block18;
                            }
                            break;
                        }
                    }
                    ++index;
                }
                break block0;
            }
        }
    }

    private static boolean CheckTernaryOperator(List<Instruction> list, int index) {
        if (index > 2 && list.get((int)(index - 1)).opcode == 167 && list.get((int)(index - 2)).opcode == 280) {
            Goto g = (Goto)list.get(index - 1);
            int jumpOffset = g.GetJumpOffset();
            int returnOffset = list.get((int)index).offset;
            if (g.offset < jumpOffset && jumpOffset < returnOffset) {
                return true;
            }
        }
        return false;
    }

    private static int ReduceAfterOffsetWithBranchInstructions(List<Instruction> list, FastCodeException fastCodeException, int firstOffset, int afterOffset) {
        int jumpOffset;
        Instruction instruction;
        int index = InstructionUtil.getIndexForOffset(list, fastCodeException.tryFromOffset);
        if (index != -1) {
            block6: while (index-- > 0) {
                instruction = list.get(index);
                switch (instruction.opcode) {
                    case 167: 
                    case 260: 
                    case 261: 
                    case 262: {
                        jumpOffset = ((BranchInstruction)instruction).GetJumpOffset();
                        if (firstOffset >= jumpOffset || jumpOffset >= afterOffset) continue block6;
                        afterOffset = jumpOffset;
                    }
                }
            }
        }
        index = list.size();
        block7: do {
            instruction = list.get(--index);
            switch (instruction.opcode) {
                case 167: 
                case 260: 
                case 261: 
                case 262: {
                    jumpOffset = ((BranchInstruction)instruction).GetJumpOffset();
                    if (firstOffset >= jumpOffset || jumpOffset >= afterOffset) continue block7;
                    afterOffset = jumpOffset;
                }
            }
        } while (instruction.offset > afterOffset);
        return afterOffset;
    }

    private static int ReduceAfterOffsetWithLineNumbers(List<Instruction> list, FastCodeException fastCodeException, int afterOffset) {
        int fromIndex = InstructionUtil.getIndexForOffset(list, fastCodeException.tryFromOffset);
        int index = fromIndex;
        if (index != -1) {
            Instruction instruction;
            int lenght = list.size();
            int firstLineNumber = Instruction.UNKNOWN_LINE_NUMBER;
            do {
                instruction = list.get(index++);
                if (instruction.lineNumber == Instruction.UNKNOWN_LINE_NUMBER) continue;
                firstLineNumber = instruction.lineNumber;
                break;
            } while (instruction.offset < afterOffset && index < lenght);
            if (firstLineNumber != Instruction.UNKNOWN_LINE_NUMBER) {
                int maxOffset = fastCodeException.maxOffset;
                index = InstructionUtil.getIndexForOffset(list, afterOffset);
                if (index != -1) {
                    while (index-- > 0) {
                        int jumpOffset;
                        instruction = list.get(index);
                        if (instruction.offset <= maxOffset || instruction.lineNumber != Instruction.UNKNOWN_LINE_NUMBER && instruction.lineNumber >= firstLineNumber || instruction.opcode == 167 && !InstructionUtil.CheckNoJumpToInterval(list, fromIndex, index, (jumpOffset = ((Goto)instruction).GetJumpOffset()) - 1, jumpOffset)) break;
                        if (instruction.opcode == 177) {
                            int maxIndex = InstructionUtil.getIndexForOffset(list, maxOffset);
                            if (list.get((int)(maxIndex - 1)).opcode == instruction.opcode) break;
                        }
                        afterOffset = instruction.offset;
                    }
                }
            }
        }
        return afterOffset;
    }

    private static int ReduceAfterOffsetWithSwitchInstructions(ArrayList<int[]> switchCaseOffsets, int firstOffset, int lastOffset, int afterOffset) {
        int i = switchCaseOffsets.size();
        while (i-- > 0) {
            int[] offsets = switchCaseOffsets.get(i);
            int j = offsets.length;
            if (j <= 1) continue;
            int offset2 = offsets[--j];
            while (j-- > 0) {
                int offset1 = offsets[j];
                if (offset1 != -1 && offset1 <= firstOffset && lastOffset < offset2 && (afterOffset == -1 || afterOffset > offset2)) {
                    afterOffset = offset2;
                }
                offset2 = offset1;
            }
        }
        return afterOffset;
    }

    private static int ReduceAfterOffsetWithExceptions(ArrayList<FastCodeException> fastCodeExceptions, int fromOffset, int maxOffset, int afterOffset) {
        int i = fastCodeExceptions.size();
        while (i-- > 0) {
            FastCodeException fastCodeException = fastCodeExceptions.get(i);
            int toOffset = fastCodeException.finallyFromOffset;
            if (fastCodeException.catches != null) {
                int j = fastCodeException.catches.size();
                while (j-- > 0) {
                    FastCodeExceptionCatch fcec = fastCodeException.catches.get(j);
                    if (toOffset != -1 && fcec.fromOffset <= fromOffset && maxOffset < toOffset && (afterOffset == -1 || afterOffset > toOffset)) {
                        afterOffset = toOffset;
                    }
                    toOffset = fcec.fromOffset;
                }
            }
            if (fastCodeException.tryFromOffset > fromOffset || maxOffset >= toOffset || afterOffset != -1 && afterOffset <= toOffset) continue;
            afterOffset = toOffset;
        }
        return afterOffset;
    }

    public static void FormatFastTry(LocalVariables localVariables, FastCodeException fce, FastTry fastTry, int returnOffset) {
        switch (fce.type) {
            case 1: {
                FastCodeExceptionAnalyzer.FormatCatch(localVariables, fce, fastTry);
                break;
            }
            case 2: {
                FastCodeExceptionAnalyzer.Format118Finally(localVariables, fce, fastTry);
                break;
            }
            case 3: {
                FastCodeExceptionAnalyzer.Format118Finally2(fce, fastTry);
                break;
            }
            case 4: {
                FastCodeExceptionAnalyzer.Format118FinallyThrow(fastTry);
                break;
            }
            case 7: {
                FastCodeExceptionAnalyzer.Format118CatchFinally(fce, fastTry);
                break;
            }
            case 8: {
                FastCodeExceptionAnalyzer.Format118CatchFinally2(fce, fastTry);
                break;
            }
            case 9: {
                FastCodeExceptionAnalyzer.Format131CatchFinally(localVariables, fce, fastTry);
                break;
            }
            case 10: {
                FastCodeExceptionAnalyzer.Format142(localVariables, fce, fastTry);
                break;
            }
            case 11: {
                FastCodeExceptionAnalyzer.Format142FinallyThrow(fastTry);
                break;
            }
            case 12: {
                FastCodeExceptionAnalyzer.FormatJikes122(localVariables, fce, fastTry, returnOffset);
                break;
            }
            case 13: {
                FastCodeExceptionAnalyzer.FormatEclipse677Finally(fce, fastTry);
                break;
            }
            case 14: {
                FastCodeExceptionAnalyzer.FormatEclipse677CatchFinally(fce, fastTry, returnOffset);
            }
        }
    }

    private static void FormatCatch(LocalVariables localVariables, FastCodeException fce, FastTry fastTry) {
        List tryInstructions = fastTry.instructions;
        int jumpOffset = -1;
        if (tryInstructions.size() > 0) {
            int tmpJumpOffset;
            int lastIndex = tryInstructions.size() - 1;
            Instruction instruction = (Instruction)tryInstructions.get(lastIndex);
            if (instruction.opcode == 167 && ((tmpJumpOffset = ((Goto)instruction).GetJumpOffset()) < fce.tryFromOffset || instruction.offset < tmpJumpOffset)) {
                jumpOffset = tmpJumpOffset;
                fce.tryToOffset = instruction.offset;
                tryInstructions.remove(lastIndex);
            }
        }
        FastCodeExceptionAnalyzer.FormatFastTry_RemoveJsrInstructionAndCompactStoreReturn(tryInstructions, localVariables, Instruction.UNKNOWN_LINE_NUMBER);
        int i = fastTry.catches.size();
        while (i-- > 0) {
            int tmpJumpOffset;
            List<Instruction> catchInstructions = fastTry.catches.get((int)i).instructions;
            if (FastCodeExceptionAnalyzer.FormatCatch_RemoveFirstCatchInstruction(catchInstructions.get(0))) {
                catchInstructions.remove(0);
            }
            if (catchInstructions.size() <= 0) continue;
            int lastIndex = catchInstructions.size() - 1;
            Instruction instruction = catchInstructions.get(lastIndex);
            if (instruction.opcode == 167 && ((tmpJumpOffset = ((Goto)instruction).GetJumpOffset()) < fce.tryFromOffset || instruction.offset < tmpJumpOffset)) {
                if (jumpOffset == -1) {
                    jumpOffset = tmpJumpOffset;
                    fce.catches.get((int)i).toOffset = instruction.offset;
                    catchInstructions.remove(lastIndex);
                } else if (jumpOffset == tmpJumpOffset) {
                    fce.catches.get((int)i).toOffset = instruction.offset;
                    catchInstructions.remove(lastIndex);
                }
            }
            FastCodeExceptionAnalyzer.FormatFastTry_RemoveJsrInstructionAndCompactStoreReturn(catchInstructions, localVariables, Instruction.UNKNOWN_LINE_NUMBER);
        }
    }

    private static boolean FormatCatch_RemoveFirstCatchInstruction(Instruction instruction) {
        switch (instruction.opcode) {
            case 87: {
                return ((Pop)instruction).objectref.opcode == 270;
            }
            case 58: {
                return ((AStore)instruction).valueref.opcode == 270;
            }
        }
        return false;
    }

    private static void Format118Finally(LocalVariables localVariables, FastCodeException fce, FastTry fastTry) {
        List tryInstructions = fastTry.instructions;
        int length = tryInstructions.size();
        if (((Instruction)tryInstructions.get((int)(--length))).opcode == 167) {
            Goto g = (Goto)tryInstructions.remove(length);
            fce.tryToOffset = g.offset;
        }
        if (((Instruction)tryInstructions.get((int)(--length))).opcode != 168) {
            throw new UnexpectedInstructionException();
        }
        tryInstructions.remove(length);
        int finallyInstructitonsLineNumber = fastTry.finallyInstructions.get((int)0).lineNumber;
        FastCodeExceptionAnalyzer.FormatFastTry_RemoveJsrInstructionAndCompactStoreReturn(tryInstructions, localVariables, finallyInstructitonsLineNumber);
        FastCodeExceptionAnalyzer.Format118FinallyThrow(fastTry);
    }

    private static void Format118Finally2(FastCodeException fce, FastTry fastTry) {
        List<Instruction> finallyInstructions;
        int finallyInstructionsLength;
        List tryInstructions = fastTry.instructions;
        int tryInstructionsLength = tryInstructions.size();
        if (((Instruction)tryInstructions.get((int)(tryInstructionsLength - 1))).opcode == 167) {
            Goto g = (Goto)tryInstructions.remove(--tryInstructionsLength);
            fce.tryToOffset = g.offset;
        }
        if ((finallyInstructionsLength = (finallyInstructions = fastTry.finallyInstructions).size()) > 5) {
            int firstFinallyOffset = finallyInstructions.get((int)0).offset;
            int lastFinallyOffset = finallyInstructions.get((int)5).offset;
            block6: while (tryInstructionsLength-- > 0) {
                Instruction instruction = (Instruction)tryInstructions.get(tryInstructionsLength);
                switch (instruction.opcode) {
                    case 261: {
                        int jumpOffset = ((IfCmp)instruction).GetJumpOffset();
                        if (firstFinallyOffset >= jumpOffset || jumpOffset > lastFinallyOffset) continue block6;
                        ((IfCmp)instruction).branch = firstFinallyOffset - instruction.offset;
                        break;
                    }
                    case 260: 
                    case 262: {
                        int jumpOffset = ((IfInstruction)instruction).GetJumpOffset();
                        if (firstFinallyOffset >= jumpOffset || jumpOffset > lastFinallyOffset) continue block6;
                        ((IfInstruction)instruction).branch = firstFinallyOffset - instruction.offset;
                        break;
                    }
                    case 284: {
                        int jumpOffset = ((BranchInstruction)instruction).GetJumpOffset();
                        if (firstFinallyOffset >= jumpOffset || jumpOffset > lastFinallyOffset) continue block6;
                        ((ComplexConditionalBranchInstruction)instruction).branch = firstFinallyOffset - instruction.offset;
                        break;
                    }
                    case 167: {
                        int jumpOffset = ((Goto)instruction).GetJumpOffset();
                        if (firstFinallyOffset >= jumpOffset || jumpOffset > lastFinallyOffset) continue block6;
                        ((Goto)instruction).branch = firstFinallyOffset - instruction.offset;
                    }
                }
            }
        }
        finallyInstructions.remove(finallyInstructionsLength - 1);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
    }

    private static void Format118FinallyThrow(FastTry fastTry) {
        List<Instruction> finallyInstructions = fastTry.finallyInstructions;
        int length = finallyInstructions.size();
        Instruction i = finallyInstructions.get(--length);
        if (i.opcode != 169) {
            throw new UnexpectedInstructionException();
        }
        finallyInstructions.remove(length);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
    }

    private static void Format118CatchFinally(FastCodeException fce, FastTry fastTry) {
        int i;
        List tryInstructions = fastTry.instructions;
        int tryInstructionsLength = tryInstructions.size();
        if (((Instruction)tryInstructions.get((int)(--tryInstructionsLength))).opcode == 167) {
            Goto g = (Goto)tryInstructions.remove(tryInstructionsLength);
            fce.tryToOffset = g.offset;
        }
        if ((i = fastTry.catches.size() - 1) >= 0) {
            List<Instruction> catchInstructions = fastTry.catches.get((int)i).instructions;
            int catchInstructionsLength = catchInstructions.size();
            switch (catchInstructions.get((int)(--catchInstructionsLength)).opcode) {
                case 167: {
                    catchInstructions.remove(catchInstructionsLength);
                    catchInstructions.remove(--catchInstructionsLength);
                    break;
                }
                case 177: 
                case 273: {
                    catchInstructions.remove(--catchInstructionsLength);
                    if (catchInstructionsLength <= 0 || catchInstructions.get((int)(catchInstructionsLength - 1)).opcode != 191) break;
                    catchInstructions.remove(catchInstructionsLength);
                }
            }
            catchInstructions.remove(0);
            while (i-- > 0) {
                catchInstructions = fastTry.catches.get((int)i).instructions;
                catchInstructionsLength = catchInstructions.size();
                switch (catchInstructions.get((int)(--catchInstructionsLength)).opcode) {
                    case 167: {
                        Instruction in = catchInstructions.remove(catchInstructionsLength);
                        fce.catches.get((int)i).toOffset = in.offset;
                        break;
                    }
                    case 177: 
                    case 273: {
                        catchInstructions.remove(--catchInstructionsLength);
                    }
                }
                catchInstructions.remove(0);
            }
        }
        List<Instruction> finallyInstructions = fastTry.finallyInstructions;
        int finallyInstructionsLength = finallyInstructions.size();
        finallyInstructions.remove(--finallyInstructionsLength);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
    }

    private static void Format118CatchFinally2(FastCodeException fce, FastTry fastTry) {
        List tryInstructions = fastTry.instructions;
        int tryInstructionsLength = tryInstructions.size();
        if (((Instruction)tryInstructions.get((int)(--tryInstructionsLength))).opcode == 167) {
            Goto g = (Goto)tryInstructions.remove(tryInstructionsLength);
            fce.tryToOffset = g.offset;
        }
        int i = fastTry.catches.size();
        while (i-- > 0) {
            List<Instruction> catchInstructions = fastTry.catches.get((int)i).instructions;
            int catchInstructionsLength = catchInstructions.size();
            Instruction in = catchInstructions.remove(catchInstructionsLength - 1);
            fce.catches.get((int)i).toOffset = in.offset;
            catchInstructions.remove(0);
        }
        List<Instruction> finallyInstructions = fastTry.finallyInstructions;
        finallyInstructions.remove(0);
    }

    private static void Format131CatchFinally(LocalVariables localVariables, FastCodeException fce, FastTry fastTry) {
        List tryInstructions = fastTry.instructions;
        int length = tryInstructions.size();
        if (((Instruction)tryInstructions.get((int)(--length))).opcode == 167) {
            Goto g = (Goto)tryInstructions.remove(length);
            fce.tryToOffset = g.offset;
        }
        int finallyInstructitonsLineNumber = fastTry.finallyInstructions.get((int)0).lineNumber;
        int jumpOffset = FastCodeExceptionAnalyzer.FormatFastTry_RemoveJsrInstructionAndCompactStoreReturn(tryInstructions, localVariables, finallyInstructitonsLineNumber);
        length = tryInstructions.size();
        if (((Instruction)tryInstructions.get((int)(--length))).opcode == 168) {
            Jsr jsr = (Jsr)tryInstructions.remove(length);
            jumpOffset = jsr.GetJumpOffset();
        }
        if (jumpOffset == -1) {
            throw new UnexpectedInstructionException();
        }
        List<Instruction> finallyInstructions = fastTry.finallyInstructions;
        if (jumpOffset < finallyInstructions.get((int)0).offset) {
            List<Instruction> catchInstructions;
            int i = fastTry.catches.size();
            while (i-- > 0) {
                catchInstructions = fastTry.catches.get((int)i).instructions;
                if (catchInstructions.size() == 0 || catchInstructions.get((int)0).offset > jumpOffset) continue;
                int index = InstructionUtil.getIndexForOffset(catchInstructions, jumpOffset);
                finallyInstructions.clear();
                while (catchInstructions.get((int)index).opcode != 169) {
                    finallyInstructions.add(catchInstructions.remove(index));
                }
                if (catchInstructions.get((int)index).opcode != 169) break;
                finallyInstructions.add(catchInstructions.remove(index));
                break;
            }
            i = fastTry.catches.size();
            while (i-- > 0) {
                catchInstructions = fastTry.catches.get((int)i).instructions;
                length = catchInstructions.size();
                if (catchInstructions.get((int)(--length)).opcode == 167) {
                    Goto g = (Goto)catchInstructions.remove(length);
                    fce.catches.get((int)i).toOffset = g.offset;
                }
                if (catchInstructions.get((int)(--length)).opcode == 168) {
                    catchInstructions.remove(length);
                }
                FastCodeExceptionAnalyzer.FormatFastTry_RemoveJsrInstructionAndCompactStoreReturn(catchInstructions, localVariables, finallyInstructitonsLineNumber);
                catchInstructions.remove(0);
            }
            length = finallyInstructions.size();
            finallyInstructions.remove(--length);
            finallyInstructions.remove(0);
        } else {
            int i = fastTry.catches.size();
            while (i-- > 0) {
                List<Instruction> catchInstructions = fastTry.catches.get((int)i).instructions;
                length = catchInstructions.size();
                if (catchInstructions.get((int)(--length)).opcode == 167) {
                    Goto g = (Goto)catchInstructions.remove(length);
                    fce.catches.get((int)i).toOffset = g.offset;
                }
                if (catchInstructions.get((int)(--length)).opcode == 168) {
                    catchInstructions.remove(length);
                }
                FastCodeExceptionAnalyzer.FormatFastTry_RemoveJsrInstructionAndCompactStoreReturn(catchInstructions, localVariables, finallyInstructitonsLineNumber);
                catchInstructions.remove(0);
            }
            length = finallyInstructions.size();
            finallyInstructions.remove(--length);
            finallyInstructions.remove(0);
            finallyInstructions.remove(0);
            finallyInstructions.remove(0);
            finallyInstructions.remove(0);
        }
    }

    private static void Format142(LocalVariables localVariables, FastCodeException fce, FastTry fastTry) {
        List<Instruction> finallyInstructions = fastTry.finallyInstructions;
        int finallyInstructitonsSize = finallyInstructions.size();
        if (finallyInstructions.get((int)(finallyInstructitonsSize - 1)).opcode == 191) {
            finallyInstructions.remove(finallyInstructitonsSize - 1);
        }
        switch (finallyInstructions.get((int)0).opcode) {
            case 58: 
            case 87: {
                finallyInstructions.remove(0);
            }
        }
        finallyInstructitonsSize = finallyInstructions.size();
        if (finallyInstructitonsSize > 0) {
            FastCompareInstructionVisitor visitor = new FastCompareInstructionVisitor();
            List tryInstructions = fastTry.instructions;
            int length = tryInstructions.size();
            switch (((Instruction)tryInstructions.get((int)(length - 1))).opcode) {
                case 167: {
                    Goto g = (Goto)tryInstructions.get(--length);
                    if (g.branch <= 0) break;
                    tryInstructions.remove(length);
                    fce.tryToOffset = g.offset;
                }
            }
            FastCodeExceptionAnalyzer.Format142_RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(localVariables, visitor, tryInstructions, finallyInstructions);
            if (fastTry.catches != null) {
                int i = fastTry.catches.size();
                while (i-- > 0) {
                    List<Instruction> catchInstructions = fastTry.catches.get((int)i).instructions;
                    length = catchInstructions.size();
                    switch (catchInstructions.get((int)(length - 1)).opcode) {
                        case 167: {
                            Goto g = (Goto)catchInstructions.get(--length);
                            if (g.branch <= 0) break;
                            catchInstructions.remove(length);
                            fce.catches.get((int)i).toOffset = g.offset;
                        }
                    }
                    FastCodeExceptionAnalyzer.Format142_RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(localVariables, visitor, catchInstructions, finallyInstructions);
                    if (catchInstructions.size() <= 0) continue;
                    catchInstructions.remove(0);
                }
            }
        }
    }

    private static void Format142_RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(LocalVariables localVariables, FastCompareInstructionVisitor visitor, List<Instruction> instructions, List<Instruction> finallyInstructions) {
        boolean match;
        int index = instructions.size();
        int finallyInstructitonsSize = finallyInstructions.size();
        int finallyInstructitonsLineNumber = finallyInstructions.get((int)0).lineNumber;
        boolean bl = match = index >= finallyInstructitonsSize && visitor.visit(instructions, finallyInstructions, index - finallyInstructitonsSize, 0, finallyInstructitonsSize);
        if (match) {
            int j = 0;
            while (j < finallyInstructitonsSize && index > 0) {
                instructions.remove(--index);
                ++j;
            }
        }
        block12: while (index-- > 0) {
            Instruction instruction = instructions.get(index);
            switch (instruction.opcode) {
                case 177: 
                case 191: {
                    boolean bl2 = match = index >= finallyInstructitonsSize && visitor.visit(instructions, finallyInstructions, index - finallyInstructitonsSize, 0, finallyInstructitonsSize);
                    if (match) {
                        int j = 0;
                        while (j < finallyInstructitonsSize && index > 0) {
                            instructions.remove(--index);
                            ++j;
                        }
                    }
                    if (instruction.lineNumber == Instruction.UNKNOWN_LINE_NUMBER || instruction.lineNumber < finallyInstructitonsLineNumber) continue block12;
                    instruction.lineNumber = Instruction.UNKNOWN_LINE_NUMBER;
                    break;
                }
                case 273: {
                    boolean bl3 = match = index >= finallyInstructitonsSize && visitor.visit(instructions, finallyInstructions, index - finallyInstructitonsSize, 0, finallyInstructitonsSize);
                    if (match) {
                        int j = 0;
                        while (j < finallyInstructitonsSize && index > 0) {
                            instructions.remove(--index);
                            ++j;
                        }
                    }
                    ReturnInstruction ri = (ReturnInstruction)instruction;
                    if (ri.lineNumber == Instruction.UNKNOWN_LINE_NUMBER) break;
                    switch (ri.valueref.opcode) {
                        case 25: {
                            if (instructions.get((int)(index - 1)).opcode != 58) break;
                            index = FastCodeExceptionAnalyzer.CompactStoreReturn(instructions, localVariables, ri, index, finallyInstructitonsLineNumber);
                            break;
                        }
                        case 268: {
                            if (instructions.get((int)(index - 1)).opcode != 269) break;
                            index = FastCodeExceptionAnalyzer.CompactStoreReturn(instructions, localVariables, ri, index, finallyInstructitonsLineNumber);
                            break;
                        }
                        case 21: {
                            if (instructions.get((int)(index - 1)).opcode != 54) break;
                            index = FastCodeExceptionAnalyzer.CompactStoreReturn(instructions, localVariables, ri, index, finallyInstructitonsLineNumber);
                        }
                    }
                    continue block12;
                }
                case 318: {
                    FastTry ft = (FastTry)instruction;
                    FastCodeExceptionAnalyzer.Format142_RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(localVariables, visitor, ft.instructions, finallyInstructions);
                    if (ft.catches != null) {
                        int i = ft.catches.size();
                        while (i-- > 0) {
                            FastCodeExceptionAnalyzer.Format142_RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(localVariables, visitor, ft.catches.get((int)i).instructions, finallyInstructions);
                        }
                    }
                    if (ft.finallyInstructions == null) break;
                    FastCodeExceptionAnalyzer.Format142_RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(localVariables, visitor, ft.finallyInstructions, finallyInstructions);
                    break;
                }
                case 319: {
                    FastSynchronized fs = (FastSynchronized)instruction;
                    FastCodeExceptionAnalyzer.Format142_RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(localVariables, visitor, fs.instructions, finallyInstructions);
                }
            }
        }
    }

    private static int CompactStoreReturn(List<Instruction> instructions, LocalVariables localVariables, ReturnInstruction ri, int index, int finallyInstructitonsLineNumber) {
        IndexInstruction load = (IndexInstruction)ri.valueref;
        StoreInstruction store = (StoreInstruction)instructions.get(index - 1);
        if (load.index == store.index && (load.lineNumber <= store.lineNumber || load.lineNumber >= finallyInstructitonsLineNumber)) {
            LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(store.index, store.offset);
            if (lv != null && lv.start_pc == store.offset && lv.start_pc + lv.length <= ri.offset) {
                localVariables.removeLocalVariableWithIndexAndOffset(store.index, store.offset);
            }
            ri.valueref = store.valueref;
            if (ri.lineNumber > store.lineNumber) {
                ri.lineNumber = store.lineNumber;
            }
            instructions.remove(--index);
        }
        return index;
    }

    private static void Format142FinallyThrow(FastTry fastTry) {
        fastTry.finallyInstructions.remove(fastTry.finallyInstructions.size() - 1);
        fastTry.finallyInstructions.remove(0);
    }

    private static void FormatJikes122(LocalVariables localVariables, FastCodeException fce, FastTry fastTry, int returnOffset) {
        List tryInstructions = fastTry.instructions;
        int lastIndex = tryInstructions.size() - 1;
        Instruction lastTryInstruction = (Instruction)tryInstructions.get(lastIndex);
        int lastTryInstructionOffset = lastTryInstruction.offset;
        if (((Instruction)tryInstructions.get((int)lastIndex)).opcode == 167) {
            Goto g = (Goto)tryInstructions.remove(lastIndex);
            fce.tryToOffset = g.offset;
        }
        int finallyInstructitonsLineNumber = fastTry.finallyInstructions.get((int)0).lineNumber;
        FastCodeExceptionAnalyzer.FormatFastTry_RemoveJsrInstructionAndCompactStoreReturn(tryInstructions, localVariables, finallyInstructitonsLineNumber);
        int i = fastTry.catches.size();
        while (i-- > 0) {
            List<Instruction> catchInstructions = fastTry.catches.get((int)i).instructions;
            lastIndex = catchInstructions.size() - 1;
            if (catchInstructions.get((int)lastIndex).opcode == 167) {
                Goto g = (Goto)catchInstructions.remove(lastIndex);
                fce.catches.get((int)i).toOffset = g.offset;
            }
            FastCodeExceptionAnalyzer.FormatFastTry_RemoveJsrInstructionAndCompactStoreReturn(catchInstructions, localVariables, finallyInstructitonsLineNumber);
            FastCodeExceptionAnalyzer.FormatFastTry_FormatNegativeJumpOffset(catchInstructions, lastTryInstructionOffset, returnOffset);
            catchInstructions.remove(0);
        }
        List<Instruction> finallyInstructions = fastTry.finallyInstructions;
        int length = finallyInstructions.size();
        finallyInstructions.remove(--length);
        finallyInstructions.remove(--length);
        finallyInstructions.remove(0);
        if (finallyInstructions.get((int)0).opcode == 168) {
            finallyInstructions.remove(0);
        }
        if (finallyInstructions.get((int)0).opcode == 191) {
            finallyInstructions.remove(0);
        }
        if (finallyInstructions.get((int)0).opcode == 58) {
            finallyInstructions.remove(0);
        }
    }

    private static int FormatFastTry_RemoveJsrInstructionAndCompactStoreReturn(List<Instruction> instructions, LocalVariables localVariables, int finallyInstructitonsLineNumber) {
        int jumpOffset = -1;
        int index = instructions.size();
        while (index-- > 1) {
            if (instructions.get((int)index).opcode != 168) continue;
            Jsr jsr = (Jsr)instructions.remove(index);
            jumpOffset = jsr.GetJumpOffset();
        }
        index = instructions.size();
        while (index-- > 1) {
            Instruction instruction = instructions.get(index);
            if (instruction.opcode != 273) continue;
            ReturnInstruction ri = (ReturnInstruction)instruction;
            if (ri.lineNumber == Instruction.UNKNOWN_LINE_NUMBER) continue;
            switch (ri.valueref.opcode) {
                case 25: {
                    if (instructions.get((int)(index - 1)).opcode != 58) break;
                    index = FastCodeExceptionAnalyzer.CompactStoreReturn(instructions, localVariables, ri, index, finallyInstructitonsLineNumber);
                    break;
                }
                case 268: {
                    if (instructions.get((int)(index - 1)).opcode != 269) break;
                    index = FastCodeExceptionAnalyzer.CompactStoreReturn(instructions, localVariables, ri, index, finallyInstructitonsLineNumber);
                    break;
                }
                case 21: {
                    if (instructions.get((int)(index - 1)).opcode != 54) break;
                    index = FastCodeExceptionAnalyzer.CompactStoreReturn(instructions, localVariables, ri, index, finallyInstructitonsLineNumber);
                }
            }
        }
        return jumpOffset;
    }

    private static void FormatFastTry_FormatNegativeJumpOffset(List<Instruction> instructions, int lastTryInstructionOffset, int returnOffset) {
        int i = instructions.size();
        while (i-- > 0) {
            Instruction instruction = instructions.get(i);
            switch (instruction.opcode) {
                case 167: {
                    Goto g = (Goto)instruction;
                    int jumpOffset = g.GetJumpOffset();
                    if (jumpOffset >= lastTryInstructionOffset) break;
                    g.branch = returnOffset - g.offset;
                }
            }
        }
    }

    private static void FormatEclipse677Finally(FastCodeException fce, FastTry fastTry) {
        List<Instruction> finallyInstructions = fastTry.finallyInstructions;
        Instruction instruction = finallyInstructions.get(0);
        switch (instruction.opcode) {
            case 87: {
                finallyInstructions.remove(0);
                List tryInstructions = fastTry.instructions;
                int lastIndex = tryInstructions.size() - 1;
                if (((Instruction)tryInstructions.get((int)lastIndex)).opcode != 167) break;
                Goto g = (Goto)tryInstructions.remove(lastIndex);
                fce.tryToOffset = g.offset;
                break;
            }
            case 58: {
                int exceptionIndex = ((AStore)instruction).index;
                int index = finallyInstructions.size();
                int athrowOffset = -1;
                int afterAthrowOffset = -1;
                while (index-- > 0) {
                    instruction = finallyInstructions.get(index);
                    if (instruction.opcode == 191) {
                        AThrow athrow = (AThrow)instruction;
                        if (athrow.value.opcode == 25 && ((ALoad)athrow.value).index == exceptionIndex) {
                            athrowOffset = instruction.offset;
                            finallyInstructions.remove(index);
                            break;
                        }
                    }
                    afterAthrowOffset = instruction.offset;
                    finallyInstructions.remove(index);
                }
                Instruction astore = finallyInstructions.remove(0);
                List tryInstructions = fastTry.instructions;
                int lastIndex = tryInstructions.size() - 1;
                if (((Instruction)tryInstructions.get((int)lastIndex)).opcode == 167) {
                    Goto g = (Goto)tryInstructions.remove(lastIndex);
                    fce.tryToOffset = g.offset;
                }
                int finallyInstructitonsSize = finallyInstructions.size();
                FastCodeExceptionAnalyzer.FormatEclipse677Finally_RemoveFinallyInstructionsBeforeReturn(tryInstructions, finallyInstructitonsSize);
                FastCodeExceptionAnalyzer.FormatEclipse677Finally_FormatIfInstruction(tryInstructions, athrowOffset, afterAthrowOffset, astore.offset);
            }
        }
    }

    private static void FormatEclipse677Finally_FormatIfInstruction(List<Instruction> instructions, int athrowOffset, int afterAthrowOffset, int afterTryOffset) {
        int i = instructions.size();
        block3: while (i-- > 0) {
            Instruction instruction = instructions.get(i);
            switch (instruction.opcode) {
                case 260: 
                case 262: 
                case 284: {
                    IfInstruction ifi = (IfInstruction)instruction;
                    int jumpOffset = ifi.GetJumpOffset();
                    if (athrowOffset >= jumpOffset || jumpOffset > afterAthrowOffset) continue block3;
                    ifi.branch = afterTryOffset - ifi.offset;
                }
            }
        }
    }

    private static void FormatEclipse677Finally_RemoveFinallyInstructionsBeforeReturn(List<Instruction> instructions, int finallyInstructitonsSize) {
        int i = instructions.size();
        block3: while (i-- > 0) {
            switch (instructions.get((int)i).opcode) {
                case 177: 
                case 273: {
                    int j = 0;
                    while (j < finallyInstructitonsSize && i > 0) {
                        instructions.remove(--i);
                        ++j;
                    }
                    continue block3;
                }
            }
        }
    }

    private static void FormatEclipse677CatchFinally(FastCodeException fce, FastTry fastTry, int returnOffset) {
        List<Instruction> finallyInstructions = fastTry.finallyInstructions;
        int exceptionIndex = ((AStore)finallyInstructions.get((int)0)).index;
        int index = finallyInstructions.size();
        int athrowOffset = -1;
        int afterAthrowOffset = -1;
        while (index-- > 0) {
            Instruction instruction = finallyInstructions.get(index);
            if (instruction.opcode == 191) {
                AThrow athrow = (AThrow)instruction;
                if (athrow.value.opcode == 25 && ((ALoad)athrow.value).index == exceptionIndex) {
                    athrowOffset = finallyInstructions.remove((int)index).offset;
                    break;
                }
            }
            afterAthrowOffset = instruction.offset;
            finallyInstructions.remove(index);
        }
        finallyInstructions.remove(0);
        List tryInstructions = fastTry.instructions;
        int lastIndex = tryInstructions.size() - 1;
        Instruction lastTryInstruction = (Instruction)tryInstructions.get(lastIndex);
        int lastTryInstructionOffset = lastTryInstruction.offset;
        if (lastTryInstruction.opcode == 167) {
            Goto g = (Goto)tryInstructions.remove(lastIndex);
            fce.tryToOffset = g.offset;
        }
        int finallyInstructitonsSize = finallyInstructions.size();
        FastCodeExceptionAnalyzer.FormatEclipse677Finally_RemoveFinallyInstructionsBeforeReturn(tryInstructions, finallyInstructitonsSize);
        FastCodeExceptionAnalyzer.FormatEclipse677Finally_FormatIfInstruction(tryInstructions, athrowOffset, afterAthrowOffset, lastTryInstructionOffset + 1);
        int i = fastTry.catches.size();
        while (i-- > 0) {
            FastTry.FastCatch fastCatch = fastTry.catches.get(i);
            List<Instruction> catchInstructions = fastCatch.instructions;
            index = catchInstructions.size();
            Instruction lastInstruction = catchInstructions.get(index - 1);
            int lastInstructionOffset = lastInstruction.offset;
            if (lastInstruction.opcode == 167) {
                Goto g = (Goto)catchInstructions.remove(--index);
                fce.catches.get((int)i).toOffset = g.offset;
                int jumpOffset = g.GetJumpOffset();
                if (jumpOffset > fastTry.offset) {
                    int j = finallyInstructitonsSize;
                    while (j > 0) {
                        catchInstructions.remove(--index);
                        --j;
                    }
                }
            }
            FastCodeExceptionAnalyzer.FormatEclipse677Finally_RemoveFinallyInstructionsBeforeReturn(catchInstructions, finallyInstructitonsSize);
            FastCodeExceptionAnalyzer.FormatEclipse677Finally_FormatIfInstruction(catchInstructions, athrowOffset, afterAthrowOffset, lastInstructionOffset + 1);
            FastCodeExceptionAnalyzer.FormatFastTry_FormatNegativeJumpOffset(catchInstructions, lastTryInstructionOffset, returnOffset);
            catchInstructions.remove(0);
        }
    }

    public static int ComputeTryToIndex(List<Instruction> instructions, FastCodeException fce, int lastIndex, int maxOffset) {
        int beforeMaxOffset = fce.tryFromOffset;
        int index = InstructionUtil.getIndexForOffset(instructions, fce.tryFromOffset);
        while (index <= lastIndex) {
            Instruction instruction = instructions.get(index);
            if (instruction.offset > maxOffset) {
                return index - 1;
            }
            switch (instruction.opcode) {
                case 177: 
                case 191: 
                case 273: {
                    if (instruction.offset < beforeMaxOffset) break;
                    return index;
                }
                case 167: {
                    int jumpOffset = ((BranchInstruction)instruction).GetJumpOffset();
                    if (jumpOffset > instruction.offset) {
                        if (jumpOffset < maxOffset) {
                            if (beforeMaxOffset >= jumpOffset) break;
                            beforeMaxOffset = jumpOffset;
                            break;
                        }
                        if (instruction.offset < beforeMaxOffset) break;
                        return index;
                    }
                    if (jumpOffset >= fce.tryFromOffset || instruction.offset < beforeMaxOffset) break;
                    return index;
                }
                case 260: 
                case 261: 
                case 262: {
                    index = ComparisonInstructionAnalyzer.GetLastIndex(instructions, index);
                    BranchInstruction lastBi = (BranchInstruction)instructions.get(index);
                    int jumpOffset = lastBi.GetJumpOffset();
                    if (jumpOffset <= instruction.offset || jumpOffset >= maxOffset || beforeMaxOffset >= jumpOffset) break;
                    beforeMaxOffset = jumpOffset;
                    break;
                }
                case 170: 
                case 171: {
                    Switch s = (Switch)instruction;
                    int maxSitchOffset = s.defaultOffset;
                    int i = s.offsets.length;
                    while (i-- > 0) {
                        int offset = s.offsets[i];
                        if (maxSitchOffset >= offset) continue;
                        maxSitchOffset = offset;
                    }
                    if ((maxSitchOffset += s.offset) <= instruction.offset || maxSitchOffset >= maxOffset || beforeMaxOffset >= maxSitchOffset) break;
                    beforeMaxOffset = maxSitchOffset;
                }
            }
            ++index;
        }
        return index;
    }

    public static class FastAggregatedCodeException
    extends CodeException {
        public int[] otherCatchTypes = null;
        public int nbrFinally;
        public boolean synchronizedFlag = false;

        public FastAggregatedCodeException(int index, int start_pc, int end_pc, int handler_pc, int catch_type) {
            super(index, start_pc, end_pc, handler_pc, catch_type);
            this.nbrFinally = catch_type == 0 ? 1 : 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FastCodeException
    implements Comparable<FastCodeException> {
        public int tryFromOffset;
        public int tryToOffset;
        public List<FastCodeExceptionCatch> catches;
        public int finallyFromOffset;
        public int nbrFinally;
        public int maxOffset;
        public int afterOffset;
        public int type;
        public boolean synchronizedFlag;

        FastCodeException(int tryFromOffset, int tryToOffset, int maxOffset, boolean synchronizedFlag) {
            this.tryFromOffset = tryFromOffset;
            this.tryToOffset = tryToOffset;
            this.catches = new ArrayList<FastCodeExceptionCatch>();
            this.finallyFromOffset = -1;
            this.nbrFinally = 0;
            this.maxOffset = maxOffset;
            this.afterOffset = -1;
            this.type = 0;
            this.synchronizedFlag = synchronizedFlag;
        }

        @Override
        public int compareTo(FastCodeException other) {
            if (this.tryFromOffset != other.tryFromOffset) {
                return this.tryFromOffset - other.tryFromOffset;
            }
            if (this.maxOffset != other.maxOffset) {
                return other.maxOffset - this.maxOffset;
            }
            return other.tryToOffset - this.tryToOffset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FastCodeExceptionCatch
    implements Comparable<FastCodeExceptionCatch> {
        public int type;
        public int[] otherTypes;
        public int fromOffset;
        public int toOffset;

        public FastCodeExceptionCatch(int type, int[] otherCatchTypes, int fromOffset) {
            this.type = type;
            this.otherTypes = otherCatchTypes;
            this.fromOffset = fromOffset;
            this.toOffset = -1;
        }

        @Override
        public int compareTo(FastCodeExceptionCatch other) {
            return this.fromOffset - other.fromOffset;
        }
    }
}

