/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgChannelRequest
extends SshMessage {
    protected static final int SSH_MSG_CHANNEL_REQUEST = 98;
    private String requestType;
    private byte[] channelData;
    private boolean wantReply;
    private long recipientChannel;

    public SshMsgChannelRequest(long recipientChannel, String requestType, boolean wantReply, byte[] channelData) {
        super(98);
        this.recipientChannel = recipientChannel;
        this.requestType = requestType;
        this.wantReply = wantReply;
        this.channelData = channelData;
    }

    public SshMsgChannelRequest() {
        super(98);
    }

    public byte[] getChannelData() {
        return this.channelData;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_REQUEST";
    }

    public long getRecipientChannel() {
        return this.recipientChannel;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public boolean getWantReply() {
        return this.wantReply;
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeInt(this.recipientChannel);
            baw.writeString(this.requestType);
            baw.write(this.wantReply ? 1 : 0);
            if (this.channelData != null) {
                baw.write(this.channelData);
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.recipientChannel = bar.readInt();
            this.requestType = bar.readString();
            boolean bl = this.wantReply = bar.read() != 0;
            if (bar.available() > 0) {
                this.channelData = new byte[bar.available()];
                bar.read(this.channelData);
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

