/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import net.sourceforge.squirrel_sql.plugins.graph.QueryJoinType;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ConstraintQueryDataXmlBean;

public class ConstraintQueryData {
    private QueryJoinType _queryJoinType = QueryJoinType.INNER;
    private String _outerTableName;

    public ConstraintQueryData() {
    }

    public ConstraintQueryData(ConstraintQueryDataXmlBean constraintQueryDataXmlBean) {
        this._queryJoinType = QueryJoinType.getByIndex(constraintQueryDataXmlBean.getQueryJoinTypeIndex());
        this._outerTableName = constraintQueryDataXmlBean.getOuterTableName();
    }

    public boolean isInnerJoin() {
        return this._queryJoinType == QueryJoinType.INNER;
    }

    public boolean isOuterJoinFor(String tableName) {
        return this._queryJoinType == QueryJoinType.OUTER && tableName.equalsIgnoreCase(this._outerTableName);
    }

    public boolean isNoJoin() {
        return this._queryJoinType == QueryJoinType.NONE;
    }

    public void setInnerJoin() {
        this._queryJoinType = QueryJoinType.INNER;
        this._outerTableName = null;
    }

    public void setOuterJoin(String outerTableName) {
        this._queryJoinType = QueryJoinType.OUTER;
        this._outerTableName = outerTableName;
    }

    public void setNoJoin() {
        this._queryJoinType = QueryJoinType.NONE;
        this._outerTableName = null;
    }

    public ConstraintQueryDataXmlBean getXmlBean() {
        ConstraintQueryDataXmlBean ret = new ConstraintQueryDataXmlBean();
        ret.setQueryJoinTypeIndex(this._queryJoinType.getIndex());
        ret.setOuterTableName(this._outerTableName);
        return ret;
    }
}

