/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class VerticalToggleButton
extends JToggleButton {
    private static final int WIDHT_MARGIN = 20;
    private static final int HEIGHT_MARGIN = 4;

    public VerticalToggleButton(String caption) {
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        int captionHeight = fm.getHeight();
        int captionWidth = fm.stringWidth(caption);
        BufferedImage bi = new BufferedImage(captionHeight + 8, captionWidth + 40, 2);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        g.setColor(this.getForeground());
        g.setFont(f);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.rotate(-1.5707963267948966);
        g.translate(-bi.getHeight(), bi.getWidth());
        g.drawString(caption, 20, -4 - fm.getDescent());
        ImageIcon icon = new ImageIcon(bi);
        this.setIcon(icon);
        this.setActionCommand(caption);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Vertical Button Demo");
                frame.setDefaultCloseOperation(3);
                frame.setLayout(new FlowLayout());
                frame.add(new VerticalToggleButton("Vertical Up"));
                frame.add(new VerticalToggleButton("Vertical Down"));
                frame.pack();
                frame.setVisible(true);
            }
        });
    }
}

