package powerbidedicated

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CapacityProvisioningState enumerates the values for capacity provisioning state.
type CapacityProvisioningState string

const (
	// CapacityProvisioningStateDeleting ...
	CapacityProvisioningStateDeleting CapacityProvisioningState = "Deleting"
	// CapacityProvisioningStateFailed ...
	CapacityProvisioningStateFailed CapacityProvisioningState = "Failed"
	// CapacityProvisioningStatePaused ...
	CapacityProvisioningStatePaused CapacityProvisioningState = "Paused"
	// CapacityProvisioningStatePausing ...
	CapacityProvisioningStatePausing CapacityProvisioningState = "Pausing"
	// CapacityProvisioningStatePreparing ...
	CapacityProvisioningStatePreparing CapacityProvisioningState = "Preparing"
	// CapacityProvisioningStateProvisioning ...
	CapacityProvisioningStateProvisioning CapacityProvisioningState = "Provisioning"
	// CapacityProvisioningStateResuming ...
	CapacityProvisioningStateResuming CapacityProvisioningState = "Resuming"
	// CapacityProvisioningStateScaling ...
	CapacityProvisioningStateScaling CapacityProvisioningState = "Scaling"
	// CapacityProvisioningStateSucceeded ...
	CapacityProvisioningStateSucceeded CapacityProvisioningState = "Succeeded"
	// CapacityProvisioningStateSuspended ...
	CapacityProvisioningStateSuspended CapacityProvisioningState = "Suspended"
	// CapacityProvisioningStateSuspending ...
	CapacityProvisioningStateSuspending CapacityProvisioningState = "Suspending"
	// CapacityProvisioningStateUpdating ...
	CapacityProvisioningStateUpdating CapacityProvisioningState = "Updating"
)

// PossibleCapacityProvisioningStateValues returns an array of possible values for the CapacityProvisioningState const type.
func PossibleCapacityProvisioningStateValues() []CapacityProvisioningState {
	return []CapacityProvisioningState{CapacityProvisioningStateDeleting, CapacityProvisioningStateFailed, CapacityProvisioningStatePaused, CapacityProvisioningStatePausing, CapacityProvisioningStatePreparing, CapacityProvisioningStateProvisioning, CapacityProvisioningStateResuming, CapacityProvisioningStateScaling, CapacityProvisioningStateSucceeded, CapacityProvisioningStateSuspended, CapacityProvisioningStateSuspending, CapacityProvisioningStateUpdating}
}

// CapacitySkuTier enumerates the values for capacity sku tier.
type CapacitySkuTier string

const (
	// CapacitySkuTierAutoPremiumHost ...
	CapacitySkuTierAutoPremiumHost CapacitySkuTier = "AutoPremiumHost"
	// CapacitySkuTierPBIEAzure ...
	CapacitySkuTierPBIEAzure CapacitySkuTier = "PBIE_Azure"
	// CapacitySkuTierPremium ...
	CapacitySkuTierPremium CapacitySkuTier = "Premium"
)

// PossibleCapacitySkuTierValues returns an array of possible values for the CapacitySkuTier const type.
func PossibleCapacitySkuTierValues() []CapacitySkuTier {
	return []CapacitySkuTier{CapacitySkuTierAutoPremiumHost, CapacitySkuTierPBIEAzure, CapacitySkuTierPremium}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// IdentityTypeApplication ...
	IdentityTypeApplication IdentityType = "Application"
	// IdentityTypeKey ...
	IdentityTypeKey IdentityType = "Key"
	// IdentityTypeManagedIdentity ...
	IdentityTypeManagedIdentity IdentityType = "ManagedIdentity"
	// IdentityTypeUser ...
	IdentityTypeUser IdentityType = "User"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{IdentityTypeApplication, IdentityTypeKey, IdentityTypeManagedIdentity, IdentityTypeUser}
}

// Mode enumerates the values for mode.
type Mode string

const (
	// ModeGen1 ...
	ModeGen1 Mode = "Gen1"
	// ModeGen2 ...
	ModeGen2 Mode = "Gen2"
)

// PossibleModeValues returns an array of possible values for the Mode const type.
func PossibleModeValues() []Mode {
	return []Mode{ModeGen1, ModeGen2}
}

// State enumerates the values for state.
type State string

const (
	// StateDeleting ...
	StateDeleting State = "Deleting"
	// StateFailed ...
	StateFailed State = "Failed"
	// StatePaused ...
	StatePaused State = "Paused"
	// StatePausing ...
	StatePausing State = "Pausing"
	// StatePreparing ...
	StatePreparing State = "Preparing"
	// StateProvisioning ...
	StateProvisioning State = "Provisioning"
	// StateResuming ...
	StateResuming State = "Resuming"
	// StateScaling ...
	StateScaling State = "Scaling"
	// StateSucceeded ...
	StateSucceeded State = "Succeeded"
	// StateSuspended ...
	StateSuspended State = "Suspended"
	// StateSuspending ...
	StateSuspending State = "Suspending"
	// StateUpdating ...
	StateUpdating State = "Updating"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateDeleting, StateFailed, StatePaused, StatePausing, StatePreparing, StateProvisioning, StateResuming, StateScaling, StateSucceeded, StateSuspended, StateSuspending, StateUpdating}
}

// VCoreProvisioningState enumerates the values for v core provisioning state.
type VCoreProvisioningState string

const (
	// VCoreProvisioningStateSucceeded ...
	VCoreProvisioningStateSucceeded VCoreProvisioningState = "Succeeded"
)

// PossibleVCoreProvisioningStateValues returns an array of possible values for the VCoreProvisioningState const type.
func PossibleVCoreProvisioningStateValues() []VCoreProvisioningState {
	return []VCoreProvisioningState{VCoreProvisioningStateSucceeded}
}

// VCoreSkuTier enumerates the values for v core sku tier.
type VCoreSkuTier string

const (
	// VCoreSkuTierAutoScale ...
	VCoreSkuTierAutoScale VCoreSkuTier = "AutoScale"
)

// PossibleVCoreSkuTierValues returns an array of possible values for the VCoreSkuTier const type.
func PossibleVCoreSkuTierValues() []VCoreSkuTier {
	return []VCoreSkuTier{VCoreSkuTierAutoScale}
}
