package policy

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AliasPathAttributes enumerates the values for alias path attributes.
type AliasPathAttributes string

const (
	// AliasPathAttributesModifiable The token that the alias path is referring to is modifiable by policies
	// with 'modify' effect.
	AliasPathAttributesModifiable AliasPathAttributes = "Modifiable"
	// AliasPathAttributesNone The token that the alias path is referring to has no attributes.
	AliasPathAttributesNone AliasPathAttributes = "None"
)

// PossibleAliasPathAttributesValues returns an array of possible values for the AliasPathAttributes const type.
func PossibleAliasPathAttributesValues() []AliasPathAttributes {
	return []AliasPathAttributes{AliasPathAttributesModifiable, AliasPathAttributesNone}
}

// AliasPathTokenType enumerates the values for alias path token type.
type AliasPathTokenType string

const (
	// AliasPathTokenTypeAny The token type can be anything.
	AliasPathTokenTypeAny AliasPathTokenType = "Any"
	// AliasPathTokenTypeArray The token type is array.
	AliasPathTokenTypeArray AliasPathTokenType = "Array"
	// AliasPathTokenTypeBoolean The token type is boolean.
	AliasPathTokenTypeBoolean AliasPathTokenType = "Boolean"
	// AliasPathTokenTypeInteger The token type is integer.
	AliasPathTokenTypeInteger AliasPathTokenType = "Integer"
	// AliasPathTokenTypeNotSpecified The token type is not specified.
	AliasPathTokenTypeNotSpecified AliasPathTokenType = "NotSpecified"
	// AliasPathTokenTypeNumber The token type is number.
	AliasPathTokenTypeNumber AliasPathTokenType = "Number"
	// AliasPathTokenTypeObject The token type is object.
	AliasPathTokenTypeObject AliasPathTokenType = "Object"
	// AliasPathTokenTypeString The token type is string.
	AliasPathTokenTypeString AliasPathTokenType = "String"
)

// PossibleAliasPathTokenTypeValues returns an array of possible values for the AliasPathTokenType const type.
func PossibleAliasPathTokenTypeValues() []AliasPathTokenType {
	return []AliasPathTokenType{AliasPathTokenTypeAny, AliasPathTokenTypeArray, AliasPathTokenTypeBoolean, AliasPathTokenTypeInteger, AliasPathTokenTypeNotSpecified, AliasPathTokenTypeNumber, AliasPathTokenTypeObject, AliasPathTokenTypeString}
}

// AliasPatternType enumerates the values for alias pattern type.
type AliasPatternType string

const (
	// AliasPatternTypeExtract Extract is the only allowed value.
	AliasPatternTypeExtract AliasPatternType = "Extract"
	// AliasPatternTypeNotSpecified NotSpecified is not allowed.
	AliasPatternTypeNotSpecified AliasPatternType = "NotSpecified"
)

// PossibleAliasPatternTypeValues returns an array of possible values for the AliasPatternType const type.
func PossibleAliasPatternTypeValues() []AliasPatternType {
	return []AliasPatternType{AliasPatternTypeExtract, AliasPatternTypeNotSpecified}
}

// AliasType enumerates the values for alias type.
type AliasType string

const (
	// AliasTypeMask Alias value is secret.
	AliasTypeMask AliasType = "Mask"
	// AliasTypeNotSpecified Alias type is unknown (same as not providing alias type).
	AliasTypeNotSpecified AliasType = "NotSpecified"
	// AliasTypePlainText Alias value is not secret.
	AliasTypePlainText AliasType = "PlainText"
)

// PossibleAliasTypeValues returns an array of possible values for the AliasType const type.
func PossibleAliasTypeValues() []AliasType {
	return []AliasType{AliasTypeMask, AliasTypeNotSpecified, AliasTypePlainText}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// EnforcementMode enumerates the values for enforcement mode.
type EnforcementMode string

const (
	// EnforcementModeDefault The policy effect is enforced during resource creation or update.
	EnforcementModeDefault EnforcementMode = "Default"
	// EnforcementModeDoNotEnforce The policy effect is not enforced during resource creation or update.
	EnforcementModeDoNotEnforce EnforcementMode = "DoNotEnforce"
)

// PossibleEnforcementModeValues returns an array of possible values for the EnforcementMode const type.
func PossibleEnforcementModeValues() []EnforcementMode {
	return []EnforcementMode{EnforcementModeDefault, EnforcementModeDoNotEnforce}
}

// ExemptionCategory enumerates the values for exemption category.
type ExemptionCategory string

const (
	// ExemptionCategoryMitigated This category of exemptions usually means the mitigation actions have been
	// applied to the scope.
	ExemptionCategoryMitigated ExemptionCategory = "Mitigated"
	// ExemptionCategoryWaiver This category of exemptions usually means the scope is not applicable for the
	// policy.
	ExemptionCategoryWaiver ExemptionCategory = "Waiver"
)

// PossibleExemptionCategoryValues returns an array of possible values for the ExemptionCategory const type.
func PossibleExemptionCategoryValues() []ExemptionCategory {
	return []ExemptionCategory{ExemptionCategoryMitigated, ExemptionCategoryWaiver}
}

// ParameterType enumerates the values for parameter type.
type ParameterType string

const (
	// ParameterTypeArray ...
	ParameterTypeArray ParameterType = "Array"
	// ParameterTypeBoolean ...
	ParameterTypeBoolean ParameterType = "Boolean"
	// ParameterTypeDateTime ...
	ParameterTypeDateTime ParameterType = "DateTime"
	// ParameterTypeFloat ...
	ParameterTypeFloat ParameterType = "Float"
	// ParameterTypeInteger ...
	ParameterTypeInteger ParameterType = "Integer"
	// ParameterTypeObject ...
	ParameterTypeObject ParameterType = "Object"
	// ParameterTypeString ...
	ParameterTypeString ParameterType = "String"
)

// PossibleParameterTypeValues returns an array of possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{ParameterTypeArray, ParameterTypeBoolean, ParameterTypeDateTime, ParameterTypeFloat, ParameterTypeInteger, ParameterTypeObject, ParameterTypeString}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone Indicates that no identity is associated with the resource or that the existing
	// identity should be removed.
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned Indicates that a system assigned identity is associated with the
	// resource.
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeBuiltIn ...
	TypeBuiltIn Type = "BuiltIn"
	// TypeCustom ...
	TypeCustom Type = "Custom"
	// TypeNotSpecified ...
	TypeNotSpecified Type = "NotSpecified"
	// TypeStatic ...
	TypeStatic Type = "Static"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeBuiltIn, TypeCustom, TypeNotSpecified, TypeStatic}
}
