package virtualmachineimagebuilder

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/virtualmachineimagebuilder/mgmt/2019-05-01-preview/virtualmachineimagebuilder"

// APIError api error.
type APIError struct {
	// Details - The Api error details
	Details *[]APIErrorBase `json:"details,omitempty"`
	// InnerError - The Api inner error
	InnerError *InnerError `json:"innerError,omitempty"`
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Target - The target of the particular error.
	Target *string `json:"target,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// APIErrorBase api error base.
type APIErrorBase struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Target - The target of the particular error.
	Target *string `json:"target,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// ImageTemplate image template is an ARM resource managed by Microsoft.VirtualMachineImages provider
type ImageTemplate struct {
	autorest.Response `json:"-"`
	// ImageTemplateProperties - The properties of the image template
	*ImageTemplateProperties `json:"properties,omitempty"`
	// Identity - The identity of the image template, if configured.
	Identity *ImageTemplateIdentity `json:"identity,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ImageTemplate.
func (it ImageTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if it.ImageTemplateProperties != nil {
		objectMap["properties"] = it.ImageTemplateProperties
	}
	if it.Identity != nil {
		objectMap["identity"] = it.Identity
	}
	if it.Location != nil {
		objectMap["location"] = it.Location
	}
	if it.Tags != nil {
		objectMap["tags"] = it.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImageTemplate struct.
func (it *ImageTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var imageTemplateProperties ImageTemplateProperties
				err = json.Unmarshal(*v, &imageTemplateProperties)
				if err != nil {
					return err
				}
				it.ImageTemplateProperties = &imageTemplateProperties
			}
		case "identity":
			if v != nil {
				var identity ImageTemplateIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				it.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				it.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				it.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				it.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				it.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				it.Tags = tags
			}
		}
	}

	return nil
}

// BasicImageTemplateCustomizer describes a unit of image customization
type BasicImageTemplateCustomizer interface {
	AsImageTemplateShellCustomizer() (*ImageTemplateShellCustomizer, bool)
	AsImageTemplateRestartCustomizer() (*ImageTemplateRestartCustomizer, bool)
	AsImageTemplatePowerShellCustomizer() (*ImageTemplatePowerShellCustomizer, bool)
	AsImageTemplateFileCustomizer() (*ImageTemplateFileCustomizer, bool)
	AsImageTemplateCustomizer() (*ImageTemplateCustomizer, bool)
}

// ImageTemplateCustomizer describes a unit of image customization
type ImageTemplateCustomizer struct {
	// Name - Friendly Name to provide context on what this customization step does
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeImageTemplateCustomizer', 'TypeShell', 'TypeWindowsRestart', 'TypePowerShell', 'TypeFile'
	Type TypeBasicImageTemplateCustomizer `json:"type,omitempty"`
}

func unmarshalBasicImageTemplateCustomizer(body []byte) (BasicImageTemplateCustomizer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeShell):
		var itsc ImageTemplateShellCustomizer
		err := json.Unmarshal(body, &itsc)
		return itsc, err
	case string(TypeWindowsRestart):
		var itrc ImageTemplateRestartCustomizer
		err := json.Unmarshal(body, &itrc)
		return itrc, err
	case string(TypePowerShell):
		var itpsc ImageTemplatePowerShellCustomizer
		err := json.Unmarshal(body, &itpsc)
		return itpsc, err
	case string(TypeFile):
		var itfc ImageTemplateFileCustomizer
		err := json.Unmarshal(body, &itfc)
		return itfc, err
	default:
		var itc ImageTemplateCustomizer
		err := json.Unmarshal(body, &itc)
		return itc, err
	}
}
func unmarshalBasicImageTemplateCustomizerArray(body []byte) ([]BasicImageTemplateCustomizer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	itcArray := make([]BasicImageTemplateCustomizer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		itc, err := unmarshalBasicImageTemplateCustomizer(*rawMessage)
		if err != nil {
			return nil, err
		}
		itcArray[index] = itc
	}
	return itcArray, nil
}

// MarshalJSON is the custom marshaler for ImageTemplateCustomizer.
func (itc ImageTemplateCustomizer) MarshalJSON() ([]byte, error) {
	itc.Type = TypeImageTemplateCustomizer
	objectMap := make(map[string]interface{})
	if itc.Name != nil {
		objectMap["name"] = itc.Name
	}
	if itc.Type != "" {
		objectMap["type"] = itc.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateShellCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateCustomizer.
func (itc ImageTemplateCustomizer) AsImageTemplateShellCustomizer() (*ImageTemplateShellCustomizer, bool) {
	return nil, false
}

// AsImageTemplateRestartCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateCustomizer.
func (itc ImageTemplateCustomizer) AsImageTemplateRestartCustomizer() (*ImageTemplateRestartCustomizer, bool) {
	return nil, false
}

// AsImageTemplatePowerShellCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateCustomizer.
func (itc ImageTemplateCustomizer) AsImageTemplatePowerShellCustomizer() (*ImageTemplatePowerShellCustomizer, bool) {
	return nil, false
}

// AsImageTemplateFileCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateCustomizer.
func (itc ImageTemplateCustomizer) AsImageTemplateFileCustomizer() (*ImageTemplateFileCustomizer, bool) {
	return nil, false
}

// AsImageTemplateCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateCustomizer.
func (itc ImageTemplateCustomizer) AsImageTemplateCustomizer() (*ImageTemplateCustomizer, bool) {
	return &itc, true
}

// AsBasicImageTemplateCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateCustomizer.
func (itc ImageTemplateCustomizer) AsBasicImageTemplateCustomizer() (BasicImageTemplateCustomizer, bool) {
	return &itc, true
}

// BasicImageTemplateDistributor generic distribution object
type BasicImageTemplateDistributor interface {
	AsImageTemplateManagedImageDistributor() (*ImageTemplateManagedImageDistributor, bool)
	AsImageTemplateSharedImageDistributor() (*ImageTemplateSharedImageDistributor, bool)
	AsImageTemplateVhdDistributor() (*ImageTemplateVhdDistributor, bool)
	AsImageTemplateDistributor() (*ImageTemplateDistributor, bool)
}

// ImageTemplateDistributor generic distribution object
type ImageTemplateDistributor struct {
	// RunOutputName - The name to be used for the associated RunOutput.
	RunOutputName *string `json:"runOutputName,omitempty"`
	// ArtifactTags - Tags that will be applied to the artifact once it has been created/updated by the distributor.
	ArtifactTags map[string]*string `json:"artifactTags"`
	// Type - Possible values include: 'TypeBasicImageTemplateDistributorTypeImageTemplateDistributor', 'TypeBasicImageTemplateDistributorTypeManagedImage', 'TypeBasicImageTemplateDistributorTypeSharedImage', 'TypeBasicImageTemplateDistributorTypeVHD'
	Type TypeBasicImageTemplateDistributor `json:"type,omitempty"`
}

func unmarshalBasicImageTemplateDistributor(body []byte) (BasicImageTemplateDistributor, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicImageTemplateDistributorTypeManagedImage):
		var itmid ImageTemplateManagedImageDistributor
		err := json.Unmarshal(body, &itmid)
		return itmid, err
	case string(TypeBasicImageTemplateDistributorTypeSharedImage):
		var itsid ImageTemplateSharedImageDistributor
		err := json.Unmarshal(body, &itsid)
		return itsid, err
	case string(TypeBasicImageTemplateDistributorTypeVHD):
		var itvd ImageTemplateVhdDistributor
		err := json.Unmarshal(body, &itvd)
		return itvd, err
	default:
		var itd ImageTemplateDistributor
		err := json.Unmarshal(body, &itd)
		return itd, err
	}
}
func unmarshalBasicImageTemplateDistributorArray(body []byte) ([]BasicImageTemplateDistributor, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	itdArray := make([]BasicImageTemplateDistributor, len(rawMessages))

	for index, rawMessage := range rawMessages {
		itd, err := unmarshalBasicImageTemplateDistributor(*rawMessage)
		if err != nil {
			return nil, err
		}
		itdArray[index] = itd
	}
	return itdArray, nil
}

// MarshalJSON is the custom marshaler for ImageTemplateDistributor.
func (itd ImageTemplateDistributor) MarshalJSON() ([]byte, error) {
	itd.Type = TypeBasicImageTemplateDistributorTypeImageTemplateDistributor
	objectMap := make(map[string]interface{})
	if itd.RunOutputName != nil {
		objectMap["runOutputName"] = itd.RunOutputName
	}
	if itd.ArtifactTags != nil {
		objectMap["artifactTags"] = itd.ArtifactTags
	}
	if itd.Type != "" {
		objectMap["type"] = itd.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateManagedImageDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateDistributor.
func (itd ImageTemplateDistributor) AsImageTemplateManagedImageDistributor() (*ImageTemplateManagedImageDistributor, bool) {
	return nil, false
}

// AsImageTemplateSharedImageDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateDistributor.
func (itd ImageTemplateDistributor) AsImageTemplateSharedImageDistributor() (*ImageTemplateSharedImageDistributor, bool) {
	return nil, false
}

// AsImageTemplateVhdDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateDistributor.
func (itd ImageTemplateDistributor) AsImageTemplateVhdDistributor() (*ImageTemplateVhdDistributor, bool) {
	return nil, false
}

// AsImageTemplateDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateDistributor.
func (itd ImageTemplateDistributor) AsImageTemplateDistributor() (*ImageTemplateDistributor, bool) {
	return &itd, true
}

// AsBasicImageTemplateDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateDistributor.
func (itd ImageTemplateDistributor) AsBasicImageTemplateDistributor() (BasicImageTemplateDistributor, bool) {
	return &itd, true
}

// ImageTemplateFileCustomizer uploads files to VMs (Linux, Windows). Corresponds to Packer file
// provisioner
type ImageTemplateFileCustomizer struct {
	// SourceURI - The URI of the file to be uploaded for customizing the VM. It can be a github link, SAS URI for Azure Storage, etc
	SourceURI *string `json:"sourceUri,omitempty"`
	// Sha256Checksum - SHA256 checksum of the file provided in the sourceUri field above
	Sha256Checksum *string `json:"sha256Checksum,omitempty"`
	// Destination - The absolute path to a file (with nested directory structures already created) where the file (from sourceUri) will be uploaded to in the VM
	Destination *string `json:"destination,omitempty"`
	// Name - Friendly Name to provide context on what this customization step does
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeImageTemplateCustomizer', 'TypeShell', 'TypeWindowsRestart', 'TypePowerShell', 'TypeFile'
	Type TypeBasicImageTemplateCustomizer `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplateFileCustomizer.
func (itfc ImageTemplateFileCustomizer) MarshalJSON() ([]byte, error) {
	itfc.Type = TypeFile
	objectMap := make(map[string]interface{})
	if itfc.SourceURI != nil {
		objectMap["sourceUri"] = itfc.SourceURI
	}
	if itfc.Sha256Checksum != nil {
		objectMap["sha256Checksum"] = itfc.Sha256Checksum
	}
	if itfc.Destination != nil {
		objectMap["destination"] = itfc.Destination
	}
	if itfc.Name != nil {
		objectMap["name"] = itfc.Name
	}
	if itfc.Type != "" {
		objectMap["type"] = itfc.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateShellCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateFileCustomizer.
func (itfc ImageTemplateFileCustomizer) AsImageTemplateShellCustomizer() (*ImageTemplateShellCustomizer, bool) {
	return nil, false
}

// AsImageTemplateRestartCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateFileCustomizer.
func (itfc ImageTemplateFileCustomizer) AsImageTemplateRestartCustomizer() (*ImageTemplateRestartCustomizer, bool) {
	return nil, false
}

// AsImageTemplatePowerShellCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateFileCustomizer.
func (itfc ImageTemplateFileCustomizer) AsImageTemplatePowerShellCustomizer() (*ImageTemplatePowerShellCustomizer, bool) {
	return nil, false
}

// AsImageTemplateFileCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateFileCustomizer.
func (itfc ImageTemplateFileCustomizer) AsImageTemplateFileCustomizer() (*ImageTemplateFileCustomizer, bool) {
	return &itfc, true
}

// AsImageTemplateCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateFileCustomizer.
func (itfc ImageTemplateFileCustomizer) AsImageTemplateCustomizer() (*ImageTemplateCustomizer, bool) {
	return nil, false
}

// AsBasicImageTemplateCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateFileCustomizer.
func (itfc ImageTemplateFileCustomizer) AsBasicImageTemplateCustomizer() (BasicImageTemplateCustomizer, bool) {
	return &itfc, true
}

// ImageTemplateIdentity identity for the image template.
type ImageTemplateIdentity struct {
	// Type - The type of identity used for the image template. The type 'None' will remove any identities from the image template. Possible values include: 'UserAssigned', 'None'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the image template. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ImageTemplateIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ImageTemplateIdentity.
func (iti ImageTemplateIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iti.Type != "" {
		objectMap["type"] = iti.Type
	}
	if iti.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = iti.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ImageTemplateIdentityUserAssignedIdentitiesValue ...
type ImageTemplateIdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplateIdentityUserAssignedIdentitiesValue.
func (itiAiv ImageTemplateIdentityUserAssignedIdentitiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ImageTemplateIsoSource describes an image source that is an installation ISO. Currently only supports
// Red Hat Enterprise Linux 7.2-7.5 ISO's.
type ImageTemplateIsoSource struct {
	// SourceURI - URI to get the ISO image. This URI has to be accessible to the resource provider at the time of the image template creation.
	SourceURI *string `json:"sourceUri,omitempty"`
	// Sha256Checksum - SHA256 Checksum of the ISO image.
	Sha256Checksum *string `json:"sha256Checksum,omitempty"`
	// Type - Possible values include: 'TypeImageTemplateSource', 'TypeISO', 'TypePlatformImage', 'TypeManagedImage', 'TypeSharedImageVersion'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplateIsoSource.
func (itis ImageTemplateIsoSource) MarshalJSON() ([]byte, error) {
	itis.Type = TypeISO
	objectMap := make(map[string]interface{})
	if itis.SourceURI != nil {
		objectMap["sourceUri"] = itis.SourceURI
	}
	if itis.Sha256Checksum != nil {
		objectMap["sha256Checksum"] = itis.Sha256Checksum
	}
	if itis.Type != "" {
		objectMap["type"] = itis.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateIsoSource is the BasicImageTemplateSource implementation for ImageTemplateIsoSource.
func (itis ImageTemplateIsoSource) AsImageTemplateIsoSource() (*ImageTemplateIsoSource, bool) {
	return &itis, true
}

// AsImageTemplatePlatformImageSource is the BasicImageTemplateSource implementation for ImageTemplateIsoSource.
func (itis ImageTemplateIsoSource) AsImageTemplatePlatformImageSource() (*ImageTemplatePlatformImageSource, bool) {
	return nil, false
}

// AsImageTemplateManagedImageSource is the BasicImageTemplateSource implementation for ImageTemplateIsoSource.
func (itis ImageTemplateIsoSource) AsImageTemplateManagedImageSource() (*ImageTemplateManagedImageSource, bool) {
	return nil, false
}

// AsImageTemplateSharedImageVersionSource is the BasicImageTemplateSource implementation for ImageTemplateIsoSource.
func (itis ImageTemplateIsoSource) AsImageTemplateSharedImageVersionSource() (*ImageTemplateSharedImageVersionSource, bool) {
	return nil, false
}

// AsImageTemplateSource is the BasicImageTemplateSource implementation for ImageTemplateIsoSource.
func (itis ImageTemplateIsoSource) AsImageTemplateSource() (*ImageTemplateSource, bool) {
	return nil, false
}

// AsBasicImageTemplateSource is the BasicImageTemplateSource implementation for ImageTemplateIsoSource.
func (itis ImageTemplateIsoSource) AsBasicImageTemplateSource() (BasicImageTemplateSource, bool) {
	return &itis, true
}

// ImageTemplateLastRunStatus describes the latest status of running an image template
type ImageTemplateLastRunStatus struct {
	// StartTime - Start time of the last run (UTC)
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the last run (UTC)
	EndTime *date.Time `json:"endTime,omitempty"`
	// RunState - State of the last run. Possible values include: 'RunStateRunning', 'RunStateSucceeded', 'RunStatePartiallySucceeded', 'RunStateFailed'
	RunState RunState `json:"runState,omitempty"`
	// RunSubState - Sub-state of the last run. Possible values include: 'Queued', 'Building', 'Customizing', 'Distributing'
	RunSubState RunSubState `json:"runSubState,omitempty"`
	// Message - Verbose information about the last run state
	Message *string `json:"message,omitempty"`
}

// ImageTemplateListResult the result of List image templates operation
type ImageTemplateListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of image templates
	Value *[]ImageTemplate `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// ImageTemplateListResultIterator provides access to a complete listing of ImageTemplate values.
type ImageTemplateListResultIterator struct {
	i    int
	page ImageTemplateListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ImageTemplateListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImageTemplateListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ImageTemplateListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ImageTemplateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ImageTemplateListResultIterator) Response() ImageTemplateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ImageTemplateListResultIterator) Value() ImageTemplate {
	if !iter.page.NotDone() {
		return ImageTemplate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ImageTemplateListResultIterator type.
func NewImageTemplateListResultIterator(page ImageTemplateListResultPage) ImageTemplateListResultIterator {
	return ImageTemplateListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (itlr ImageTemplateListResult) IsEmpty() bool {
	return itlr.Value == nil || len(*itlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (itlr ImageTemplateListResult) hasNextLink() bool {
	return itlr.NextLink != nil && len(*itlr.NextLink) != 0
}

// imageTemplateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (itlr ImageTemplateListResult) imageTemplateListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !itlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(itlr.NextLink)))
}

// ImageTemplateListResultPage contains a page of ImageTemplate values.
type ImageTemplateListResultPage struct {
	fn   func(context.Context, ImageTemplateListResult) (ImageTemplateListResult, error)
	itlr ImageTemplateListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ImageTemplateListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImageTemplateListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.itlr)
		if err != nil {
			return err
		}
		page.itlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ImageTemplateListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ImageTemplateListResultPage) NotDone() bool {
	return !page.itlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ImageTemplateListResultPage) Response() ImageTemplateListResult {
	return page.itlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ImageTemplateListResultPage) Values() []ImageTemplate {
	if page.itlr.IsEmpty() {
		return nil
	}
	return *page.itlr.Value
}

// Creates a new instance of the ImageTemplateListResultPage type.
func NewImageTemplateListResultPage(cur ImageTemplateListResult, getNextPage func(context.Context, ImageTemplateListResult) (ImageTemplateListResult, error)) ImageTemplateListResultPage {
	return ImageTemplateListResultPage{
		fn:   getNextPage,
		itlr: cur,
	}
}

// ImageTemplateManagedImageDistributor distribute as a Managed Disk Image.
type ImageTemplateManagedImageDistributor struct {
	// ImageID - Resource Id of the Managed Disk Image
	ImageID *string `json:"imageId,omitempty"`
	// Location - Azure location for the image, should match if image already exists
	Location *string `json:"location,omitempty"`
	// RunOutputName - The name to be used for the associated RunOutput.
	RunOutputName *string `json:"runOutputName,omitempty"`
	// ArtifactTags - Tags that will be applied to the artifact once it has been created/updated by the distributor.
	ArtifactTags map[string]*string `json:"artifactTags"`
	// Type - Possible values include: 'TypeBasicImageTemplateDistributorTypeImageTemplateDistributor', 'TypeBasicImageTemplateDistributorTypeManagedImage', 'TypeBasicImageTemplateDistributorTypeSharedImage', 'TypeBasicImageTemplateDistributorTypeVHD'
	Type TypeBasicImageTemplateDistributor `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplateManagedImageDistributor.
func (itmid ImageTemplateManagedImageDistributor) MarshalJSON() ([]byte, error) {
	itmid.Type = TypeBasicImageTemplateDistributorTypeManagedImage
	objectMap := make(map[string]interface{})
	if itmid.ImageID != nil {
		objectMap["imageId"] = itmid.ImageID
	}
	if itmid.Location != nil {
		objectMap["location"] = itmid.Location
	}
	if itmid.RunOutputName != nil {
		objectMap["runOutputName"] = itmid.RunOutputName
	}
	if itmid.ArtifactTags != nil {
		objectMap["artifactTags"] = itmid.ArtifactTags
	}
	if itmid.Type != "" {
		objectMap["type"] = itmid.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateManagedImageDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateManagedImageDistributor.
func (itmid ImageTemplateManagedImageDistributor) AsImageTemplateManagedImageDistributor() (*ImageTemplateManagedImageDistributor, bool) {
	return &itmid, true
}

// AsImageTemplateSharedImageDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateManagedImageDistributor.
func (itmid ImageTemplateManagedImageDistributor) AsImageTemplateSharedImageDistributor() (*ImageTemplateSharedImageDistributor, bool) {
	return nil, false
}

// AsImageTemplateVhdDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateManagedImageDistributor.
func (itmid ImageTemplateManagedImageDistributor) AsImageTemplateVhdDistributor() (*ImageTemplateVhdDistributor, bool) {
	return nil, false
}

// AsImageTemplateDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateManagedImageDistributor.
func (itmid ImageTemplateManagedImageDistributor) AsImageTemplateDistributor() (*ImageTemplateDistributor, bool) {
	return nil, false
}

// AsBasicImageTemplateDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateManagedImageDistributor.
func (itmid ImageTemplateManagedImageDistributor) AsBasicImageTemplateDistributor() (BasicImageTemplateDistributor, bool) {
	return &itmid, true
}

// ImageTemplateManagedImageSource describes an image source that is a managed image in customer
// subscription.
type ImageTemplateManagedImageSource struct {
	// ImageID - ARM resource id of the managed image in customer subscription
	ImageID *string `json:"imageId,omitempty"`
	// Type - Possible values include: 'TypeImageTemplateSource', 'TypeISO', 'TypePlatformImage', 'TypeManagedImage', 'TypeSharedImageVersion'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplateManagedImageSource.
func (itmis ImageTemplateManagedImageSource) MarshalJSON() ([]byte, error) {
	itmis.Type = TypeManagedImage
	objectMap := make(map[string]interface{})
	if itmis.ImageID != nil {
		objectMap["imageId"] = itmis.ImageID
	}
	if itmis.Type != "" {
		objectMap["type"] = itmis.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateIsoSource is the BasicImageTemplateSource implementation for ImageTemplateManagedImageSource.
func (itmis ImageTemplateManagedImageSource) AsImageTemplateIsoSource() (*ImageTemplateIsoSource, bool) {
	return nil, false
}

// AsImageTemplatePlatformImageSource is the BasicImageTemplateSource implementation for ImageTemplateManagedImageSource.
func (itmis ImageTemplateManagedImageSource) AsImageTemplatePlatformImageSource() (*ImageTemplatePlatformImageSource, bool) {
	return nil, false
}

// AsImageTemplateManagedImageSource is the BasicImageTemplateSource implementation for ImageTemplateManagedImageSource.
func (itmis ImageTemplateManagedImageSource) AsImageTemplateManagedImageSource() (*ImageTemplateManagedImageSource, bool) {
	return &itmis, true
}

// AsImageTemplateSharedImageVersionSource is the BasicImageTemplateSource implementation for ImageTemplateManagedImageSource.
func (itmis ImageTemplateManagedImageSource) AsImageTemplateSharedImageVersionSource() (*ImageTemplateSharedImageVersionSource, bool) {
	return nil, false
}

// AsImageTemplateSource is the BasicImageTemplateSource implementation for ImageTemplateManagedImageSource.
func (itmis ImageTemplateManagedImageSource) AsImageTemplateSource() (*ImageTemplateSource, bool) {
	return nil, false
}

// AsBasicImageTemplateSource is the BasicImageTemplateSource implementation for ImageTemplateManagedImageSource.
func (itmis ImageTemplateManagedImageSource) AsBasicImageTemplateSource() (BasicImageTemplateSource, bool) {
	return &itmis, true
}

// ImageTemplatePlatformImageSource describes an image source from [Azure Gallery
// Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
type ImageTemplatePlatformImageSource struct {
	// Publisher - Image Publisher in [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
	Publisher *string `json:"publisher,omitempty"`
	// Offer - Image offer from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
	Offer *string `json:"offer,omitempty"`
	// Sku - Image sku from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
	Sku *string `json:"sku,omitempty"`
	// Version - Image version from the [Azure Gallery Images](https://docs.microsoft.com/en-us/rest/api/compute/virtualmachineimages).
	Version *string `json:"version,omitempty"`
	// Type - Possible values include: 'TypeImageTemplateSource', 'TypeISO', 'TypePlatformImage', 'TypeManagedImage', 'TypeSharedImageVersion'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplatePlatformImageSource.
func (itpis ImageTemplatePlatformImageSource) MarshalJSON() ([]byte, error) {
	itpis.Type = TypePlatformImage
	objectMap := make(map[string]interface{})
	if itpis.Publisher != nil {
		objectMap["publisher"] = itpis.Publisher
	}
	if itpis.Offer != nil {
		objectMap["offer"] = itpis.Offer
	}
	if itpis.Sku != nil {
		objectMap["sku"] = itpis.Sku
	}
	if itpis.Version != nil {
		objectMap["version"] = itpis.Version
	}
	if itpis.Type != "" {
		objectMap["type"] = itpis.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateIsoSource is the BasicImageTemplateSource implementation for ImageTemplatePlatformImageSource.
func (itpis ImageTemplatePlatformImageSource) AsImageTemplateIsoSource() (*ImageTemplateIsoSource, bool) {
	return nil, false
}

// AsImageTemplatePlatformImageSource is the BasicImageTemplateSource implementation for ImageTemplatePlatformImageSource.
func (itpis ImageTemplatePlatformImageSource) AsImageTemplatePlatformImageSource() (*ImageTemplatePlatformImageSource, bool) {
	return &itpis, true
}

// AsImageTemplateManagedImageSource is the BasicImageTemplateSource implementation for ImageTemplatePlatformImageSource.
func (itpis ImageTemplatePlatformImageSource) AsImageTemplateManagedImageSource() (*ImageTemplateManagedImageSource, bool) {
	return nil, false
}

// AsImageTemplateSharedImageVersionSource is the BasicImageTemplateSource implementation for ImageTemplatePlatformImageSource.
func (itpis ImageTemplatePlatformImageSource) AsImageTemplateSharedImageVersionSource() (*ImageTemplateSharedImageVersionSource, bool) {
	return nil, false
}

// AsImageTemplateSource is the BasicImageTemplateSource implementation for ImageTemplatePlatformImageSource.
func (itpis ImageTemplatePlatformImageSource) AsImageTemplateSource() (*ImageTemplateSource, bool) {
	return nil, false
}

// AsBasicImageTemplateSource is the BasicImageTemplateSource implementation for ImageTemplatePlatformImageSource.
func (itpis ImageTemplatePlatformImageSource) AsBasicImageTemplateSource() (BasicImageTemplateSource, bool) {
	return &itpis, true
}

// ImageTemplatePowerShellCustomizer runs the specified PowerShell on the VM (Windows). Corresponds to
// Packer powershell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
type ImageTemplatePowerShellCustomizer struct {
	// ScriptURI - URI of the PowerShell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
	ScriptURI *string `json:"scriptUri,omitempty"`
	// Sha256Checksum - SHA256 checksum of the power shell script provided in the scriptUri field above
	Sha256Checksum *string `json:"sha256Checksum,omitempty"`
	// Inline - Array of PowerShell commands to execute
	Inline *[]string `json:"inline,omitempty"`
	// RunElevated - If specified, the PowerShell script will be run with elevated privileges
	RunElevated *bool `json:"runElevated,omitempty"`
	// ValidExitCodes - Valid exit codes for the PowerShell script. [Default: 0]
	ValidExitCodes *[]int32 `json:"validExitCodes,omitempty"`
	// Name - Friendly Name to provide context on what this customization step does
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeImageTemplateCustomizer', 'TypeShell', 'TypeWindowsRestart', 'TypePowerShell', 'TypeFile'
	Type TypeBasicImageTemplateCustomizer `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplatePowerShellCustomizer.
func (itpsc ImageTemplatePowerShellCustomizer) MarshalJSON() ([]byte, error) {
	itpsc.Type = TypePowerShell
	objectMap := make(map[string]interface{})
	if itpsc.ScriptURI != nil {
		objectMap["scriptUri"] = itpsc.ScriptURI
	}
	if itpsc.Sha256Checksum != nil {
		objectMap["sha256Checksum"] = itpsc.Sha256Checksum
	}
	if itpsc.Inline != nil {
		objectMap["inline"] = itpsc.Inline
	}
	if itpsc.RunElevated != nil {
		objectMap["runElevated"] = itpsc.RunElevated
	}
	if itpsc.ValidExitCodes != nil {
		objectMap["validExitCodes"] = itpsc.ValidExitCodes
	}
	if itpsc.Name != nil {
		objectMap["name"] = itpsc.Name
	}
	if itpsc.Type != "" {
		objectMap["type"] = itpsc.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateShellCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplatePowerShellCustomizer.
func (itpsc ImageTemplatePowerShellCustomizer) AsImageTemplateShellCustomizer() (*ImageTemplateShellCustomizer, bool) {
	return nil, false
}

// AsImageTemplateRestartCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplatePowerShellCustomizer.
func (itpsc ImageTemplatePowerShellCustomizer) AsImageTemplateRestartCustomizer() (*ImageTemplateRestartCustomizer, bool) {
	return nil, false
}

// AsImageTemplatePowerShellCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplatePowerShellCustomizer.
func (itpsc ImageTemplatePowerShellCustomizer) AsImageTemplatePowerShellCustomizer() (*ImageTemplatePowerShellCustomizer, bool) {
	return &itpsc, true
}

// AsImageTemplateFileCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplatePowerShellCustomizer.
func (itpsc ImageTemplatePowerShellCustomizer) AsImageTemplateFileCustomizer() (*ImageTemplateFileCustomizer, bool) {
	return nil, false
}

// AsImageTemplateCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplatePowerShellCustomizer.
func (itpsc ImageTemplatePowerShellCustomizer) AsImageTemplateCustomizer() (*ImageTemplateCustomizer, bool) {
	return nil, false
}

// AsBasicImageTemplateCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplatePowerShellCustomizer.
func (itpsc ImageTemplatePowerShellCustomizer) AsBasicImageTemplateCustomizer() (BasicImageTemplateCustomizer, bool) {
	return &itpsc, true
}

// ImageTemplateProperties describes the properties of an image template
type ImageTemplateProperties struct {
	// Source - Specifies the properties used to describe the source image.
	Source BasicImageTemplateSource `json:"source,omitempty"`
	// Customize - Specifies the properties used to describe the customization steps of the image, like Image source etc
	Customize *[]BasicImageTemplateCustomizer `json:"customize,omitempty"`
	// Distribute - The distribution targets where the image output needs to go to.
	Distribute *[]BasicImageTemplateDistributor `json:"distribute,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningError - READ-ONLY; Provisioning error, if any
	ProvisioningError *ProvisioningError `json:"provisioningError,omitempty"`
	// LastRunStatus - READ-ONLY; State of 'run' that is currently executing or was last executed.
	LastRunStatus *ImageTemplateLastRunStatus `json:"lastRunStatus,omitempty"`
	// BuildTimeoutInMinutes - Maximum duration to wait while building the image template. Omit or specify 0 to use the default (4 hours).
	BuildTimeoutInMinutes *int32 `json:"buildTimeoutInMinutes,omitempty"`
	// VMProfile - Describes how virtual machine is set up to build images
	VMProfile *ImageTemplateVMProfile `json:"vmProfile,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplateProperties.
func (itp ImageTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["source"] = itp.Source
	if itp.Customize != nil {
		objectMap["customize"] = itp.Customize
	}
	if itp.Distribute != nil {
		objectMap["distribute"] = itp.Distribute
	}
	if itp.BuildTimeoutInMinutes != nil {
		objectMap["buildTimeoutInMinutes"] = itp.BuildTimeoutInMinutes
	}
	if itp.VMProfile != nil {
		objectMap["vmProfile"] = itp.VMProfile
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImageTemplateProperties struct.
func (itp *ImageTemplateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "source":
			if v != nil {
				source, err := unmarshalBasicImageTemplateSource(*v)
				if err != nil {
					return err
				}
				itp.Source = source
			}
		case "customize":
			if v != nil {
				customize, err := unmarshalBasicImageTemplateCustomizerArray(*v)
				if err != nil {
					return err
				}
				itp.Customize = &customize
			}
		case "distribute":
			if v != nil {
				distribute, err := unmarshalBasicImageTemplateDistributorArray(*v)
				if err != nil {
					return err
				}
				itp.Distribute = &distribute
			}
		case "provisioningState":
			if v != nil {
				var provisioningState ProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				itp.ProvisioningState = provisioningState
			}
		case "provisioningError":
			if v != nil {
				var provisioningError ProvisioningError
				err = json.Unmarshal(*v, &provisioningError)
				if err != nil {
					return err
				}
				itp.ProvisioningError = &provisioningError
			}
		case "lastRunStatus":
			if v != nil {
				var lastRunStatus ImageTemplateLastRunStatus
				err = json.Unmarshal(*v, &lastRunStatus)
				if err != nil {
					return err
				}
				itp.LastRunStatus = &lastRunStatus
			}
		case "buildTimeoutInMinutes":
			if v != nil {
				var buildTimeoutInMinutes int32
				err = json.Unmarshal(*v, &buildTimeoutInMinutes)
				if err != nil {
					return err
				}
				itp.BuildTimeoutInMinutes = &buildTimeoutInMinutes
			}
		case "vmProfile":
			if v != nil {
				var VMProfile ImageTemplateVMProfile
				err = json.Unmarshal(*v, &VMProfile)
				if err != nil {
					return err
				}
				itp.VMProfile = &VMProfile
			}
		}
	}

	return nil
}

// ImageTemplateRestartCustomizer reboots a VM and waits for it to come back online (Windows). Corresponds
// to Packer windows-restart provisioner
type ImageTemplateRestartCustomizer struct {
	// RestartCommand - Command to execute the restart [Default: 'shutdown /r /f /t 0 /c "packer restart"']
	RestartCommand *string `json:"restartCommand,omitempty"`
	// RestartCheckCommand - Command to check if restart succeeded [Default: '']
	RestartCheckCommand *string `json:"restartCheckCommand,omitempty"`
	// RestartTimeout - Restart timeout specified as a string of magnitude and unit, e.g. '5m' (5 minutes) or '2h' (2 hours) [Default: '5m']
	RestartTimeout *string `json:"restartTimeout,omitempty"`
	// Name - Friendly Name to provide context on what this customization step does
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeImageTemplateCustomizer', 'TypeShell', 'TypeWindowsRestart', 'TypePowerShell', 'TypeFile'
	Type TypeBasicImageTemplateCustomizer `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplateRestartCustomizer.
func (itrc ImageTemplateRestartCustomizer) MarshalJSON() ([]byte, error) {
	itrc.Type = TypeWindowsRestart
	objectMap := make(map[string]interface{})
	if itrc.RestartCommand != nil {
		objectMap["restartCommand"] = itrc.RestartCommand
	}
	if itrc.RestartCheckCommand != nil {
		objectMap["restartCheckCommand"] = itrc.RestartCheckCommand
	}
	if itrc.RestartTimeout != nil {
		objectMap["restartTimeout"] = itrc.RestartTimeout
	}
	if itrc.Name != nil {
		objectMap["name"] = itrc.Name
	}
	if itrc.Type != "" {
		objectMap["type"] = itrc.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateShellCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateRestartCustomizer.
func (itrc ImageTemplateRestartCustomizer) AsImageTemplateShellCustomizer() (*ImageTemplateShellCustomizer, bool) {
	return nil, false
}

// AsImageTemplateRestartCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateRestartCustomizer.
func (itrc ImageTemplateRestartCustomizer) AsImageTemplateRestartCustomizer() (*ImageTemplateRestartCustomizer, bool) {
	return &itrc, true
}

// AsImageTemplatePowerShellCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateRestartCustomizer.
func (itrc ImageTemplateRestartCustomizer) AsImageTemplatePowerShellCustomizer() (*ImageTemplatePowerShellCustomizer, bool) {
	return nil, false
}

// AsImageTemplateFileCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateRestartCustomizer.
func (itrc ImageTemplateRestartCustomizer) AsImageTemplateFileCustomizer() (*ImageTemplateFileCustomizer, bool) {
	return nil, false
}

// AsImageTemplateCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateRestartCustomizer.
func (itrc ImageTemplateRestartCustomizer) AsImageTemplateCustomizer() (*ImageTemplateCustomizer, bool) {
	return nil, false
}

// AsBasicImageTemplateCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateRestartCustomizer.
func (itrc ImageTemplateRestartCustomizer) AsBasicImageTemplateCustomizer() (BasicImageTemplateCustomizer, bool) {
	return &itrc, true
}

// ImageTemplateSharedImageDistributor distribute via Shared Image Gallery.
type ImageTemplateSharedImageDistributor struct {
	// GalleryImageID - Resource Id of the Shared Image Gallery image
	GalleryImageID *string `json:"galleryImageId,omitempty"`
	// ReplicationRegions - A list of regions that the image will be replicated to
	ReplicationRegions *[]string `json:"replicationRegions,omitempty"`
	// RunOutputName - The name to be used for the associated RunOutput.
	RunOutputName *string `json:"runOutputName,omitempty"`
	// ArtifactTags - Tags that will be applied to the artifact once it has been created/updated by the distributor.
	ArtifactTags map[string]*string `json:"artifactTags"`
	// Type - Possible values include: 'TypeBasicImageTemplateDistributorTypeImageTemplateDistributor', 'TypeBasicImageTemplateDistributorTypeManagedImage', 'TypeBasicImageTemplateDistributorTypeSharedImage', 'TypeBasicImageTemplateDistributorTypeVHD'
	Type TypeBasicImageTemplateDistributor `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplateSharedImageDistributor.
func (itsid ImageTemplateSharedImageDistributor) MarshalJSON() ([]byte, error) {
	itsid.Type = TypeBasicImageTemplateDistributorTypeSharedImage
	objectMap := make(map[string]interface{})
	if itsid.GalleryImageID != nil {
		objectMap["galleryImageId"] = itsid.GalleryImageID
	}
	if itsid.ReplicationRegions != nil {
		objectMap["replicationRegions"] = itsid.ReplicationRegions
	}
	if itsid.RunOutputName != nil {
		objectMap["runOutputName"] = itsid.RunOutputName
	}
	if itsid.ArtifactTags != nil {
		objectMap["artifactTags"] = itsid.ArtifactTags
	}
	if itsid.Type != "" {
		objectMap["type"] = itsid.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateManagedImageDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateSharedImageDistributor.
func (itsid ImageTemplateSharedImageDistributor) AsImageTemplateManagedImageDistributor() (*ImageTemplateManagedImageDistributor, bool) {
	return nil, false
}

// AsImageTemplateSharedImageDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateSharedImageDistributor.
func (itsid ImageTemplateSharedImageDistributor) AsImageTemplateSharedImageDistributor() (*ImageTemplateSharedImageDistributor, bool) {
	return &itsid, true
}

// AsImageTemplateVhdDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateSharedImageDistributor.
func (itsid ImageTemplateSharedImageDistributor) AsImageTemplateVhdDistributor() (*ImageTemplateVhdDistributor, bool) {
	return nil, false
}

// AsImageTemplateDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateSharedImageDistributor.
func (itsid ImageTemplateSharedImageDistributor) AsImageTemplateDistributor() (*ImageTemplateDistributor, bool) {
	return nil, false
}

// AsBasicImageTemplateDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateSharedImageDistributor.
func (itsid ImageTemplateSharedImageDistributor) AsBasicImageTemplateDistributor() (BasicImageTemplateDistributor, bool) {
	return &itsid, true
}

// ImageTemplateSharedImageVersionSource describes an image source that is an image version in a shared
// image gallery.
type ImageTemplateSharedImageVersionSource struct {
	// ImageVersionID - ARM resource id of the image version in the shared image gallery
	ImageVersionID *string `json:"imageVersionId,omitempty"`
	// Type - Possible values include: 'TypeImageTemplateSource', 'TypeISO', 'TypePlatformImage', 'TypeManagedImage', 'TypeSharedImageVersion'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplateSharedImageVersionSource.
func (itsivs ImageTemplateSharedImageVersionSource) MarshalJSON() ([]byte, error) {
	itsivs.Type = TypeSharedImageVersion
	objectMap := make(map[string]interface{})
	if itsivs.ImageVersionID != nil {
		objectMap["imageVersionId"] = itsivs.ImageVersionID
	}
	if itsivs.Type != "" {
		objectMap["type"] = itsivs.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateIsoSource is the BasicImageTemplateSource implementation for ImageTemplateSharedImageVersionSource.
func (itsivs ImageTemplateSharedImageVersionSource) AsImageTemplateIsoSource() (*ImageTemplateIsoSource, bool) {
	return nil, false
}

// AsImageTemplatePlatformImageSource is the BasicImageTemplateSource implementation for ImageTemplateSharedImageVersionSource.
func (itsivs ImageTemplateSharedImageVersionSource) AsImageTemplatePlatformImageSource() (*ImageTemplatePlatformImageSource, bool) {
	return nil, false
}

// AsImageTemplateManagedImageSource is the BasicImageTemplateSource implementation for ImageTemplateSharedImageVersionSource.
func (itsivs ImageTemplateSharedImageVersionSource) AsImageTemplateManagedImageSource() (*ImageTemplateManagedImageSource, bool) {
	return nil, false
}

// AsImageTemplateSharedImageVersionSource is the BasicImageTemplateSource implementation for ImageTemplateSharedImageVersionSource.
func (itsivs ImageTemplateSharedImageVersionSource) AsImageTemplateSharedImageVersionSource() (*ImageTemplateSharedImageVersionSource, bool) {
	return &itsivs, true
}

// AsImageTemplateSource is the BasicImageTemplateSource implementation for ImageTemplateSharedImageVersionSource.
func (itsivs ImageTemplateSharedImageVersionSource) AsImageTemplateSource() (*ImageTemplateSource, bool) {
	return nil, false
}

// AsBasicImageTemplateSource is the BasicImageTemplateSource implementation for ImageTemplateSharedImageVersionSource.
func (itsivs ImageTemplateSharedImageVersionSource) AsBasicImageTemplateSource() (BasicImageTemplateSource, bool) {
	return &itsivs, true
}

// ImageTemplateShellCustomizer runs a shell script during the customization phase (Linux). Corresponds to
// Packer shell provisioner. Exactly one of 'scriptUri' or 'inline' can be specified.
type ImageTemplateShellCustomizer struct {
	// ScriptURI - URI of the shell script to be run for customizing. It can be a github link, SAS URI for Azure Storage, etc
	ScriptURI *string `json:"scriptUri,omitempty"`
	// Sha256Checksum - SHA256 checksum of the shell script provided in the scriptUri field
	Sha256Checksum *string `json:"sha256Checksum,omitempty"`
	// Inline - Array of shell commands to execute
	Inline *[]string `json:"inline,omitempty"`
	// Name - Friendly Name to provide context on what this customization step does
	Name *string `json:"name,omitempty"`
	// Type - Possible values include: 'TypeImageTemplateCustomizer', 'TypeShell', 'TypeWindowsRestart', 'TypePowerShell', 'TypeFile'
	Type TypeBasicImageTemplateCustomizer `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplateShellCustomizer.
func (itsc ImageTemplateShellCustomizer) MarshalJSON() ([]byte, error) {
	itsc.Type = TypeShell
	objectMap := make(map[string]interface{})
	if itsc.ScriptURI != nil {
		objectMap["scriptUri"] = itsc.ScriptURI
	}
	if itsc.Sha256Checksum != nil {
		objectMap["sha256Checksum"] = itsc.Sha256Checksum
	}
	if itsc.Inline != nil {
		objectMap["inline"] = itsc.Inline
	}
	if itsc.Name != nil {
		objectMap["name"] = itsc.Name
	}
	if itsc.Type != "" {
		objectMap["type"] = itsc.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateShellCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateShellCustomizer.
func (itsc ImageTemplateShellCustomizer) AsImageTemplateShellCustomizer() (*ImageTemplateShellCustomizer, bool) {
	return &itsc, true
}

// AsImageTemplateRestartCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateShellCustomizer.
func (itsc ImageTemplateShellCustomizer) AsImageTemplateRestartCustomizer() (*ImageTemplateRestartCustomizer, bool) {
	return nil, false
}

// AsImageTemplatePowerShellCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateShellCustomizer.
func (itsc ImageTemplateShellCustomizer) AsImageTemplatePowerShellCustomizer() (*ImageTemplatePowerShellCustomizer, bool) {
	return nil, false
}

// AsImageTemplateFileCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateShellCustomizer.
func (itsc ImageTemplateShellCustomizer) AsImageTemplateFileCustomizer() (*ImageTemplateFileCustomizer, bool) {
	return nil, false
}

// AsImageTemplateCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateShellCustomizer.
func (itsc ImageTemplateShellCustomizer) AsImageTemplateCustomizer() (*ImageTemplateCustomizer, bool) {
	return nil, false
}

// AsBasicImageTemplateCustomizer is the BasicImageTemplateCustomizer implementation for ImageTemplateShellCustomizer.
func (itsc ImageTemplateShellCustomizer) AsBasicImageTemplateCustomizer() (BasicImageTemplateCustomizer, bool) {
	return &itsc, true
}

// BasicImageTemplateSource describes a virtual machine image source for building, customizing and distributing
type BasicImageTemplateSource interface {
	AsImageTemplateIsoSource() (*ImageTemplateIsoSource, bool)
	AsImageTemplatePlatformImageSource() (*ImageTemplatePlatformImageSource, bool)
	AsImageTemplateManagedImageSource() (*ImageTemplateManagedImageSource, bool)
	AsImageTemplateSharedImageVersionSource() (*ImageTemplateSharedImageVersionSource, bool)
	AsImageTemplateSource() (*ImageTemplateSource, bool)
}

// ImageTemplateSource describes a virtual machine image source for building, customizing and distributing
type ImageTemplateSource struct {
	// Type - Possible values include: 'TypeImageTemplateSource', 'TypeISO', 'TypePlatformImage', 'TypeManagedImage', 'TypeSharedImageVersion'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicImageTemplateSource(body []byte) (BasicImageTemplateSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeISO):
		var itis ImageTemplateIsoSource
		err := json.Unmarshal(body, &itis)
		return itis, err
	case string(TypePlatformImage):
		var itpis ImageTemplatePlatformImageSource
		err := json.Unmarshal(body, &itpis)
		return itpis, err
	case string(TypeManagedImage):
		var itmis ImageTemplateManagedImageSource
		err := json.Unmarshal(body, &itmis)
		return itmis, err
	case string(TypeSharedImageVersion):
		var itsivs ImageTemplateSharedImageVersionSource
		err := json.Unmarshal(body, &itsivs)
		return itsivs, err
	default:
		var its ImageTemplateSource
		err := json.Unmarshal(body, &its)
		return its, err
	}
}
func unmarshalBasicImageTemplateSourceArray(body []byte) ([]BasicImageTemplateSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	itsArray := make([]BasicImageTemplateSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		its, err := unmarshalBasicImageTemplateSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		itsArray[index] = its
	}
	return itsArray, nil
}

// MarshalJSON is the custom marshaler for ImageTemplateSource.
func (its ImageTemplateSource) MarshalJSON() ([]byte, error) {
	its.Type = TypeImageTemplateSource
	objectMap := make(map[string]interface{})
	if its.Type != "" {
		objectMap["type"] = its.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateIsoSource is the BasicImageTemplateSource implementation for ImageTemplateSource.
func (its ImageTemplateSource) AsImageTemplateIsoSource() (*ImageTemplateIsoSource, bool) {
	return nil, false
}

// AsImageTemplatePlatformImageSource is the BasicImageTemplateSource implementation for ImageTemplateSource.
func (its ImageTemplateSource) AsImageTemplatePlatformImageSource() (*ImageTemplatePlatformImageSource, bool) {
	return nil, false
}

// AsImageTemplateManagedImageSource is the BasicImageTemplateSource implementation for ImageTemplateSource.
func (its ImageTemplateSource) AsImageTemplateManagedImageSource() (*ImageTemplateManagedImageSource, bool) {
	return nil, false
}

// AsImageTemplateSharedImageVersionSource is the BasicImageTemplateSource implementation for ImageTemplateSource.
func (its ImageTemplateSource) AsImageTemplateSharedImageVersionSource() (*ImageTemplateSharedImageVersionSource, bool) {
	return nil, false
}

// AsImageTemplateSource is the BasicImageTemplateSource implementation for ImageTemplateSource.
func (its ImageTemplateSource) AsImageTemplateSource() (*ImageTemplateSource, bool) {
	return &its, true
}

// AsBasicImageTemplateSource is the BasicImageTemplateSource implementation for ImageTemplateSource.
func (its ImageTemplateSource) AsBasicImageTemplateSource() (BasicImageTemplateSource, bool) {
	return &its, true
}

// ImageTemplateUpdateParameters parameters for updating an image template.
type ImageTemplateUpdateParameters struct {
	// Identity - The identity of the image template, if configured.
	Identity *ImageTemplateIdentity `json:"identity,omitempty"`
	// Tags - The user-specified tags associated with the image template.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ImageTemplateUpdateParameters.
func (itup ImageTemplateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itup.Identity != nil {
		objectMap["identity"] = itup.Identity
	}
	if itup.Tags != nil {
		objectMap["tags"] = itup.Tags
	}
	return json.Marshal(objectMap)
}

// ImageTemplateVhdDistributor distribute via VHD in a storage account.
type ImageTemplateVhdDistributor struct {
	// RunOutputName - The name to be used for the associated RunOutput.
	RunOutputName *string `json:"runOutputName,omitempty"`
	// ArtifactTags - Tags that will be applied to the artifact once it has been created/updated by the distributor.
	ArtifactTags map[string]*string `json:"artifactTags"`
	// Type - Possible values include: 'TypeBasicImageTemplateDistributorTypeImageTemplateDistributor', 'TypeBasicImageTemplateDistributorTypeManagedImage', 'TypeBasicImageTemplateDistributorTypeSharedImage', 'TypeBasicImageTemplateDistributorTypeVHD'
	Type TypeBasicImageTemplateDistributor `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTemplateVhdDistributor.
func (itvd ImageTemplateVhdDistributor) MarshalJSON() ([]byte, error) {
	itvd.Type = TypeBasicImageTemplateDistributorTypeVHD
	objectMap := make(map[string]interface{})
	if itvd.RunOutputName != nil {
		objectMap["runOutputName"] = itvd.RunOutputName
	}
	if itvd.ArtifactTags != nil {
		objectMap["artifactTags"] = itvd.ArtifactTags
	}
	if itvd.Type != "" {
		objectMap["type"] = itvd.Type
	}
	return json.Marshal(objectMap)
}

// AsImageTemplateManagedImageDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateVhdDistributor.
func (itvd ImageTemplateVhdDistributor) AsImageTemplateManagedImageDistributor() (*ImageTemplateManagedImageDistributor, bool) {
	return nil, false
}

// AsImageTemplateSharedImageDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateVhdDistributor.
func (itvd ImageTemplateVhdDistributor) AsImageTemplateSharedImageDistributor() (*ImageTemplateSharedImageDistributor, bool) {
	return nil, false
}

// AsImageTemplateVhdDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateVhdDistributor.
func (itvd ImageTemplateVhdDistributor) AsImageTemplateVhdDistributor() (*ImageTemplateVhdDistributor, bool) {
	return &itvd, true
}

// AsImageTemplateDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateVhdDistributor.
func (itvd ImageTemplateVhdDistributor) AsImageTemplateDistributor() (*ImageTemplateDistributor, bool) {
	return nil, false
}

// AsBasicImageTemplateDistributor is the BasicImageTemplateDistributor implementation for ImageTemplateVhdDistributor.
func (itvd ImageTemplateVhdDistributor) AsBasicImageTemplateDistributor() (BasicImageTemplateDistributor, bool) {
	return &itvd, true
}

// ImageTemplateVMProfile describes the virtual machine used to build, customize and capture images
type ImageTemplateVMProfile struct {
	// VMSize - Size of the virtual machine used to build, customize and capture images. Omit or specify empty string to use the default (Standard_D1_v2).
	VMSize *string `json:"vmSize,omitempty"`
}

// InnerError inner error details.
type InnerError struct {
	// ExceptionType - The exception type.
	ExceptionType *string `json:"exceptionType,omitempty"`
	// ErrorDetail - The internal error message or exception dump.
	ErrorDetail *string `json:"errorDetail,omitempty"`
}

// Operation ...
type Operation struct {
	// Name - This is of the format {provider}/{resource}/{operation}
	Name       *string           `json:"name,omitempty"`
	Display    *OperationDisplay `json:"display,omitempty"`
	Origin     *string           `json:"origin,omitempty"`
	Properties interface{}       `json:"properties,omitempty"`
}

// OperationDisplay ...
type OperationDisplay struct {
	Provider *string `json:"provider,omitempty"`
	// Operation - For example: read, write, delete, or listKeys/action
	Operation   *string `json:"operation,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationListResult ...
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// ProvisioningError describes the error happened when create or update an image template
type ProvisioningError struct {
	// ProvisioningErrorCode - Error code of the provisioning failure. Possible values include: 'BadSourceType', 'BadPIRSource', 'BadISOSource', 'BadManagedImageSource', 'BadSharedImageVersionSource', 'BadCustomizerType', 'UnsupportedCustomizerType', 'NoCustomizerScript', 'BadDistributeType', 'BadSharedImageDistribute', 'ServerError', 'Other'
	ProvisioningErrorCode ProvisioningErrorCode `json:"provisioningErrorCode,omitempty"`
	// Message - Verbose error message about the provisioning failure
	Message *string `json:"message,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// RunOutput represents an output that was created by running an image template.
type RunOutput struct {
	autorest.Response `json:"-"`
	// RunOutputProperties - The properties of the run output
	*RunOutputProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RunOutput.
func (ro RunOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ro.RunOutputProperties != nil {
		objectMap["properties"] = ro.RunOutputProperties
	}
	if ro.Name != nil {
		objectMap["name"] = ro.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RunOutput struct.
func (ro *RunOutput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var runOutputProperties RunOutputProperties
				err = json.Unmarshal(*v, &runOutputProperties)
				if err != nil {
					return err
				}
				ro.RunOutputProperties = &runOutputProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ro.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ro.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ro.Type = &typeVar
			}
		}
	}

	return nil
}

// RunOutputCollection the result of List run outputs operation
type RunOutputCollection struct {
	autorest.Response `json:"-"`
	// Value - An array of run outputs
	Value *[]RunOutput `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// RunOutputCollectionIterator provides access to a complete listing of RunOutput values.
type RunOutputCollectionIterator struct {
	i    int
	page RunOutputCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RunOutputCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RunOutputCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RunOutputCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RunOutputCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RunOutputCollectionIterator) Response() RunOutputCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RunOutputCollectionIterator) Value() RunOutput {
	if !iter.page.NotDone() {
		return RunOutput{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RunOutputCollectionIterator type.
func NewRunOutputCollectionIterator(page RunOutputCollectionPage) RunOutputCollectionIterator {
	return RunOutputCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (roc RunOutputCollection) IsEmpty() bool {
	return roc.Value == nil || len(*roc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (roc RunOutputCollection) hasNextLink() bool {
	return roc.NextLink != nil && len(*roc.NextLink) != 0
}

// runOutputCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (roc RunOutputCollection) runOutputCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !roc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(roc.NextLink)))
}

// RunOutputCollectionPage contains a page of RunOutput values.
type RunOutputCollectionPage struct {
	fn  func(context.Context, RunOutputCollection) (RunOutputCollection, error)
	roc RunOutputCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RunOutputCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RunOutputCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.roc)
		if err != nil {
			return err
		}
		page.roc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RunOutputCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RunOutputCollectionPage) NotDone() bool {
	return !page.roc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RunOutputCollectionPage) Response() RunOutputCollection {
	return page.roc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RunOutputCollectionPage) Values() []RunOutput {
	if page.roc.IsEmpty() {
		return nil
	}
	return *page.roc.Value
}

// Creates a new instance of the RunOutputCollectionPage type.
func NewRunOutputCollectionPage(cur RunOutputCollection, getNextPage func(context.Context, RunOutputCollection) (RunOutputCollection, error)) RunOutputCollectionPage {
	return RunOutputCollectionPage{
		fn:  getNextPage,
		roc: cur,
	}
}

// RunOutputProperties describes the properties of a run output
type RunOutputProperties struct {
	// ArtifactID - The resource id of the artifact.
	ArtifactID *string `json:"artifactId,omitempty"`
	// ArtifactURI - The location URI of the artifact.
	ArtifactURI *string `json:"artifactUri,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Creating', 'Updating', 'Succeeded', 'Failed', 'Deleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for RunOutputProperties.
func (rop RunOutputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rop.ArtifactID != nil {
		objectMap["artifactId"] = rop.ArtifactID
	}
	if rop.ArtifactURI != nil {
		objectMap["artifactUri"] = rop.ArtifactURI
	}
	return json.Marshal(objectMap)
}

// SubResource the Sub Resource model definition.
type SubResource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubResource.
func (sr SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	return json.Marshal(objectMap)
}

// VirtualMachineImageTemplatesCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualMachineImageTemplatesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineImageTemplatesClient) (ImageTemplate, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineImageTemplatesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineImageTemplatesCreateOrUpdateFuture.Result.
func (future *VirtualMachineImageTemplatesCreateOrUpdateFuture) result(client VirtualMachineImageTemplatesClient) (it ImageTemplate, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplatesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		it.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("virtualmachineimagebuilder.VirtualMachineImageTemplatesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if it.Response.Response, err = future.GetResult(sender); err == nil && it.Response.Response.StatusCode != http.StatusNoContent {
		it, err = client.CreateOrUpdateResponder(it.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplatesCreateOrUpdateFuture", "Result", it.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineImageTemplatesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineImageTemplatesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineImageTemplatesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineImageTemplatesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineImageTemplatesDeleteFuture.Result.
func (future *VirtualMachineImageTemplatesDeleteFuture) result(client VirtualMachineImageTemplatesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplatesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("virtualmachineimagebuilder.VirtualMachineImageTemplatesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineImageTemplatesRunFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineImageTemplatesRunFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineImageTemplatesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineImageTemplatesRunFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineImageTemplatesRunFuture.Result.
func (future *VirtualMachineImageTemplatesRunFuture) result(client VirtualMachineImageTemplatesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplatesRunFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("virtualmachineimagebuilder.VirtualMachineImageTemplatesRunFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineImageTemplatesUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineImageTemplatesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualMachineImageTemplatesClient) (ImageTemplate, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VirtualMachineImageTemplatesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VirtualMachineImageTemplatesUpdateFuture.Result.
func (future *VirtualMachineImageTemplatesUpdateFuture) result(client VirtualMachineImageTemplatesClient) (it ImageTemplate, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplatesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		it.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("virtualmachineimagebuilder.VirtualMachineImageTemplatesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if it.Response.Response, err = future.GetResult(sender); err == nil && it.Response.Response.StatusCode != http.StatusNoContent {
		it, err = client.UpdateResponder(it.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "virtualmachineimagebuilder.VirtualMachineImageTemplatesUpdateFuture", "Result", it.Response.Response, "Failure responding to request")
		}
	}
	return
}
