/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.dtd;

import com.thaiopensource.relaxng.edit.AbstractPatternVisitor;
import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.util.VoidValue;
import java.util.Iterator;
import java.util.List;

class Simplifier
extends AbstractPatternVisitor<Pattern>
implements ComponentVisitor<VoidValue> {
    public static void simplify(SchemaCollection schemaCollection) {
        Simplifier simplifier = new Simplifier();
        for (SchemaDocument schemaDocument : schemaCollection.getSchemaDocumentMap().values()) {
            schemaDocument.setPattern(schemaDocument.getPattern().accept(simplifier));
        }
    }

    private Simplifier() {
    }

    @Override
    public Pattern visitGrammar(GrammarPattern grammarPattern) {
        this.visitContainer(grammarPattern);
        return grammarPattern;
    }

    public VoidValue visitContainer(Container container) {
        for (Component component : container.getComponents()) {
            component.accept(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitInclude(IncludeComponent includeComponent) {
        return this.visitContainer(includeComponent);
    }

    @Override
    public VoidValue visitDiv(DivComponent divComponent) {
        return this.visitContainer(divComponent);
    }

    @Override
    public VoidValue visitDefine(DefineComponent defineComponent) {
        defineComponent.setBody(defineComponent.getBody().accept(this));
        return VoidValue.VOID;
    }

    @Override
    public Pattern visitChoice(ChoicePattern choicePattern) {
        boolean bl = false;
        List<Pattern> list = choicePattern.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.set(i, list.get(i).accept(this));
        }
        Object object = list.iterator();
        while (object.hasNext()) {
            Pattern pattern = object.next();
            if (pattern instanceof NotAllowedPattern) {
                object.remove();
                continue;
            }
            if (!(pattern instanceof EmptyPattern)) continue;
            bl = true;
            object.remove();
        }
        if (list.size() == 0) {
            return Simplifier.copy(new NotAllowedPattern(), choicePattern);
        }
        object = list.size() == 1 ? list.get(0) : choicePattern;
        if (bl && !(object instanceof OptionalPattern) && !(object instanceof ZeroOrMorePattern)) {
            object = object instanceof OneOrMorePattern ? new ZeroOrMorePattern(((OneOrMorePattern)object).getChild()) : new OptionalPattern((Pattern)object);
            Simplifier.copy(object, choicePattern);
        }
        return object;
    }

    @Override
    public Pattern visitComposite(CompositePattern compositePattern) {
        List<Pattern> list = compositePattern.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.set(i, list.get(i).accept(this));
        }
        Iterator<Pattern> iterator = list.iterator();
        while (iterator.hasNext()) {
            Pattern pattern = iterator.next();
            if (!(pattern instanceof EmptyPattern)) continue;
            iterator.remove();
        }
        if (list.size() == 0) {
            return Simplifier.copy(new EmptyPattern(), compositePattern);
        }
        if (list.size() == 1) {
            return compositePattern.getChildren().get(0);
        }
        return compositePattern;
    }

    @Override
    public Pattern visitInterleave(InterleavePattern interleavePattern) {
        boolean bl = false;
        Iterator<Pattern> iterator = interleavePattern.getChildren().iterator();
        while (iterator.hasNext()) {
            Pattern pattern = iterator.next();
            if (!(pattern instanceof TextPattern)) continue;
            iterator.remove();
            bl = true;
        }
        if (!bl) {
            return this.visitComposite(interleavePattern);
        }
        return Simplifier.copy(new MixedPattern(this.visitComposite(interleavePattern)), interleavePattern);
    }

    @Override
    public Pattern visitUnary(UnaryPattern unaryPattern) {
        unaryPattern.setChild(unaryPattern.getChild().accept(this));
        return unaryPattern;
    }

    private static <T extends Annotated> T copy(T t, T t2) {
        t.setSourceLocation(t2.getSourceLocation());
        return t;
    }

    @Override
    public Pattern visitPattern(Pattern pattern) {
        return pattern;
    }
}

