/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Node;
import writer2latex.office.OfficeStyle;
import writer2latex.util.Misc;

public class OfficeStyleFamily {
    private Hashtable styles = new Hashtable();
    private Class styleClass;
    private OfficeStyle defaultStyle = null;

    public OfficeStyleFamily(Class styleClass) {
        this.styleClass = styleClass;
    }

    public void setDefaultStyle(OfficeStyle style) {
        this.defaultStyle = style;
    }

    public OfficeStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public OfficeStyle getStyle(String sName) {
        if (sName == null) {
            return null;
        }
        return (OfficeStyle)this.styles.get(sName);
    }

    public Enumeration getStylesEnumeration() {
        return this.styles.elements();
    }

    public void loadStyleFromDOM(Node node, boolean bAutomatic) {
        String sName = Misc.getAttribute(node, "style:name");
        if (sName != null) {
            try {
                OfficeStyle style = (OfficeStyle)this.styleClass.newInstance();
                style.sName = sName;
                style.family = this;
                style.bAutomatic = bAutomatic;
                style.loadStyleFromDOM(node);
                this.styles.put(sName, style);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

