package com.jclark.xsl.sax;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.OutputStream;
import java.io.Writer;
import java.io.OutputStreamWriter;

public abstract class GenericDestination implements Destination {
  private String encoding;

  public String getEncoding() {
    return encoding;
  }

  protected void setEncoding(String encoding) {
    if (encoding == null)
      this.encoding = "UTF-8";
    else
      this.encoding = EncodingName.toIana(encoding);
  }

  public boolean keepOpen() {
    return false;
  }

  public Writer getWriter(String contentType, String encoding)
    throws IOException, UnsupportedEncodingException {
    OutputStream out = getOutputStream(contentType, encoding);
    return new OutputStreamWriter(out, EncodingName.toJava(getEncoding()));
  }

  public Destination resolve(String uri) {
    return null;
  }
}
